<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}
include 'includes/conn.php';
// require admin or manager
if (!isset($_SESSION['schoolsyslevel']) || ( (int)$_SESSION['schoolsyslevel'] !== 1 && (int)$_SESSION['schoolsyslevel'] !== 2 )) {
  header('Location:login.php');
  exit;
}

// validate id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT) ?: 0;
if ($id <= 0) {
  header('Location: attendance.php');
  exit;
}

// fetch attendance row safely
$date = '';
$time = '';
$attendance_id = 0;
$astmt = mysqli_prepare($con, "SELECT `date`,`time`,`attendance_id` FROM attendance WHERE status=1 AND attendance_id=? LIMIT 1");
if ($astmt) {
  mysqli_stmt_bind_param($astmt, 'i', $id);
  mysqli_stmt_execute($astmt);
  mysqli_stmt_bind_result($astmt, $date_result, $time_result, $attid_result);
  if (mysqli_stmt_fetch($astmt)) {
    $date = $date_result;  // date is now stored as DATE (Y-m-d)
    $time = $time_result;
    $attendance_id = (int)$attid_result;
  }
  mysqli_stmt_close($astmt);
} else {
  $qid = (int)$id;
  $attendance = mysqli_query($con, "SELECT `date`,`time`,`attendance_id` FROM attendance WHERE status=1 AND attendance_id='$qid'");
  if ($attendance && mysqli_num_rows($attendance) > 0) {
    $row1 = mysqli_fetch_assoc($attendance);
    $date = $row1['date'] ?? '';  // date is now stored as DATE (Y-m-d)
    $time = $row1['time'] ?? '';
    $attendance_id = (int)($row1['attendance_id'] ?? 0);
  }
}

if ($attendance_id <= 0) {
  // nothing found
  header('Location: attendance.php');
  exit;
}

// Format date for display
$date_formatted = '';
if ($date) {
  $date_obj = DateTime::createFromFormat('Y-m-d', $date);
  $date_formatted = $date_obj ? $date_obj->format('d/M/Y') : $date;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Attendance for <?php echo htmlspecialchars($date_formatted, ENT_QUOTES); ?></title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
      <header class="panel-heading">
              
                <a href="printattendancedetails?attendance=<?php echo (int)$id; ?>" class="btn  btn-info pull-right" target="_blank">Print</a>
              </header>
        <div class="col-lg-4">
          <section class="panel">
            <header class="panel-heading">
              Attendees for <?php echo htmlspecialchars($date_formatted . ' ' . $time, ENT_QUOTES); ?>
            </header>
            <div class="panel-body">
              <table class="display table  table-striped">
                <thead>
                  <tr>
                    <th>Fullname</th>
                    <th>Gender</th>

                  </tr>
                </thead>
                <tbody>

                  <?php
                  // reuse a prepared query that joins attendancedetails with students
                  $detail_stmt = mysqli_prepare($con, "SELECT ad.student_id, ad.details, s.regnumber, s.fullname, s.gender FROM attendancedetails ad LEFT JOIN students s ON s.student_id = ad.student_id WHERE ad.attendance_id = ? AND ad.status = ?");
                  if ($detail_stmt) {
                      $status = 1;
                      mysqli_stmt_bind_param($detail_stmt, 'ii', $attendance_id, $status);
                      mysqli_stmt_execute($detail_stmt);
                      $res = mysqli_stmt_get_result($detail_stmt);
                      while ($row1 = mysqli_fetch_assoc($res)) {
                          $fullname = $row1['fullname'] ?? '';
                          $gender = $row1['gender'] ?? '';
                  ?>
                    <tr class="gradeA">
                      <td>
                        <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                      </td>

                      <td>
                        <?php echo htmlspecialchars($gender, ENT_QUOTES); ?></td>


                    </tr>
                  <?php }
                      mysqli_stmt_close($detail_stmt);
                  } else {
                      // fallback
                      $aid = (int)$id;
                      $attendees = mysqli_query($con, "SELECT * FROM attendancedetails WHERE attendance_id='$aid' AND status=1") or die(mysqli_error($con));
                      while ($row1 = mysqli_fetch_assoc($attendees)) {
                          $student_id = (int)$row1['student_id'];
                          $students = mysqli_query($con, "SELECT * FROM students WHERE student_id='$student_id'");
                          $row = mysqli_fetch_assoc($students);
                          $fullname = $row['fullname'] ?? '';
                          $gender = $row['gender'] ?? '';
                  ?>
                    <tr class="gradeA">
                      <td>
                        <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                      </td>

                      <td>
                        <?php echo htmlspecialchars($gender, ENT_QUOTES); ?></td>


                    </tr>
                  <?php }
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </section>
        </div>
        <div class="col-lg-4">
          <section class="panel">
            <header class="panel-heading">
              Late for <?php echo htmlspecialchars($date_formatted . ' ' . $time, ENT_QUOTES); ?>
            </header>
            <div class="panel-body">
              <table class="display table  table-striped">
                <thead>
                  <tr>
                    <th>Fullname</th>
                    <th>Gender</th>
                    <th>&nbsp;</th>

                  </tr>
                </thead>
                <tbody>

                  <?php
                  // late = status 2
                  $detail_stmt2 = mysqli_prepare($con, "SELECT ad.student_id, ad.details, s.regnumber, s.fullname, s.gender FROM attendancedetails ad LEFT JOIN students s ON s.student_id = ad.student_id WHERE ad.attendance_id = ? AND ad.status = ?");
                  if ($detail_stmt2) {
                      $status2 = 2;
                      mysqli_stmt_bind_param($detail_stmt2, 'ii', $attendance_id, $status2);
                      mysqli_stmt_execute($detail_stmt2);
                      $res2 = mysqli_stmt_get_result($detail_stmt2);
                      while ($row1 = mysqli_fetch_assoc($res2)) {
                          $fullname = $row1['fullname'] ?? '';
                          $gender = $row1['gender'] ?? '';
                          $details = $row1['details'] ?? '';
                  ?>
                    <tr class="gradeA">
                      <td>
                        <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                      </td>
                      <td>
                        <?php echo htmlspecialchars($gender, ENT_QUOTES); ?></td>
                      <td>
                        <?php echo htmlspecialchars($details, ENT_QUOTES); ?></td>

                    </tr>
                  <?php }
                      mysqli_stmt_close($detail_stmt2);
                  } else {
                      $aid = (int)$id;
                      $attendees_l = mysqli_query($con, "SELECT * FROM attendancedetails WHERE attendance_id='$aid' AND status=2") or die(mysqli_error($con));
                      while ($row1 = mysqli_fetch_assoc($attendees_l)) {
                          $student_id = (int)$row1['student_id'];
                          $details = $row1['details'];
                          $students = mysqli_query($con, "SELECT * FROM students WHERE student_id='$student_id'");
                          $row = mysqli_fetch_assoc($students);
                          $fullname = $row['fullname'] ?? '';
                          $gender = $row['gender'] ?? '';
                  ?>
                    <tr class="gradeA">
                      <td>
                        <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                      </td>
                      <td>
                        <?php echo htmlspecialchars($gender, ENT_QUOTES); ?></td>
                      <td>
                        <?php echo htmlspecialchars($details, ENT_QUOTES); ?></td>

                    </tr>
                  <?php }
                  }
                  ?>
                </tbody>
              </table>
            </div>
        </div>
        <div class="col-lg-4">
          <section class="panel">
            <header class="panel-heading">
              Absentees for <?php echo htmlspecialchars($date_formatted . ' ' . $time, ENT_QUOTES); ?>
            </header>
            <div class="panel-body">
              <table class="display table  table-striped">
                <thead>
                  <tr>
                    <th>Fullname</th>
                    <th>Gender</th>
                    <th>&nbsp;</th>
                  </tr>
                </thead>
                <tbody>

                  <?php
                  // absentees status 0
                  $detail_stmt3 = mysqli_prepare($con, "SELECT ad.student_id, ad.details, s.regnumber, s.fullname, s.gender FROM attendancedetails ad LEFT JOIN students s ON s.student_id = ad.student_id WHERE ad.attendance_id = ? AND ad.status = ?");
                  if ($detail_stmt3) {
                      $status3 = 0;
                      mysqli_stmt_bind_param($detail_stmt3, 'ii', $attendance_id, $status3);
                      mysqli_stmt_execute($detail_stmt3);
                      $res3 = mysqli_stmt_get_result($detail_stmt3);
                      while ($row1 = mysqli_fetch_assoc($res3)) {
                          $fullname = $row1['fullname'] ?? '';
                          $gender = $row1['gender'] ?? '';
                          $details = $row1['details'] ?? '';
                  ?>
                    <tr class="gradeA">
                      <td>
                        <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                      </td>

                      <td>
                        <?php echo htmlspecialchars($gender, ENT_QUOTES); ?></td>
                      <td>
                        <?php echo htmlspecialchars($details, ENT_QUOTES); ?></td>

                    </tr>
                  <?php }
                      mysqli_stmt_close($detail_stmt3);
                  } else {
                      $aid = (int)$id;
                      $attendees = mysqli_query($con, "SELECT * FROM attendancedetails WHERE attendance_id='$aid' AND status=0") or die(mysqli_error($con));
                      while ($row1 = mysqli_fetch_assoc($attendees)) {
                          $student_id = (int)$row1['student_id'];
                          $details = $row1['details'];
                          $students = mysqli_query($con, "SELECT * FROM students WHERE student_id='$student_id'");
                          $row = mysqli_fetch_assoc($students);
                          $fullname = $row['fullname'] ?? '';
                          $gender = $row['gender'] ?? '';
                  ?>
                    <tr class="gradeA">
                      <td>
                        <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                      </td>

                      <td>
                        <?php echo htmlspecialchars($gender, ENT_QUOTES); ?></td>
                      <td>
                        <?php echo htmlspecialchars($details, ENT_QUOTES); ?></td>

                    </tr>
                  <?php }
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </section>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

</body>

</html>