<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}
include 'includes/conn.php';
// require admin or manager
if (!isset($_SESSION['schoolsyslevel']) || ( (int)$_SESSION['schoolsyslevel'] !== 1 && (int)$_SESSION['schoolsyslevel'] !== 2 ) ) {
  header('Location:login.php');
  exit;
}

// validate GET params
$id = filter_input(INPUT_GET, 'term', FILTER_VALIDATE_INT) ?: 0;
$cl = filter_input(INPUT_GET, 'class', FILTER_VALIDATE_INT) ?: 0;
if ($id <= 0 || $cl <= 0) {
  header('Location: index.php');
  exit;
}

// fetch term safely
$term = '';
$year = '';
$tstmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");
if ($tstmt) {
  mysqli_stmt_bind_param($tstmt, 'i', $id);
  mysqli_stmt_execute($tstmt);
  mysqli_stmt_bind_result($tstmt, $term_result, $year_result);
  if (mysqli_stmt_fetch($tstmt)) {
    $term = $term_result;
    $year = $year_result;
  }
  mysqli_stmt_close($tstmt);
} else {
  $qid = (int)$id;
  $res = mysqli_query($con, "SELECT term, year FROM financialterms WHERE financialterm_id='$qid'");
  if ($res) {
    $r = mysqli_fetch_assoc($res);
    $term = $r['term'] ?? '';
    $year = $r['year'] ?? '';
  }
}

// fetch class safely
$class = '';
$cstmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
if ($cstmt) {
  mysqli_stmt_bind_param($cstmt, 'i', $cl);
  mysqli_stmt_execute($cstmt);
  mysqli_stmt_bind_result($cstmt, $class_result);
  if (mysqli_stmt_fetch($cstmt)) {
    $class = $class_result;
  }
  mysqli_stmt_close($cstmt);
} else {
  $qcl = (int)$cl;
  $cres = mysqli_query($con, "SELECT class FROM classes WHERE class_id='$qcl'");
  if ($cres) {
    $r = mysqli_fetch_assoc($cres);
    $class = $r['class'] ?? '';
  }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Attendance for <?php echo htmlspecialchars((string)$class, ENT_QUOTES) . ' Term ' . htmlspecialchars((string)$term, ENT_QUOTES) . ' ' . htmlspecialchars((string)$year, ENT_QUOTES); ?></title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-8">
          <section class="panel">
            <header class="panel-heading">
              Attendance for <?php echo $class . ' Term ' . $term . ' ' . $year; ?>
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table-2">
                <thead>
                  <tr>
                    <th>Date</th>
                    <th>Attendees</th>
                    <th>Late</th>
                    <th>Absentees</th>
                    <th>Action</th>

                  </tr>
                </thead>
                <tbody>

                  <?php
                  // fetch attendance rows safely with prepared statement and fallback
                  $rows = [];
                  $att_stmt = mysqli_prepare($con, "SELECT attendance_id, `date` FROM attendance WHERE status=1 AND term_id=? AND class_id=? ORDER BY `date` DESC");
                  if ($att_stmt) {
                      mysqli_stmt_bind_param($att_stmt, 'ii', $id, $cl);
                      mysqli_stmt_execute($att_stmt);
                      $res = mysqli_stmt_get_result($att_stmt);
                      while ($r = mysqli_fetch_assoc($res)) {
                          $rows[] = $r;
                      }
                      mysqli_stmt_close($att_stmt);
                  } else {
                      $qid = (int)$id;
                      $qcl = (int)$cl;
                      $res = mysqli_query($con, "SELECT attendance_id, `date` FROM attendance WHERE status=1 AND term_id='$qid' AND class_id='$qcl' ORDER BY `date` DESC");
                      while ($r = mysqli_fetch_assoc($res)) $rows[] = $r;
                  }

                  // prepare count statement for attendancedetails
                  $count_stmt = mysqli_prepare($con, "SELECT COUNT(*) AS cnt FROM attendancedetails WHERE attendance_id = ? AND status = ?");
                  foreach ($rows as $row1) {
                      $date_str = $row1['date'] ?? '';
                      $attendance_id = (int)($row1['attendance_id'] ?? 0);
                  ?>
                    <tr class="gradeA">
                      <td>
                        <?php 
                        // date is now stored as DATE (Y-m-d), convert to d/M/Y for display
                        if ($date_str) {
                          $date_obj = DateTime::createFromFormat('Y-m-d', $date_str);
                          echo $date_obj ? $date_obj->format('d/M/Y') : htmlspecialchars($date_str);
                        }
                        ?>
                      </td>
                      <td>
                        <?php
                        // count presenters (status=1)
                        $cnt_present = 0;
                        $cnt_late = 0;
                        $cnt_absent = 0;
                        if ($count_stmt) {
                            // present
                            $present_status = 1;
                            mysqli_stmt_bind_param($count_stmt, 'ii', $attendance_id, $present_status);
                            mysqli_stmt_execute($count_stmt);
                            mysqli_stmt_bind_result($count_stmt, $cnt_present);
                            mysqli_stmt_fetch($count_stmt);
                            // late
                            $late_status = 2;
                            mysqli_stmt_bind_param($count_stmt, 'ii', $attendance_id, $late_status);
                            mysqli_stmt_execute($count_stmt);
                            mysqli_stmt_bind_result($count_stmt, $cnt_late);
                            mysqli_stmt_fetch($count_stmt);
                            // absent
                            $absent_status = 0;
                            mysqli_stmt_bind_param($count_stmt, 'ii', $attendance_id, $absent_status);
                            mysqli_stmt_execute($count_stmt);
                            mysqli_stmt_bind_result($count_stmt, $cnt_absent);
                            mysqli_stmt_fetch($count_stmt);
                        } else {
                            // fallback queries
                            $aid = (int)$attendance_id;
                            $r1 = mysqli_query($con, "SELECT COUNT(*) AS cnt FROM attendancedetails WHERE attendance_id='$aid' AND status=1");
                            $cnt_present = $r1 ? (int)mysqli_fetch_assoc($r1)['cnt'] : 0;
                            $r2 = mysqli_query($con, "SELECT COUNT(*) AS cnt FROM attendancedetails WHERE attendance_id='$aid' AND status=2");
                            $cnt_late = $r2 ? (int)mysqli_fetch_assoc($r2)['cnt'] : 0;
                            $r3 = mysqli_query($con, "SELECT COUNT(*) AS cnt FROM attendancedetails WHERE attendance_id='$aid' AND status=0");
                            $cnt_absent = $r3 ? (int)mysqli_fetch_assoc($r3)['cnt'] : 0;
                        }
                        echo (int)$cnt_present;
                        ?></td>
                      <td><?php echo (int)$cnt_late; ?></td>
                      <td><?php echo (int)$cnt_absent; ?></td>

                      <td><a href="attendancedetails?id=<?php echo (int)$attendance_id; ?>" class="btn btn-xs btn-info">Details</a></td>
                    </tr>
                  <?php } 
                  if ($count_stmt) mysqli_stmt_close($count_stmt);
                  ?>
                </tbody>
              </table>
            </div>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script>
    $(document).ready(function() {
      $('#dynamic-table-2').dataTable({
        "aaSorting": [
          [0, "desc"]
        ]
      });
    })
  </script>

</body>

</html>