<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
include 'includes/conn.php';
// require super-admin
if (!isset($_SESSION['schoolsyslevel']) || (int)$_SESSION['schoolsyslevel'] !== 1) {
    header('Location:login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Assessment Types</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
             <div class="row">
          <div class="col-lg-5">
                      <section class="panel">
                    <header class="panel-heading">
                   Add Assessment Type
                    </header>
                          <div class="panel-body">
                           <?php
                     if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['type'])) {
                       $errors = [];
                       $type = trim($_POST['type']);
                       if ($type === '') {
                         $errors[] = 'Enter All Fields To Proceed';
                       }

                       // check duplicate using prepared statement
                       $exists = false;
                       $chk = mysqli_prepare($con, "SELECT assessmenttype_id FROM assessmenttypes WHERE assessmenttype = ? LIMIT 1");
                       if ($chk) {
                         mysqli_stmt_bind_param($chk, 's', $type);
                         mysqli_stmt_execute($chk);
                         mysqli_stmt_store_result($chk);
                         if (mysqli_stmt_num_rows($chk) > 0) $exists = true;
                         mysqli_stmt_close($chk);
                       } else {
                         // fallback
                         $esc = mysqli_real_escape_string($con, $type);
                         $q = mysqli_query($con, "SELECT assessmenttype_id FROM assessmenttypes WHERE assessmenttype='" . $esc . "' LIMIT 1");
                         if ($q && mysqli_num_rows($q) > 0) $exists = true;
                       }

                       if ($exists) {
                         $errors[] = 'Assessment Name Already Exists';
                       }

                       if (!empty($errors)) {
                         foreach ($errors as $error) {
                           echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                         }
                       } else {
                         // Insert new assessment type with prepared statement and escaped fallback
                         $ins = mysqli_prepare($con, "INSERT INTO assessmenttypes(assessmenttype,creator,status) VALUES(?,?,1)");
                         $creator = isset($_SESSION['schoolsys']) ? $_SESSION['schoolsys'] : '';
                         if ($ins) {
                           mysqli_stmt_bind_param($ins, 'ss', $type, $creator);
                           $ok = mysqli_stmt_execute($ins);
                           mysqli_stmt_close($ins);
                           if ($ok) {
                             echo '<div class="alert alert-success"><i class="fa fa-check"></i>Assessment Type successfully added</div>';
                           } else {
                             echo '<div class="alert alert-danger">Failed to add assessment type</div>';
                           }
                         } else {
                           $q_type = mysqli_real_escape_string($con, $type);
                           $q_creator = mysqli_real_escape_string($con, $creator);
                           if (mysqli_query($con, "INSERT INTO assessmenttypes(assessmenttype,creator,status) VALUES('" . $q_type . "','" . $q_creator . "',1)")) {
                             echo '<div class="alert alert-success"><i class="fa fa-check"></i>Assessment Type successfully added</div>';
                           } else {
                             echo '<div class="alert alert-danger">Failed to add assessment type</div>';
                           }
                         }
                       }
                     }
              ?>
  <form method="post" class="form" action=''  name="form" enctype="multipart/form-data">
                                <div class="form-group"><label class="control-label">Assessment Type</label>
                               <input type="text" class="form-control" name='type' placeholder="Enter Type" required='required'>
                                </div>
                               <div class="form-group">
                 <button class="btn btn-primary" name="submit" type="submit">Add Type</button>
                                                               </div>
                            </form 
                          </div>
                      </section>
                          </div>
    <div class="col-lg-7">
                      <section class="panel">
                    <header class="panel-heading">
                  Assessment Types
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped">
        <thead>
        <tr>
                   <th>Type</th>
                                    <th>Action</th>
                  </tr>
        </thead>
        <tbody>
               <?php
                             $gettypes=mysqli_query($con,"SELECT * FROM assessmenttypes WHERE status=1");
                            while ($row = mysqli_fetch_array($gettypes)) {
                                    $type_id=$row['assessmenttype_id'];
                                    $assessment=$row['assessmenttype'];    
                                                              ?>
                <tr class="gradeA">
               <td><?php echo htmlspecialchars($assessment, ENT_QUOTES); ?></td>
                                                <td>
                                           <?php
                                      if(($_SESSION['schoolsyslevel']==1)){
                                   ?>
                                       <a href="editassessment?id=<?php echo $type_id; ?>" class="btn btn-xs btn-success"><i class="fa fa-edit"></i> Edit </a>
                                       <a href="hidetype?id=<?php echo $type_id; ?>" class="btn btn-xs btn-danger" onclick="return confirm_delete<?php echo $type_id;?>()"><i class="fa fa-trash-o"></i>Remove</a>
                                        <?php } ?>                                                                     
                                   </td>                                     
                                   <script type="text/javascript">
                    function confirm_delete<?php echo (int)$type_id; ?>() {
                      return confirm('You are about To Remove this Item. Are you sure you want to proceed?');
                    }
                    </script>              
                </tr>
            <?php } ?>
        </tbody>
                        </table>
                          </div>
                          </section>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
