<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Session and permission check
$session_user = $_SESSION['user_id'] ?? $_SESSION['schoolsys'] ?? null;
if (empty($session_user)) {
    header('Location: login.php');
    exit();
}

$user_level = $_SESSION['schoolsyslevel'] ?? null;
if (!hasFinancialAccess($user_level)) {
    $_SESSION['message'] = 'You do not have permission to approve requisitions.';
    $_SESSION['msg_type'] = 'danger';
    header('Location: stockrequisitions.php');
    exit();
}

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    $_SESSION['message'] = 'Invalid requisition id.';
    $_SESSION['msg_type'] = 'danger';
    header('Location: stockrequisitions.php');
    exit();
}

// Update record: set Approved, approved_by and approval_date
$sql = "UPDATE stock_requisitions SET approval_status = 'Approved', approved_by = ?, approval_date = CURDATE(), updated_at = NOW() WHERE requisition_id = ?";
$stmt = mysqli_prepare($con, $sql);
if (!$stmt) {
    $_SESSION['message'] = 'Failed to prepare statement: ' . mysqli_error($con);
    $_SESSION['msg_type'] = 'danger';
    header('Location: stockrequisitions.php');
    exit();
}
mysqli_stmt_bind_param($stmt, 'ii', $session_user, $id);
$ok = mysqli_stmt_execute($stmt);
mysqli_stmt_close($stmt);

if ($ok) {
    $_SESSION['message'] = 'Requisition approved.';
    $_SESSION['msg_type'] = 'success';
} else {
    $_SESSION['message'] = 'Failed to approve requisition: ' . mysqli_error($con);
    $_SESSION['msg_type'] = 'danger';
}

header('Location: stockrequisitions.php');
exit();


?>
