<?php
// Sync family data with student records
include '../includes/conn.php';
session_start();

if (!isset($_SESSION['schoolsyslevel']) || !in_array($_SESSION['schoolsyslevel'], [1,2,3,8])){
    http_response_code(403);
    exit('Unauthorized');
}

// Check if required tables exist
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'families'");
if (!$tableCheck || mysqli_num_rows($tableCheck) == 0) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database tables not set up. Run sql/family_discount_enhancements.sql first.']);
    exit;
}

// Get all students without family assignment
$students = mysqli_query($con, "SELECT * FROM students WHERE status = 1 AND (family_id IS NULL OR family_id = 0)");

$assigned = 0;
$newFamilies = 0;

while ($student = mysqli_fetch_assoc($students)) {
    $studentId = (int)$student['student_id'];
    $fphone = mysqli_real_escape_string($con, trim($student['fatherphone']));
    $mphone = mysqli_real_escape_string($con, trim($student['motherphone']));
    $femail = mysqli_real_escape_string($con, trim($student['fatheremail']));
    $memail = mysqli_real_escape_string($con, trim($student['motheremail']));
    
    // Try to find existing family
    $searchParts = [];
    if ($fphone !== '') $searchParts[] = "fatherphone='$fphone'";
    if ($mphone !== '') $searchParts[] = "motherphone='$mphone'";
    if ($femail !== '') $searchParts[] = "fatheremail='$femail'";
    if ($memail !== '') $searchParts[] = "motheremail='$memail'";
    
    if (!empty($searchParts)) {
        $where = implode(' OR ', $searchParts);
        $existingQ = mysqli_query($con, "SELECT * FROM students WHERE ($where) AND status=1 AND student_id!=$studentId AND family_id > 0 LIMIT 1");
        
        if ($existingQ && mysqli_num_rows($existingQ) > 0) {
            $existing = mysqli_fetch_assoc($existingQ);
            $familyId = (int)$existing['family_id'];
            
            // Assign to existing family
            mysqli_query($con, "UPDATE students SET family_id=$familyId WHERE student_id=$studentId");
            $assigned++;
        } else {
            // Create new family
            $familyName = mysqli_real_escape_string($con, "Family - " . $student['fullname']);
            $contactName = mysqli_real_escape_string($con, $student['fathername'] ?: $student['mothername']);
            $contactPhone = $fphone ?: $mphone;
            $contactEmail = $femail ?: $memail;
            
            $insertFamily = mysqli_query($con, "INSERT INTO families (family_name, primary_contact_name, primary_contact_phone, primary_contact_email, total_students, status) VALUES ('$familyName', '$contactName', '$contactPhone', '$contactEmail', 1, 1)");
            
            if ($insertFamily) {
                $newFamilyId = mysqli_insert_id($con);
                mysqli_query($con, "UPDATE students SET family_id=$newFamilyId WHERE student_id=$studentId");
                $newFamilies++;
                $assigned++;
            }
        }
    }
}

echo json_encode([
    'success' => true, 
    'assigned' => $assigned, 
    'new_families' => $newFamilies,
    'message' => "$assigned students assigned to families. $newFamilies new families created."
]);
?>
