<?php
// Recalculate fees for a specific student across all terms
include '../includes/conn.php';
session_start();

if (!isset($_SESSION['schoolsyslevel']) || !in_array($_SESSION['schoolsyslevel'], [1,2,3,8,10])){
    http_response_code(403);
    exit('Unauthorized');
}

// Check if stored procedure exists
$procCheck = mysqli_query($con, "SHOW PROCEDURE STATUS WHERE Name = 'sp_calculate_student_fees'");
if (!$procCheck || mysqli_num_rows($procCheck) == 0) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database stored procedure not set up. Run sql/family_discount_enhancements.sql first.']);
    exit;
}

$studentId = isset($_POST['student_id']) ? (int)$_POST['student_id'] : 0;

if ($studentId <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid student ID']);
    exit;
}

// Get all active terms
$termsQ = mysqli_query($con, "SELECT financialterm_id FROM financialterms WHERE status = 1");

$calculated = 0;
while ($term = mysqli_fetch_assoc($termsQ)) {
    $termId = (int)$term['financialterm_id'];
    mysqli_query($con, "CALL sp_calculate_student_fees($studentId, $termId)");
    $calculated++;
}

echo json_encode([
    'success' => true, 
    'terms_calculated' => $calculated,
    'message' => "Fees recalculated for $calculated terms"
]);
?>
