<?php
// Recalculate all family groupings and discounts
include '../includes/conn.php';
session_start();

if (!isset($_SESSION['schoolsyslevel']) || !in_array($_SESSION['schoolsyslevel'], [1,2,3,8])){
    http_response_code(403);
    exit('Unauthorized');
}

// Check if required tables exist
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'families'");
if (!$tableCheck || mysqli_num_rows($tableCheck) == 0) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database tables not set up. Run sql/family_discount_enhancements.sql first.']);
    exit;
}

// Update family counts
$updateFamilies = "UPDATE families f SET 
    total_students = (
        SELECT COUNT(*) FROM students WHERE family_id = f.family_id AND status = 1
    ),
    discount_eligible_count = (
        SELECT COUNT(*) FROM students s
        JOIN classes c ON s.class_id = c.class_id
        WHERE s.family_id = f.family_id 
        AND s.status = 1 
        AND LOWER(c.class) NOT LIKE '%nursery%'
    )
    WHERE f.status = 1";

mysqli_query($con, $updateFamilies);

// Recalculate fees for all active students
$students = mysqli_query($con, "SELECT DISTINCT student_id FROM students WHERE status = 1");
$currentTerm = mysqli_query($con, "SELECT financialterm_id FROM financialterms WHERE status = 1 ORDER BY financialterm_id DESC LIMIT 1");
$termRow = mysqli_fetch_assoc($currentTerm);
$termId = $termRow['financialterm_id'] ?? 0;

if ($termId > 0) {
    while ($student = mysqli_fetch_assoc($students)) {
        $studentId = (int)$student['student_id'];
        mysqli_query($con, "CALL sp_calculate_student_fees($studentId, $termId)");
    }
}

echo json_encode(['success' => true, 'message' => 'Families recalculated successfully']);
?>
