<?php
// Find family for a specific student
include '../includes/conn.php';
session_start();

if (!isset($_SESSION['schoolsyslevel']) || !in_array($_SESSION['schoolsyslevel'], [1,2,3,8])){
    http_response_code(403);
    exit('Unauthorized');
}

// Check if required tables exist
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'families'");
if (!$tableCheck || mysqli_num_rows($tableCheck) == 0) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database tables not set up. Run sql/family_discount_enhancements.sql first.']);
    exit;
}

$studentId = isset($_POST['student_id']) ? (int)$_POST['student_id'] : 0;

if ($studentId <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid student ID']);
    exit;
}

// Get student info
$studentQ = mysqli_query($con, "SELECT * FROM students WHERE student_id = $studentId LIMIT 1");
$student = mysqli_fetch_assoc($studentQ);

if (!$student) {
    echo json_encode(['success' => false, 'message' => 'Student not found']);
    exit;
}

$fphone = mysqli_real_escape_string($con, trim($student['fatherphone']));
$mphone = mysqli_real_escape_string($con, trim($student['motherphone']));
$femail = mysqli_real_escape_string($con, trim($student['fatheremail']));
$memail = mysqli_real_escape_string($con, trim($student['motheremail']));

// Search for matching family
$searchParts = [];
if ($fphone !== '') $searchParts[] = "fatherphone='$fphone'";
if ($mphone !== '') $searchParts[] = "motherphone='$mphone'";
if ($femail !== '') $searchParts[] = "fatheremail='$femail'";
if ($memail !== '') $searchParts[] = "motheremail='$memail'";

if (empty($searchParts)) {
    echo json_encode(['success' => false, 'message' => 'No contact information to search']);
    exit;
}

$where = implode(' OR ', $searchParts);
$existingQ = mysqli_query($con, "SELECT * FROM students WHERE ($where) AND status=1 AND student_id!=$studentId AND family_id > 0 LIMIT 1");

if ($existingQ && mysqli_num_rows($existingQ) > 0) {
    $existing = mysqli_fetch_assoc($existingQ);
    $familyId = (int)$existing['family_id'];
    
    // Assign to existing family
    mysqli_query($con, "UPDATE students SET family_id=$familyId WHERE student_id=$studentId");
    
    // Update family counts
    mysqli_query($con, "UPDATE families SET 
        total_students = (SELECT COUNT(*) FROM students WHERE family_id = $familyId AND status = 1)
        WHERE family_id = $familyId");
    
    echo json_encode(['success' => true, 'family_id' => $familyId]);
} else {
    // Create new family
    $familyName = mysqli_real_escape_string($con, "Family - " . $student['fullname']);
    $contactName = mysqli_real_escape_string($con, $student['fathername'] ?: $student['mothername']);
    $contactPhone = $fphone ?: $mphone;
    $contactEmail = $femail ?: $memail;
    
    $insertFamily = mysqli_query($con, "INSERT INTO families (family_name, primary_contact_name, primary_contact_phone, primary_contact_email, total_students, status) VALUES ('$familyName', '$contactName', '$contactPhone', '$contactEmail', 1, 1)");
    
    if ($insertFamily) {
        $newFamilyId = mysqli_insert_id($con);
        mysqli_query($con, "UPDATE students SET family_id=$newFamilyId WHERE student_id=$studentId");
        
        echo json_encode(['success' => true, 'family_id' => $newFamilyId, 'new_family' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to create family']);
    }
}
?>
