<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}
include 'includes/conn.php';
include 'includes/roles.php'; // Include centralized role management
// require super-admin
if (!isset($_SESSION['secusyslevel']) || (int)($_SESSION['secusyslevel']) !== 1) {
  header('Location:login.php');
  exit;
}
// current admin id (casted)
$current_admin = isset($_SESSION['secusys']) ? (int)$_SESSION['secusys'] : 0;

// load users with prepared statement to avoid injecting session values
$users = [];
$u_stmt = mysqli_prepare($con, "SELECT user_id, staff_id, level, status FROM users WHERE user_id != ? AND status=1 AND level!=5 AND level!=6");
if ($u_stmt) {
  mysqli_stmt_bind_param($u_stmt, 'i', $current_admin);
  mysqli_stmt_execute($u_stmt);
  $u_res = mysqli_stmt_get_result($u_stmt);
  while ($u_row = mysqli_fetch_assoc($u_res)) {
    $users[] = $u_row;
  }
  mysqli_stmt_close($u_stmt);
} else {
  // fallback: query and filter in PHP
  $q = mysqli_query($con, "SELECT user_id,staff_id,level,status FROM users WHERE status=1 AND level!=5 AND level!=6");
  while ($u_row = mysqli_fetch_assoc($q)) {
    if ((int)$u_row['user_id'] === $current_admin) continue;
    $users[] = $u_row;
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Admins</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-11">
                      <section class="panel">
                    <header class="panel-heading">
                     Administrators
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped" id="dynamic-table">
        <thead>
        <tr>
            <th> #</th>
            <th>Fullname</th>
            <th> Email</th>
            <th>Role</th>
               <th> &nbsp;</th>
                  </tr>
        </thead>
        <tbody>
      <?php
      // iterate loaded users
      foreach ($users as $row) {
        $user_id = (int) ($row['user_id'] ?? 0);
        $staff_id = (int) ($row['staff_id'] ?? 0);
        $level = (int) ($row['level'] ?? 0);
        $status = (int) ($row['status'] ?? 0);

        // fetch staff details safely
        $fullname = '';
        $phone = '';
        $gender = '';
        $email = '';
        $ext = '';
        $s_stmt = mysqli_prepare($con, "SELECT fullname,phone,gender,email,ext FROM staff WHERE staff_id = ? LIMIT 1");
        if ($s_stmt) {
          mysqli_stmt_bind_param($s_stmt, 'i', $staff_id);
          mysqli_stmt_execute($s_stmt);
          $sres = mysqli_stmt_get_result($s_stmt);
          if ($srow = mysqli_fetch_assoc($sres)) {
            $fullname = $srow['fullname'] ?? '';
            $phone = $srow['phone'] ?? '';
            $gender = $srow['gender'] ?? '';
            $email = $srow['email'] ?? '';
            $ext = $srow['ext'] ?? '';
          }
          mysqli_stmt_close($s_stmt);
        } else {
          $sres = mysqli_query($con, "SELECT fullname,phone,gender,email,ext FROM staff WHERE staff_id='" . (int)$staff_id . "' LIMIT 1");
          if ($srow = mysqli_fetch_assoc($sres)) {
            $fullname = $srow['fullname'] ?? '';
            $phone = $srow['phone'] ?? '';
            $gender = $srow['gender'] ?? '';
            $email = $srow['email'] ?? '';
            $ext = $srow['ext'] ?? '';
          }
        }
      ?>
        <tr class="gradeA">
      <td>
           <?php if (!empty($ext)) { ?>
           <a href="images/staff/<?php echo rawurlencode(md5($staff_id) . '.' . $ext) . '?' . time(); ?>" target="_blank"><img src="images/staff/thumbs/<?php echo rawurlencode(md5($staff_id) . '.' . $ext) . '?' . time(); ?>" width="80" alt="<?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>"></a>
           <?php } else { ?>
           <img src="images/avatar.png" width="80" alt="avatar">
           <?php } ?>
         </td>
      <td><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></td>
      <td><?php echo htmlspecialchars($email, ENT_QUOTES); ?></td>
      <td><?php echo htmlspecialchars(getRoleName($level), ENT_QUOTES); ?></td>
      ?></td>
       <td>
         <a data-toggle="modal" href="#modal-form<?php echo $user_id; ?>" class="btn btn-info btn-xs">Change Role</a>
         <a data-toggle="modal" href="#modal-pass<?php echo $user_id; ?>" class="btn btn-warning btn-xs">Change Password</a>
        <a href="demoteadmin?id=<?php echo (int)$user_id . '&&st=' . (int)$status; ?>" class="btn btn-danger  btn-xs" onclick="return confirm_delete<?php echo $user_id;?>()">Remove Account</a>
              <script type="text/javascript">
function confirm_delete<?php echo $user_id; ?>() {
  return confirm('You are about To Remove this item. Are you sure you want to proceed?');
}
</script>
           </tr>
             <div id="modal-form<?php echo $user_id; ?>" class="modal fade" aria-hidden="true">
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-body">
                      <div class="row">
                        <div class="col-sm-12">
                          <h3 class="m-t-none m-b">Assign Admin New Role to <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></h3>
                          <form role="form" method="POST" action="changerole?id=<?php echo (int)$user_id; ?>" enctype="multipart/form-data">
                              <div class="form-group">
                                  <label for="username" class="control-label">Assign  Role</label>
                             <select  class="form-control " name="role">
                        <option value="" selected="">Select role</option>
                        <?php echo generateRoleOptions(); ?>
                      </select>
                              </div>
                              <button class="btn btn-sm btn-primary pull-right m-t-n-xs" type="submit"><strong>Submit</strong></button>
                          </form>
                        </div>
                                                
                    </div>
                  </div>
                  </div>
                </div>
            </div>
      <?php } ?>

            <!-- Password modal templates -->
            <?php
            // Render password modals using the already-loaded $users array to avoid reusing DB cursors
            foreach ($users as $urow) {
              $user_id = (int) ($urow['user_id'] ?? 0);
              $staff_id = (int) ($urow['staff_id'] ?? 0);
              // attempt to get staff name quickly
              $staff_name = '';
              $s_stmt2 = mysqli_prepare($con, "SELECT fullname FROM staff WHERE staff_id = ? LIMIT 1");
              if ($s_stmt2) {
                mysqli_stmt_bind_param($s_stmt2, 'i', $staff_id);
                mysqli_stmt_execute($s_stmt2);
                $sres2 = mysqli_stmt_get_result($s_stmt2);
                if ($srow2 = mysqli_fetch_assoc($sres2)) {
                  $staff_name = $srow2['fullname'] ?? '';
                }
                mysqli_stmt_close($s_stmt2);
              } else {
                $sres2 = mysqli_query($con, "SELECT fullname FROM staff WHERE staff_id='" . (int)$staff_id . "' LIMIT 1");
                if ($srow2 = mysqli_fetch_assoc($sres2)) {
                  $staff_name = $srow2['fullname'] ?? '';
                }
              }
            ?>
            <div id="modal-pass<?php echo $user_id; ?>" class="modal fade" aria-hidden="true">
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-body">
                      <div class="row">
                        <div class="col-sm-12">
                          <h3 class="m-t-none m-b">Change Password for <?php echo htmlspecialchars($staff_name, ENT_QUOTES); ?></h3>
                          <form role="form" method="POST" action="admin_change_password.php" enctype="multipart/form-data">
                            <div class="form-group">
                            <label for="newpass" class="control-label">New Password</label>
                            <input type="password" name="newpass" class="form-control" required>
                            </div>
                            <div class="form-group">
                            <label for="newpass2" class="control-label">Confirm Password</label>
                            <input type="password" name="newpass2" class="form-control" required>
                            </div>
                            <input type="hidden" name="user_id" value="<?php echo (int)$user_id; ?>">
                            <button class="btn btn-sm btn-primary pull-right m-t-n-xs" type="submit"><strong>Update Password</strong></button>
                          </form>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
            </div>
            <?php } ?>
        </tbody>
                        </table>
                          </div>
                          </div>
      
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
