<?php
include 'includes/conn.php';
// Only super admins (level 1) or admins (level 2) should be able to change other users' passwords
// allow either session namespace to represent admin levels
$isAdminUser = (($_SESSION['secusyslevel'] ?? 0) == 1 || ($_SESSION['secusyslevel'] ?? 0) == 2) || (($_SESSION['schoolsyslevel'] ?? 0) == 1 || ($_SESSION['schoolsyslevel'] ?? 0) == 2);
if (!$isAdminUser) {
    header('Location: login');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = isset($_POST['user_id']) ? (int) $_POST['user_id'] : 0;
    $newpass = trim($_POST['newpass'] ?? '');
    $newpass2 = trim($_POST['newpass2'] ?? '');

    if ($user_id < 1 || $newpass === '' || $newpass2 === '') {
        header('Location: admins.php');
        exit;
    }

    if ($newpass !== $newpass2) {
        // password mismatch - redirect back with a simple error via referrer
        $_SESSION['msg'] = 'Passwords do not match';
        header('Location: ' . ($_SERVER['HTTP_REFERER'] ?? 'admins.php'));
        exit;
    }

    // Hash the password and update users table
    $hash = password_hash($newpass, PASSWORD_DEFAULT);
    $stmt = mysqli_prepare($con, "UPDATE users SET password = ? WHERE user_id = ?");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, 'si', $hash, $user_id);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }

    $_SESSION['msg'] = 'Password updated successfully';
    header('Location: ' . ($_SERVER['HTTP_REFERER'] ?? 'admins.php'));
    exit;
}

header('Location: admins.php');
exit;
