<?php
include 'includes/conn.php';
include 'includes/roles.php';

// ensure vendor management permission
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!canManageVendors($user_level)) {
    header('Location:login.php');
    exit();
}

$vendor_id = isset($_GET['vendor_id']) ? (int)$_GET['vendor_id'] : 0;
$vendor = null;
if ($vendor_id > 0) {
    $vres = mysqli_query($con, "SELECT * FROM vendors WHERE vendor_id='" . $vendor_id . "' LIMIT 1");
    $vendor = $vres ? mysqli_fetch_assoc($vres) : null;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vendor_id = (int)($_POST['vendor_id'] ?? 0);
    $title = trim($_POST['contract_title'] ?? '');
    $number = trim($_POST['contract_number'] ?? '');
    $start = trim($_POST['start_date'] ?? '');
    $end = trim($_POST['end_date'] ?? '');
    $value = (float)($_POST['total_contract_value'] ?? 0);
    $terms = trim($_POST['contract_terms'] ?? '');
    $reminder = trim($_POST['renewal_reminder_date'] ?? '');
    $status = in_array($_POST['status'] ?? '', ['Draft','Active','Expired','Terminated']) ? $_POST['status'] : 'Draft';

    if ($vendor_id <= 0 || $title === '') {
        $error = 'Vendor and title are required.';
    } else {
        $stmt = mysqli_prepare($con, "INSERT INTO vendor_contracts(vendor_id,contract_title,contract_number,start_date,end_date,total_contract_value,contract_terms,renewal_reminder_date,status,created_by) VALUES(?,?,?,?,?,?,?,?,?,?)");
        if ($stmt) {
            $created_by = isset($_SESSION['schoolsys']) ? (int)$_SESSION['schoolsys'] : null;
            mysqli_stmt_bind_param($stmt, 'isssssdssi', $vendor_id, $title, $number, $start, $end, $value, $terms, $reminder, $status, $created_by);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);
            $_SESSION['message'] = 'Contract added successfully';
            $_SESSION['msg_type'] = 'success';
            header('Location: vendorcontracts.php?id=' . $vendor_id);
            exit;
        } else {
            $error = 'Database error: ' . mysqli_error($con);
        }
    }
}

?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Add Vendor Contract</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<?php include 'includes/header.php'; ?>
<section class="wrapper">
    <div class="row">
        <div class="col-lg-8">
            <section class="panel">
                <header class="panel-heading">Add Contract</header>
                <div class="panel-body">
                    <?php if ($error) echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>'; ?>
                    <form method="post">
                        <input type="hidden" name="vendor_id" value="<?php echo (int)$vendor_id; ?>">
                        <div class="form-group"><label>Contract Title</label><input class="form-control" name="contract_title" required></div>
                        <div class="form-group"><label>Contract Number</label><input class="form-control" name="contract_number"></div>
                        <div class="form-group"><label>Start Date</label><input class="form-control" name="start_date" type="date"></div>
                        <div class="form-group"><label>End Date</label><input class="form-control" name="end_date" type="date"></div>
                        <div class="form-group"><label>Total Value</label><input class="form-control" name="total_contract_value" type="number" step="0.01"></div>
                        <div class="form-group"><label>Terms</label><textarea class="form-control" name="contract_terms"></textarea></div>
                        <div class="form-group"><label>Renewal Reminder Date</label><input class="form-control" name="renewal_reminder_date" type="date"></div>
                        <div class="form-group"><label>Status</label>
                            <select name="status" class="form-control">
                                <option>Draft</option>
                                <option>Active</option>
                                <option>Expired</option>
                                <option>Terminated</option>
                            </select>
                        </div>
                        <button class="btn btn-primary" type="submit">Save</button>
                        <a href="vendorcontracts.php?id=<?php echo (int)$vendor_id; ?>" class="btn btn-default">Cancel</a>
                    </form>
                </div>
            </section>
        </div>
    </div>
</section>
</body>
</html>
