<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

if (!canManageVendors($user_level)) {
    header('Location:login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $vendor_name = mysqli_real_escape_string($con, $_POST['vendor_name'] ?? '');
    $vendor_code = mysqli_real_escape_string($con, $_POST['vendor_code'] ?? '');
    $contact_person = mysqli_real_escape_string($con, $_POST['contact_person'] ?? '');
    $email = mysqli_real_escape_string($con, $_POST['email'] ?? '');
    $phone = mysqli_real_escape_string($con, $_POST['phone'] ?? '');
    $address = mysqli_real_escape_string($con, $_POST['address'] ?? '');
    $city = mysqli_real_escape_string($con, $_POST['city'] ?? '');
    $postal_code = mysqli_real_escape_string($con, $_POST['postal_code'] ?? '');
    $country = mysqli_real_escape_string($con, $_POST['country'] ?? '');
    $tax_id = mysqli_real_escape_string($con, $_POST['tax_id'] ?? '');
    $payment_terms = mysqli_real_escape_string($con, $_POST['payment_terms'] ?? '');
    $bank_name = mysqli_real_escape_string($con, $_POST['bank_name'] ?? '');
    $bank_account = mysqli_real_escape_string($con, $_POST['bank_account'] ?? '');
    $bank_code = mysqli_real_escape_string($con, $_POST['bank_code'] ?? '');
    $category = mysqli_real_escape_string($con, $_POST['category'] ?? '');
    
    if (empty($vendor_name)) {
        $_SESSION['message'] = 'Vendor name is required';
        $_SESSION['msg_type'] = 'danger';
    } else {
        $query = "INSERT INTO vendors (vendor_name, vendor_code, contact_person, email, phone, address, 
                  city, postal_code, country, tax_id, payment_terms, bank_name, bank_account, bank_code, 
                  category, status) 
                  VALUES ('$vendor_name', '$vendor_code', '$contact_person', '$email', '$phone', '$address', 
                  '$city', '$postal_code', '$country', '$tax_id', '$payment_terms', '$bank_name', '$bank_account', 
                  '$bank_code', '$category', 1)";
        
        if (mysqli_query($con, $query)) {
            $_SESSION['message'] = 'Vendor added successfully';
            $_SESSION['msg_type'] = 'success';
            header('Location: vendors.php');
            exit();
        } else {
            $_SESSION['message'] = 'Error: ' . mysqli_error($con);
            $_SESSION['msg_type'] = 'danger';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Add New Vendor</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-8 col-lg-offset-2">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-plus"></i> Add New Vendor
                        </h4>
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    ' . htmlspecialchars($_SESSION['message']) . '
                                 </div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }
                        ?>
                        
                        <form method="POST" action="">
                            <h5 class="margin-bottom-20"><strong>Basic Information</strong></h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">* Vendor Name</label>
                                        <input type="text" name="vendor_name" class="form-control" placeholder="Legal business name" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Vendor Code</label>
                                        <input type="text" name="vendor_code" class="form-control" placeholder="VND-001">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Contact Person</label>
                                        <input type="text" name="contact_person" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Category</label>
                                        <select name="category" class="form-control">
                                            <option value="">Select Category</option>
                                            <?php
                                            $categories = mysqli_query($con, "SELECT DISTINCT category FROM vendors WHERE category IS NOT NULL AND status=1");
                                            while ($cat = mysqli_fetch_array($categories)) {
                                                echo '<option value="' . htmlspecialchars($cat['category']) . '">' . htmlspecialchars($cat['category']) . '</option>';
                                            }
                                            ?>
                                            <option value="New">New Category...</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <h5 class="margin-bottom-20"><strong>Contact Details</strong></h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Email</label>
                                        <input type="email" name="email" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Phone</label>
                                        <input type="tel" name="phone" class="form-control">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label class="control-label">Address</label>
                                <input type="text" name="address" class="form-control">
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">City</label>
                                        <input type="text" name="city" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">Postal Code</label>
                                        <input type="text" name="postal_code" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">Country</label>
                                        <input type="text" name="country" class="form-control">
                                    </div>
                                </div>
                            </div>
                            
                            <h5 class="margin-bottom-20"><strong>Financial Information</strong></h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Tax ID / PIN</label>
                                        <input type="text" name="tax_id" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Payment Terms</label>
                                        <input type="text" name="payment_terms" class="form-control" placeholder="e.g., Net 30, Net 60">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Bank Name</label>
                                        <input type="text" name="bank_name" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Bank Account Number</label>
                                        <input type="text" name="bank_account" class="form-control">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label class="control-label">Bank Code/SWIFT</label>
                                <input type="text" name="bank_code" class="form-control">
                            </div>
                            
                            <div class="form-group">
                                <button type="submit" class="btn btn-success">
                                    <i class="fa fa-check"></i> Save Vendor
                                </button>
                                <a href="vendors.php" class="btn btn-default">
                                    <i class="fa fa-times"></i> Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
