<?php
session_start();
include 'includes/conn.php';
include 'includes/roles.php';

$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level) && $user_level !== 2) {
    header('Location: index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vehicle_number = mysqli_real_escape_string($con, $_POST['vehicle_number'] ?? '');
    $vehicle_type = mysqli_real_escape_string($con, $_POST['vehicle_type'] ?? 'Bus');
    $make = mysqli_real_escape_string($con, $_POST['make'] ?? '');
    $model = mysqli_real_escape_string($con, $_POST['model'] ?? '');
    $year = !empty($_POST['year']) ? (int) $_POST['year'] : 'NULL';
    $capacity = !empty($_POST['capacity']) ? (int) $_POST['capacity'] : 'NULL';
    $fuel_type = !empty($_POST['fuel_type']) ? "'" . mysqli_real_escape_string($con, $_POST['fuel_type']) . "'" : 'NULL';
    $vin_number = mysqli_real_escape_string($con, $_POST['vin_number'] ?? '');
    $insurance_company = mysqli_real_escape_string($con, $_POST['insurance_company'] ?? '');
    $insurance_policy = mysqli_real_escape_string($con, $_POST['insurance_policy'] ?? '');
    $insurance_expiry = !empty($_POST['insurance_expiry']) ? "'" . mysqli_real_escape_string($con, $_POST['insurance_expiry']) . "'" : 'NULL';
    $license_expiry = !empty($_POST['license_expiry']) ? "'" . mysqli_real_escape_string($con, $_POST['license_expiry']) . "'" : 'NULL';
    $purchase_date = !empty($_POST['purchase_date']) ? "'" . mysqli_real_escape_string($con, $_POST['purchase_date']) . "'" : 'NULL';
    $purchase_cost = !empty($_POST['purchase_cost']) ? (float) $_POST['purchase_cost'] : 'NULL';
    $current_mileage = !empty($_POST['current_mileage']) ? (int) $_POST['current_mileage'] : 0;
    $assigned_driver = mysqli_real_escape_string($con, $_POST['assigned_driver'] ?? '');
    $status = mysqli_real_escape_string($con, $_POST['status'] ?? 'Active');
    $notes = mysqli_real_escape_string($con, $_POST['notes'] ?? '');
    
    $insert = "INSERT INTO vehicles (vehicle_number, vehicle_type, make, model, year, capacity, fuel_type, vin_number, 
               insurance_company, insurance_policy, insurance_expiry, license_expiry, purchase_date, purchase_cost, 
               current_mileage, assigned_driver, status, notes, created_by) 
               VALUES ('$vehicle_number', '$vehicle_type', '$make', '$model', $year, $capacity, $fuel_type, '$vin_number', 
               '$insurance_company', '$insurance_policy', $insurance_expiry, $license_expiry, $purchase_date, $purchase_cost, 
               $current_mileage, '$assigned_driver', '$status', '$notes', {$_SESSION['schooladminsyslevel']})";
    
    if (mysqli_query($con, $insert)) {
        $_SESSION['message'] = 'Vehicle added successfully';
        header('Location: vehicles.php');
        exit;
    } else {
        $error = 'Error adding vehicle: ' . mysqli_error($con);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ThemeBucket">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Add Vehicle - School Manager</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    
    <section class="wrapper">
        <section class="section">
            <div class="row">
                <div class="col-lg-12">
                    <section class="panel">
                        <header class="panel-heading">
                            <h4 class="panel-title"><i class="fa fa-plus"></i> Add New Vehicle</h4>
                        </header>
                        
                        <div class="panel-body">
                            <?php if (isset($error)): ?>
                                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                            <?php endif; ?>
                            
                            <form method="POST" class="form-horizontal">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h4>Basic Information</h4>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Vehicle Number *</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="vehicle_number" class="form-control" placeholder="e.g., KCA 001A" required>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Vehicle Type *</label>
                                            <div class="col-sm-8">
                                                <select name="vehicle_type" class="form-control" required>
                                                    <option value="Bus">Bus</option>
                                                    <option value="Van">Van</option>
                                                    <option value="Car">Car</option>
                                                    <option value="Truck">Truck</option>
                                                    <option value="Motorcycle">Motorcycle</option>
                                                    <option value="Other">Other</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Make</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="make" class="form-control" placeholder="e.g., Isuzu, Toyota">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Model</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="model" class="form-control" placeholder="e.g., NQR 70, Hiace">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Year</label>
                                            <div class="col-sm-8">
                                                <input type="number" name="year" class="form-control" min="1900" max="<?php echo date('Y') + 1; ?>" placeholder="<?php echo date('Y'); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Capacity</label>
                                            <div class="col-sm-8">
                                                <input type="number" name="capacity" class="form-control" min="1" placeholder="Passenger capacity">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Fuel Type</label>
                                            <div class="col-sm-8">
                                                <select name="fuel_type" class="form-control">
                                                    <option value="">Select...</option>
                                                    <option value="Petrol">Petrol</option>
                                                    <option value="Diesel">Diesel</option>
                                                    <option value="Electric">Electric</option>
                                                    <option value="Hybrid">Hybrid</option>
                                                    <option value="Other">Other</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">VIN Number</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="vin_number" class="form-control" placeholder="Vehicle Identification Number">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <h4>Insurance & Licensing</h4>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Insurance Company</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="insurance_company" class="form-control" placeholder="e.g., Britam">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Policy Number</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="insurance_policy" class="form-control" placeholder="Insurance policy number">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Insurance Expiry</label>
                                            <div class="col-sm-8">
                                                <input type="date" name="insurance_expiry" class="form-control">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">License Expiry</label>
                                            <div class="col-sm-8">
                                                <input type="date" name="license_expiry" class="form-control">
                                            </div>
                                        </div>
                                        
                                        <h4>Purchase & Maintenance</h4>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Purchase Date</label>
                                            <div class="col-sm-8">
                                                <input type="date" name="purchase_date" class="form-control">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Purchase Cost (BIF)</label>
                                            <div class="col-sm-8">
                                                <input type="number" name="purchase_cost" class="form-control" step="0.01" min="0" placeholder="0.00">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Current Mileage (km)</label>
                                            <div class="col-sm-8">
                                                <input type="number" name="current_mileage" class="form-control" min="0" value="0">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Assigned Driver</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="assigned_driver" class="form-control" placeholder="Driver name">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Status</label>
                                            <div class="col-sm-8">
                                                <select name="status" class="form-control">
                                                    <option value="Active">Active</option>
                                                    <option value="In Maintenance">In Maintenance</option>
                                                    <option value="Out of Service">Out of Service</option>
                                                    <option value="Retired">Retired</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Notes</label>
                                            <div class="col-sm-8">
                                                <textarea name="notes" class="form-control" rows="3" placeholder="Additional information"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="col-sm-12">
                                        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save Vehicle</button>
                                        <a href="vehicles.php" class="btn btn-default">Cancel</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </section>
                </div>
            </div>
        </section>
    </section>
</section>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>
