<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if ((!isset($_SESSION['schoolsys']))) {
    header('Location:login.php');
    exit;
}

$cl = isset($_GET['cl']) ? (int) $_GET['cl'] : 0;
$st = isset($_GET['st']) ? (int) $_GET['st'] : 0;
// $day = $_GET['day'];
$stream = null;
// fetch class and stream safely
$class = '';
$getclass = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
if ($getclass) {
    mysqli_stmt_bind_param($getclass, 'i', $cl);
    mysqli_stmt_execute($getclass);
    mysqli_stmt_bind_result($getclass, $class_result);
    if (mysqli_stmt_fetch($getclass)) {
        $class = $class_result;
    }
    mysqli_stmt_close($getclass);
}

$getstream = mysqli_prepare($con, "SELECT stream FROM streams WHERE stream_id = ? LIMIT 1");
if ($getstream) {
    mysqli_stmt_bind_param($getstream, 'i', $st);
    mysqli_stmt_execute($getstream);
    mysqli_stmt_bind_result($getstream, $stream_result);
    if (mysqli_stmt_fetch($getstream)) {
        $stream = $stream_result;
    }
    mysqli_stmt_close($getstream);
}
// Get a safe default for full day name used in the page title to avoid undefined variable warnings
$fullday = '';
// If a specific day short code was provided via GET we can attempt to resolve its full name
if (isset($_GET['day']) && $_GET['day'] !== '') {
    $day_short = $_GET['day'];
    $getdays = mysqli_prepare($con, "SELECT `day` FROM days WHERE `short` = ? LIMIT 1");
    if ($getdays) {
        mysqli_stmt_bind_param($getdays, 's', $day_short);
        mysqli_stmt_execute($getdays);
        mysqli_stmt_bind_result($getdays, $day_full_res);
        if (mysqli_stmt_fetch($getdays)) {
            $fullday = $day_full_res;
        }
        mysqli_stmt_close($getdays);
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="t">
    <link rel="shortcut icon" href="#" type="image/png">

    <title>Add Timetable for <?php echo $fullday . ' ' . $class . ' ' . $stream; ?></title>

    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/ckeditor/ckeditor.js"></script>
    <link rel="stylesheet" href="js/ckeditor/samples/sample.css">
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
    <link href="css/chosen/chosen.css" rel="stylesheet">
    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
    <section>
        <?php include 'includes/header.php';
        //   echo str_replace('\', ' ',$organisation);
        ?>

        <section class="wrapper">
            <!-- page start-->

            <div class="row">
                <div class="col-lg-8">
                    <section class="panel">
                        <header class="panel-heading">
                            Add <?php echo $class . ' ' . $stream; ?> Timetable
                        </header>
                        <div class="panel-body">
                            <?php
                            if (isset($_POST['submit'])) {
                                include_once __DIR__ . '/includes/db_debug_logger.php';
                                $classsubject = isset($_POST['classsubject']) && is_array($_POST['classsubject']) ? $_POST['classsubject'] : [];
                                $starttime = isset($_POST['starttime']) && is_array($_POST['starttime']) ? $_POST['starttime'] : [];
                                $activity = isset($_POST['activity']) && is_array($_POST['activity']) ? $_POST['activity'] : [];
                                $endtime = isset($_POST['endtime']) && is_array($_POST['endtime']) ? $_POST['endtime'] : [];
                                $days = isset($_POST['days']) && is_array($_POST['days']) ? $_POST['days'] : [];

                                if (empty($starttime) || empty($endtime)) {
                                    $errors[] = 'Some Fields are Empty';
                                }

                                if (empty($classsubject) && empty($activity)) {
                                    $errors[] = 'Class Subject or Activity should be Filled';
                                }

                                if (empty($days)) {
                                    $errors[] = 'Please select a day';
                                }

                                if (!empty($errors)) {
                                    foreach ($errors as $error) {
                                        echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                                    }
                                } else {
                                    $timetablecount = count($starttime);

                                    // prepare reusable statements
                                    // Use backticks around `day` (reserved word) and table/column identifiers to avoid SQL errors
                                    $check_stmt = mysqli_prepare($con, "SELECT timetable_id FROM `timetables` WHERE `class_id`=? AND `stream_id`=? AND `day`=? AND `starttime`=? AND `endtime`=? LIMIT 1");
                                    $update_stmt = mysqli_prepare($con, "UPDATE `timetables` SET `activity`=? WHERE `class_id`=? AND `stream_id`=? AND `day`=? AND `starttime`=? AND `endtime`=?");
                                    $insert_stmt = mysqli_prepare($con, "INSERT INTO `timetables`(`class_id`,`stream_id`,`activity`,`starttime`,`endtime`,`day`,`position`,`status`) VALUES(?,?,?,?,?,?,?,?)");

                                    for ($i = 0; $i < $timetablecount; $i++) {
                                        $status = 1;
                                        $day = trim($days[$i] ?? '');
                                        $st_time = trim($starttime[$i] ?? '');
                                        $en_time = trim($endtime[$i] ?? '');
                                        $act = trim($activity[$i] ?? '');
                                        $cs = trim($classsubject[$i] ?? '');

                                        if ($st_time === '' || $en_time === '' || $day === '') {
                                            continue;
                                        }

                                        // check existence
                                        if ($check_stmt) {
                                            mysqli_stmt_bind_param($check_stmt, 'iisss', $cl, $st, $day, $st_time, $en_time);
                                            mysqli_stmt_execute($check_stmt);
                                            mysqli_stmt_store_result($check_stmt);
                                            $exists = mysqli_stmt_num_rows($check_stmt) > 0;
                                            mysqli_stmt_free_result($check_stmt);
                                        } else {
                                            $exists = false;
                                        }

                                        if ($exists) {
                                            // update
                                            $to_set = $act !== '' ? $act : $cs;
                                            if ($update_stmt) {
                                                mysqli_stmt_bind_param($update_stmt, 'siisss', $to_set, $cl, $st, $day, $st_time, $en_time);
                                                mysqli_stmt_execute($update_stmt);
                                            } else {
                                                $q = sprintf("UPDATE `timetables` SET `activity`='%s' WHERE `class_id`='%d' AND `stream_id`='%d' AND `day`='%s' AND `starttime`='%s' AND `endtime`='%s'", mysqli_real_escape_string($con, $to_set), (int)$cl, (int)$st, mysqli_real_escape_string($con, $day), mysqli_real_escape_string($con, $st_time), mysqli_real_escape_string($con, $en_time));
                                                mysqli_query($con, $q);
                                            }
                                        } else {
                                            // insert
                                            $to_set = $act !== '' ? $act : $cs;
                                            if ($insert_stmt) {
                                                $pos = (int)$i;
                                                mysqli_stmt_bind_param($insert_stmt, 'iissssii', $cl, $st, $to_set, $st_time, $en_time, $day, $pos, $status);
                                                mysqli_stmt_execute($insert_stmt);
                                            } else {
                                                $q = sprintf("INSERT INTO `timetables`(`class_id`,`stream_id`,`activity`,`starttime`,`endtime`,`day`,`position`,`status`) VALUES('%d','%d','%s','%s','%s','%s','%d','%d')", (int)$cl, (int)$st, mysqli_real_escape_string($con, $to_set), mysqli_real_escape_string($con, $st_time), mysqli_real_escape_string($con, $en_time), mysqli_real_escape_string($con, $day), (int)$i, (int)$status);
                                                mysqli_query($con, $q);
                                            }
                                        }
                                    }

                                    if ($check_stmt) mysqli_stmt_close($check_stmt);
                                    if ($update_stmt) mysqli_stmt_close($update_stmt);
                                    if ($insert_stmt) mysqli_stmt_close($insert_stmt);

                                    echo '<div class="alert alert-success">Timetable Successfully Updated. <a href="timetable?class=' . (int)$cl . '_' . (int)$st . '">View Timetable</a></div>';
                                }
                            }
                            ?>
                            <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
                                <div class="alert alert-info">Either select a <strong>subject</strong> or Enter <strong>activity</strong> for a particular time session but not both</div>

                                <?php
                                // Get all days
                                $days_query = mysqli_query($con, "SELECT * FROM days");
                                $days = array();
                                while ($day_row = mysqli_fetch_array($days_query)) {
                                    $days[] = $day_row;
                                }
                                ?>

                                <div class="pharmacy-sec">
                                    <div class="row">
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">Subject</label>
                                            <select data-placeholder="Choose subject..." name="classsubject[]" class="chosen-select" style="width:100%;" tabindex="2">
                                                <option value="">Select Subject</option>
                                                <?php
                                                $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects WHERE class_id='$cl'");
                                                while ($row = mysqli_fetch_array($class_subjects)) {
                                                    $class_sub_id = $row['class_sub_id'];
                                                    $class_id = $row['class_id'];
                                                    $subject_id = $row['subject_id'];
                                                    $getclasses =  mysqli_query($con, "SELECT * FROM classes WHERE class_id='$class_id'");
                                                    $row2 =  mysqli_fetch_array($getclasses);
                                                    if (mysqli_num_rows($getclasses) > 0) {
                                                        $class = $row2['class'];
                                                        $getsubjects =  mysqli_query($con, "SELECT * FROM subjects WHERE subject_id='$subject_id'");
                                                        $row3 =  mysqli_fetch_array($getsubjects);
                                                        $subject = $row3['subject'];
                                                    }
                                                ?>
                                                    <option value="<?php echo $class_sub_id; ?>"><?php echo $class . ':' . $subject; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">Activity (Enter if isn't a subject e.g Lunch)</label>
                                            <input type="text" class="form-control" name="activity[]" placeholder="enter activity">
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">Start Time (Click on clock icon)</label>
                                            <div class="input-group bootstrap-timepicker">
                                                <input type="text" class="form-control timepicker-24" name="starttime[]" required="required">
                                                <span class="input-group-btn">
                                                    <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">End Time (Click on Clock icon)</label>
                                            <div class="input-group bootstrap-timepicker">
                                                <input type="text" class="form-control timepicker-24" name="endtime[]" required="required">
                                                <span class="input-group-btn">
                                                    <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="form-group col-lg-6">
                                            <label class="control-label">Select Day</label>
                                            <select name="days[]" class="form-control" required="required">
                                                <option value="">Select Day</option>
                                                <?php foreach ($days as $day): ?>
                                                    <option value="<?php echo $day['short']; ?>"><?php echo $day['day']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <button class="drug_button btn btn-info btn-xs">Add more</button>
                                </div>
                                <div class="form-group">
                                    <button class="btn btn-primary" type="submit" name="submit">Submit</button>
                                </div>
                            </form>
                        </div>
                    </section>
                </div>
            </div>
        </section>

        </div>

        </div>


        </div>
        <!-- page end-->
    </section>


    </div>
    <!-- main content end-->
    </section>

    <script src="js/bootstrap.min.js"></script>
    <script src="js/modernizr.min.js"></script>
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
    <script src="js/chosen/chosen.jquery.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/pickers-init.js?<?php echo time(); ?>"></script>
    <script src="js/scripts.js"></script>
    <script>
        $('.drug_button').click(function(e) { //on add input button click
            e.preventDefault();
            $(document).ready(function() {

                $('.pharmacy-sec').append(`<div class="row"><div class="form-group col-lg-6"><label class="control-label">* Subject</label><select data-placeholder="Choose Subject..." name="classsubject[]" class="chosen-select" style="width:100%;" tabindex="2">  <option value="">Select Subject</option> 
             <?php $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects");
                while ($row = mysqli_fetch_array($class_subjects)) {
                    $class_sub_id = $row["class_sub_id"];
                    $class_id = $row["class_id"];
                    $subject_id = $row["subject_id"];
                    $getclasses =  mysqli_query($con, "SELECT * FROM classes WHERE class_id='$class_id'");
                    $row2 =  mysqli_fetch_array($getclasses);
                    if (mysqli_num_rows($getclasses) > 0) {
                        $class = $row2['class'];
                        $getsubjects =  mysqli_query($con, "SELECT * FROM subjects WHERE subject_id='$subject_id'");
                        $row3 =  mysqli_fetch_array($getsubjects);
                        $subject = $row3['subject'];
                    }
                ?> 
                 <option value="<?php echo $class_sub_id; ?>"><?php echo $class . ":" . $subject; ?></option>     <?php } ?>   </select>       
                 </div>  <div class="form-group col-lg-5"><label class="control-label">Activity</label> <input type="text" class="form-control" name="activity[]" placeholder="enter activity">  </div><div class="form-group col-lg-6"><label class="control-label">Start Time</label><div class="input-group bootstrap-timepicker"> <input type="text" class="form-control timepicker-24" name="starttime[]" required="required"><span class="input-group-btn"> <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button></span> </div>  </div> <div class="form-group col-lg-5"><label class="control-label">End Time</label> <div class="input-group bootstrap-timepicker"><input type="text" class="form-control timepicker-24" name="endtime[]" required="required"> <span class="input-group-btn"><button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button> </span> </div>   </div> <button class="remove_drug  btn btn-danger btn-xs" style="margin-top:20px"><i class="fa fa-minus"></i></button>`);
            });
            $('.pharmacy-sec').on("click", ".remove_drug", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            });
            $('.timepicker-24').timepicker({
                autoclose: true,
                minuteStep: 5,
                showSeconds: false,
                showMeridian: false
            });

            var config = {
                '.chosen-select': {},
                '.chosen-select-deselect': {
                    allow_single_deselect: true
                },
                '.chosen-select-no-single': {
                    disable_search_threshold: 10
                },
                '.chosen-select-no-results': {
                    no_results_text: 'Oops, nothing found!'
                },
                '.chosen-select-width': {
                    width: "95%"
                }
            }
            for (var selector in config) {
                $(selector).chosen(config[selector]);
            }
        });
        var config = {
            '.chosen-select': {},
            '.chosen-select-deselect': {
                allow_single_deselect: true
            },
            '.chosen-select-no-single': {
                disable_search_threshold: 10
            },
            '.chosen-select-no-results': {
                no_results_text: 'Oops, nothing found!'
            },
            '.chosen-select-width': {
                width: "95%"
            }
        }
        for (var selector in config) {
            $(selector).chosen(config[selector]);
        }
    </script>
</body>

</html>