<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
include 'includes/conn.php';
// require school admin
if (!isset($_SESSION['schoolsys']) || !isset($_SESSION['schoolsyslevel']) || (int)$_SESSION['schoolsyslevel'] !== 1) {
    header('Location:login.php');
    exit;
}

function log_db_error($con, $context = '') {
    $err = mysqli_error($con);
    $bt = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 6);
    $bt_lines = [];
    foreach ($bt as $frame) {
        $file = isset($frame['file']) ? $frame['file'] : '(unknown)';
        $line = isset($frame['line']) ? $frame['line'] : 0;
        $func = isset($frame['function']) ? $frame['function'] : '(main)';
        $bt_lines[] = "$file:$line - $func";
    }
    $server = $_SERVER['HTTP_HOST'] ?? php_uname('n');
    $uri = $_SERVER['REQUEST_URI'] ?? '';
    $msg = "[".date('Y-m-d H:i:s')."] host={$server} uri={$uri} context={$context} error={$err}\nstack:\n".implode("\n", $bt_lines)."\n\n";
    $logdir = __DIR__ . DIRECTORY_SEPARATOR . 'logs';
    if (!is_dir($logdir)) @mkdir($logdir, 0755, true);
    @file_put_contents($logdir . DIRECTORY_SEPARATOR . 'db_debug.log', $msg, FILE_APPEND | LOCK_EX);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="t">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Add School Term</title>
    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/ckeditor/ckeditor.js"></script>
    <link rel="stylesheet" href="js/ckeditor/samples/sample.css">
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
    <link href="css/jquery.filer.css" rel="stylesheet">
    <link href="css/chosen/chosen.css" rel="stylesheet">
    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
    <section>
        <?php include 'includes/header.php';
        //   echo str_replace('\', ' ',$organisation);
        ?>

        <section class="wrapper">
            <!-- page start-->

            <div class="row">
                <div class="col-lg-8">
                    <section class="panel">
                        <header class="panel-heading">
                            Add New Term
                        </header>
                        <div class="panel-body">
                            <?php
                            if (isset(/*$_POST['year'],*/$_POST['important_notice'], $_POST['term'], $_POST['acad_year'])) {
                                $errors = [];
                                // sanitize and cast inputs
                                $term = (int) $_POST['term'];
                                $notice = trim($_POST['important_notice']);
                                $acad_year = (int) $_POST['acad_year'];

                                if ($term <= 0 || $acad_year <= 0 || $notice === '') {
                                    $errors[] = 'All Fields Are Required';
                                }

                                // fetch the academic year's start using prepared statement
                                $start = null;
                                if (empty($errors)) {
                                    $stmt = mysqli_prepare($con, "SELECT `start` FROM `financialyears` WHERE `fyear_id`=? LIMIT 1");
                                    if ($stmt) {
                                        mysqli_stmt_bind_param($stmt, 'i', $acad_year);
                                        mysqli_stmt_execute($stmt);
                                        mysqli_stmt_bind_result($stmt, $start_result);
                                        if (mysqli_stmt_fetch($stmt)) {
                                            $start = (int)$start_result;
                                        }
                                        mysqli_stmt_close($stmt);
                                    } else {
                                        // Log the DB error for diagnosis and add a generic message for users
                                        log_db_error($con, 'fetch academic year prepare');
                                        $errors[] = 'A database error occurred. The administrator has been notified.';
                                    }
                                    if ($start === null) {
                                        $errors[] = 'Selected academic year not found.';
                                    }
                                }

                                // check for duplicate term in the same year
                                if (empty($errors)) {
                                    $stmt = mysqli_prepare($con, "SELECT 1 FROM `financialterms` WHERE `term`=? AND `year`=? LIMIT 1");
                                    if ($stmt) {
                                        mysqli_stmt_bind_param($stmt, 'ii', $term, $start);
                                        mysqli_stmt_execute($stmt);
                                        mysqli_stmt_store_result($stmt);
                                        if (mysqli_stmt_num_rows($stmt) > 0) {
                                            $errors[] = 'Term Already Added';
                                        }
                                        mysqli_stmt_close($stmt);
                                    } else {
                                        log_db_error($con, 'duplicate term check prepare');
                                        $errors[] = 'A database error occurred. The administrator has been notified.';
                                    }
                                }

                                if (!empty($errors)) {
                                    foreach ($errors as $error) {
                            ?>
                                        <div class="alert alert-danger"><?php echo htmlspecialchars($error, ENT_QUOTES); ?></div>
                            <?php
                                    }
                                } else {

                                    $stmt = mysqli_prepare($con, "INSERT INTO `financialterms` (`term`,`year`,`academic_year`,`important_notice`,`status`) VALUES(?,?,?,?,1)");
                                    if ($stmt) {
                                        mysqli_stmt_bind_param($stmt, 'iiis', $term, $start, $acad_year, $notice);
                                        mysqli_stmt_execute($stmt);
                                        $last_id = mysqli_insert_id($con);
                                        // keep legacy invoice creation commented as before
                                        // $accountstudents1 =  mysqli_query($con, "SELECT * FROM students WHERE status='1' AND joiningyear<='$start'");
                                        // while ($row1 = mysqli_fetch_array($accountstudents1)) {
                                        //     $student_id = $row1['student_id'];
                                        //     $class_id = $row1['class_id'];
                                        //     $fees =  mysqli_query($con, "SELECT  * FROM schoolfees WHERE class_id='$class_id'");
                                        //     $row2 =  mysqli_fetch_array($fees);
                                        // }
                                        if (mysqli_stmt_affected_rows($stmt) > 0) {
                                            echo '<div class="alert alert-success">New Term successfully Added</div>';
                                        } else {
                                            // Log DB error and show generic message
                                            log_db_error($con, 'insert financialterms execute');
                                            echo '<div class="alert alert-danger">Failed to add new term. The administrator has been notified.</div>';
                                        }
                                        mysqli_stmt_close($stmt);
                                    } else {
                                        log_db_error($con, 'insert financialterms prepare');
                                        echo '<div class="alert alert-danger">A database error occurred. The administrator has been notified.</div>';
                                    }
                                }
                            }

                            ?>

                            <form method="post" name='form' class="form-horizontal" action="" enctype="multipart/form-data">
                                <div class="hr-line-dashed"></div>
                                <div class="form-group"><label class="col-sm-2 control-label">* Term</label>

                                    <div class="col-sm-10">
                                        <select name="term" class="form-control">
                                            <option value="">select term...</option>
                                            <option value="1">Term 1</option>
                                            <option value="2">Term 2</option>
                                            <option value="3">Term 3</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- <div class="hr-line-dashed"></div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">* Select Year</label>
                                    <div class="col-sm-10">
                                        <select name="year" class="form-control">
                                            <option value="">select year...</option>
                                            <option value="<?php echo date('Y', $timenow); ?>"><?php echo date('Y', $timenow); ?></option>
                                            <?php
                                            $datenow = date('Y', $timenow);
                                            for ($x = 0; $x <= 15; $x++) {
                                                $datenow = $datenow - 1;
                                                echo '<option value="' . $datenow . '">' . $datenow . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div> -->
                                <div class="hr-line-dashed"></div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">* Important Notice</label>
                                    <div class="col-sm-10">
                                        <textarea name="important_notice" class="form-control" rows="5" placeholder="Enter important notice..."></textarea>
                                    </div>
                                </div>

                                <script>
                                    // Basic input validation to prevent script injection
                                    document.querySelector('form').addEventListener('submit', function(event) {
                                        var notice = document.querySelector('textarea[name="important_notice"]').value;
                                        var regex = /<(.|\n)*?>/g; // Regex to match HTML tags
                                        if (regex.test(notice)) {
                                            alert('HTML tags are not allowed in the important notice.');
                                            event.preventDefault(); // Prevent form submission
                                        }
                                    });
                                </script>
                                <div class="hr-line-dashed"></div>
                                <div class="form-group" id="data_5">
                                    <label class="col-sm-2 control-label">*Select Academic Year</label>
                                    <div class="col-sm-10">
                                        <select name="acad_year" class="form-control">

                                            <option value=""></option>
                                            <?php
                                            $years_aca =  mysqli_query($con, "SELECT  * FROM financialyears WHERE status=1");
                                            while ($row =  mysqli_fetch_array($years_aca)) {
                                                $fyear_id = $row['fyear_id'];
                                                $fyear = $row['fyear'];
                                                echo '<option value="' . $fyear_id . '" >' . $fyear . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>



                                <div class="hr-line-dashed"></div>


                                <div class="form-group">
                                    <div class="col-sm-4 col-sm-offset-2">

                                        <button class="btn btn-primary" type="submit">Add Term</button>
                                    </div>
                                </div>
                            </form>
                        </div>

                </div>
        </section>

        </div>

        </div>


        </div>
        <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
    </section>

    <script src="js/bootstrap.min.js"></script>
    <script src="js/modernizr.min.js"></script>
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" src="js/gen_validatorv4.js"></script>
    <script src="js/chosen/chosen.jquery.js"></script>
    <script src="js/scripts.js"></script>
    <script src="js/jquery.filer.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#filer_input').filer({
                showThumbs: true,
                addMore: true
            });
        });
        var config = {
            '.chosen-select': {},
            '.chosen-select-deselect': {
                allow_single_deselect: true
            },
            '.chosen-select-no-single': {
                disable_search_threshold: 10
            },
            '.chosen-select-no-results': {
                no_results_text: 'Oops, nothing found!'
            },
            '.chosen-select-width': {
                width: "95%"
            }
        }
        for (var selector in config) {
            $(selector).chosen(config[selector]);
        }
    </script>
</body>

</html>