<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
  header('Location:login.php');
  exit;
}
?>
<?php
// Enable error logging to file (do not display to users on hosted)
@ini_set('display_errors', '0');
@ini_set('log_errors', '1');
@ini_set('error_log', __DIR__ . DIRECTORY_SEPARATOR . 'logs' . DIRECTORY_SEPARATOR . 'php_errors.log');
// Ensure we have a lightweight DB error logger available
if (file_exists(__DIR__ . '/includes/db_debug_logger.php')) {
  include_once __DIR__ . '/includes/db_debug_logger.php';
}
?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Add attendance-School Manager</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="css/chosen/chosen.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-10">
          <section class="panel">
            <header class="panel-heading">
              Add Teacher Attendance
            </header>
            <?php
              if (isset($_POST['date'], $_POST['term'], $_POST['time'])) {
                // Convert date to Y-m-d format for DATE column
                $date_input = trim($_POST['date']);
                $date = null;
                if (!empty($date_input)) {
                  $dt = DateTime::createFromFormat('m/d/Y', $date_input);
                  if (!$dt) $dt = DateTime::createFromFormat('d/m/Y', $date_input);
                  if (!$dt) $dt = DateTime::createFromFormat('Y-m-d', $date_input);
                  $date = $dt ? $dt->format('Y-m-d') : null;
                }
                
                $term = (int) $_POST['term'];
                $time = trim($_POST['time']);
                $attendance = isset($_POST['attendance']) && is_array($_POST['attendance']) ? $_POST['attendance'] : [];
                $status = isset($_POST['status']) && is_array($_POST['status']) ? $_POST['status'] : [];

                if (empty($date) || $term <= 0 || empty($time)) {
                  echo '<div class="alert alert-danger">Some Fields are Empty or invalid</div>';
                } else {
          $stmt = mysqli_prepare($con, "INSERT INTO teacherattendance(`date`,term_id,time,status) VALUES(?,?,?,?)");
          $s_status = 1;
          if ($stmt) {
            // types: date (s), term_id (i), time (s), status (i)
            mysqli_stmt_bind_param($stmt, 'sisi', $date, $term, $time, $s_status);
            if (!mysqli_stmt_execute($stmt)) {
              // Log DB error and present a friendly message
              if (function_exists('log_db_error_global')) log_db_error_global($con, 'teacherattendance: stmt execute failed');
              echo '<div class="alert alert-danger">Failed to record attendance (DB error). Please contact the administrator.</div>';
              mysqli_stmt_close($stmt);
              // stop further processing to avoid partial inserts
              goto ADD_TEACHER_ATTENDANCE_END;
            }
            $last_id = mysqli_insert_id($con);
            mysqli_stmt_close($stmt);
          } else {
            $insq = mysqli_query($con, "INSERT INTO teacherattendance(`date`,term_id,time,status) VALUES('".mysqli_real_escape_string($con,$date)."','".(int)$term."','".mysqli_real_escape_string($con,$time)."',1)");
            if ($insq === false) {
              if (function_exists('log_db_error_global')) log_db_error_global($con, 'teacherattendance: insert fallback');
              echo '<div class="alert alert-danger">Failed to record attendance (DB error). Please contact the administrator.</div>';
              // stop further processing
              goto ADD_TEACHER_ATTENDANCE_END;
            }
            $last_id = mysqli_insert_id($con);
          }

                  // insert provided attendance details
                  if (!empty($attendance)) {
            $ins_stmt = mysqli_prepare($con, "INSERT INTO teacherattendancedetails(teacherattendance_id,teacher_id,details,status) VALUES(?,?,?,?)");
                      for ($i = 0; $i < count($attendance); $i++) {
                          $teacher_id = (int) $attendance[$i];
                          $stat = isset($status[$i]) ? (int) $status[$i] : 0;
                          if ($ins_stmt) {
                // types: teacherattendance_id(i), teacher_id(i), details(s), status(i)
                $details = '';
                mysqli_stmt_bind_param($ins_stmt, 'iisi', $last_id, $teacher_id, $details, $stat);
                              mysqli_stmt_execute($ins_stmt);
                          } else {
                              $q = "INSERT INTO teacherattendancedetails(teacherattendance_id,teacher_id,details,status) VALUES('".intval($last_id)."','".intval($teacher_id)."','',".intval($stat).")";
                              $iq = mysqli_query($con, $q);
                              if ($iq === false) {
                                if (function_exists('log_db_error_global')) log_db_error_global($con, 'teacherattendancedetails: insert fallback');
                              }
                          }
                      }
                      if ($ins_stmt) mysqli_stmt_close($ins_stmt);
                  }

                  // ensure all teachers have a row
                  $getteachers = mysqli_query($con, "SELECT teacher_id FROM teachers WHERE status=1");
                  while ($row = mysqli_fetch_array($getteachers)) {
                    $student_id = (int) $row['teacher_id'];
                    $check_stmt = mysqli_prepare($con, "SELECT teacherattendancedetails_id  FROM teacherattendancedetails WHERE teacherattendance_id = ? AND teacher_id = ?");
                    if ($check_stmt) {
                        mysqli_stmt_bind_param($check_stmt, 'ii', $last_id, $student_id);
                        mysqli_stmt_execute($check_stmt);
                        mysqli_stmt_store_result($check_stmt);
                        if (mysqli_stmt_num_rows($check_stmt) == 0) {
                          mysqli_stmt_close($check_stmt);
                          $insq2 = mysqli_query($con, "INSERT INTO teacherattendancedetails(teacherattendance_id,teacher_id,details,status) VALUES('".intval($last_id)."','".intval($student_id)."','',0)");
                          if ($insq2 === false && function_exists('log_db_error_global')) log_db_error_global($con, 'teacherattendancedetails: insert missing fallback');
                        } else {
                          mysqli_stmt_close($check_stmt);
                        }
                    } else {
                        $checkstudent =  mysqli_query($con, "SELECT * FROM teacherattendancedetails WHERE teacherattendance_id='$last_id' AND teacher_id='$student_id'");
                        if (mysqli_num_rows($checkstudent) == 0) {
                          $insq3 = mysqli_query($con, "INSERT INTO teacherattendancedetails(teacherattendance_id,teacher_id,details,status) VALUES('".intval($last_id)."','".intval($student_id)."','',0)");
                          if ($insq3 === false && function_exists('log_db_error_global')) log_db_error_global($con, 'teacherattendancedetails: insert missing fallback');
                        }
                    }
                  }

                  // Use a variable to store success message so it renders reliably in the form area below
                  $success_message = 'Attendance Successfully Added.';
                }
              }
              ADD_TEACHER_ATTENDANCE_END:
              ?>
            <div class="panel-body">
            <?php if (!empty($success_message)): ?>
              <div class="alert alert-success"><?php echo htmlspecialchars($success_message, ENT_QUOTES); ?></div>
            <?php endif; ?>
            <form action="" method="post">
                <div class="row">

                  <div class="form-group col-lg-4" id="data_1">
                    <label class="control-label">Date</label>
                    <div class="input-group date">
                      <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="date" required="required" placeholder="Date">
                    </div>
                  </div>
                  <div class="form-group col-lg-4">
                    <label class="control-label">*Term and Year</label>
                    <select name="term" class="form-control">
                      <?php
                      $terms =  mysqli_query($con, "SELECT  * FROM financialterms WHERE status=1");
                      while ($row =  mysqli_fetch_array($terms)) {
                        $financialterm_id = $row['financialterm_id'];
                        $term = $row['term'];
                        $year = $row['year'];
                        $startdate = $row['startdate'];
                        $enddate = $row['enddate'];
                        $status = $row['status'];
                      ?>
                        <option value="<?php echo $financialterm_id; ?>"><?php echo 'Term ' . $term . ' ' . $year; ?></option>
                      <?php } ?>
                    </select>
                  </div>
                  <div class="form-group col-lg-4">
                    <label class="control-label">* Time</label>
                    <select name="time" class="form-control">
                      <option value="" selected="selected">AM or PM ?</option>
                      <option value="AM">AM</option>
                      <option value="PM">PM</option>
                    </select>
                  </div>
                  <table class="display table  table-striped" id="datatable">
                    <thead>
                      <tr>
                        <th>&nbsp;</th>
                        <th>Full Names</th>
                        <th>Attendance</th>
                        <!-- <th>Nationality</th>
                        <th>Gender</th> -->

                      </tr>
                    </thead>
                    <tbody>

                      <?php
                      $students =  mysqli_query($con, "SELECT * FROM teachers WHERE status=1");
                      while ($row = mysqli_fetch_array($students)) {
                        $student_id = $row['teacher_id'];
                        $fullname = $row['fullname'];                       

                      ?>
                        <tr class="gradeA">
                          <td><input type="checkbox" class="hidden" id="attend<?php echo $student_id; ?>" name="attendance[]" value="<?php echo $student_id; ?>"></td>

                          <td><?php echo $fullname; ?></td>
                          <td>
                            <select name="status[]" class="form-control select_all" data-id="<?php echo $student_id; ?>">
                              <option selected="selected" value="">Select status</option>
                              <option value="1">Present</option>
                              <option value="2"> Late</option>
                              <option value="0">Absent</option>
                            </select>
                          </td>
                        </tr>
                      <?php } ?>
                    </tbody>
                  </table>
                  <button type="submit" class="btn btn-danger" id="hid" name="submit" disabled>Submit</button>
            </form>
            </div>
          </section>
        </div>

      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
  <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
  <script src="js/chosen/chosen.jquery.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script>
    var config = {
      '.chosen-select': {},
      '.chosen-select-deselect': {
        allow_single_deselect: true
      },
      '.chosen-select-no-single': {
        disable_search_threshold: 10
      },
      '.chosen-select-no-results': {
        no_results_text: 'Oops, nothing found!'
      },
      '.chosen-select-width': {
        width: "95%"
      }
    }
    for (var selector in config) {
      $(selector).chosen(config[selector]);
    }
  </script>
    <script>
    //         var checkboxe = $("#datatable input[type='checkbox']"),
    submitButt = $("#hid");
    // checkboxe.click(function() {
    //     submitButt.attr("disabled", !checkboxe.is(":checked"));
    // });
    // function to check if all select box options are selected
    function allSelected(selector) {
      let allSelected = true;
      selector.each(function() {
        // console.log(this.value)
        if (this.value == '') {
          // set submit button to disabled if any option is not selected
          submitButt.attr("disabled", true);
          allSelected = false;
        }
      });
      // set submit button to enabled if all options are selected
      if (allSelected) {
        submitButt.attr("disabled", false);
      }
    }
    // function to check/uncheck checkboxes based on selected dropdown option
    function check(val, selector) {
      if (val == '1') {
        selector.attr('checked', true);
      } else if (val == '2') {
        selector.attr('checked', true);
      } else {
        selector.attr('checked', false);
      }
    }

    $(document).ready(function() {
      // add onchange event to dropdown
      $(".select_all").change(function() {
        console.log(this.value)
        const selector = `#attend${$(this).data('id')}`;
        // check/uncheck checkboxes based on dropdown option
        check(this.value, $(selector));
        allSelected($(".select_all"));
      });

      $('#data_1 .input-group.date').datepicker({
        todayBtn: "linked",
        keyboardNavigation: false,
        forceParse: false,
        calendarWeeks: true,
        autoclose: true
      });
    });
  </script>
</body>

</html>