<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Allow Super Admin (1), Principal (2), HR Admin Director (9)
if ($user_level === 0 || !in_array($user_level, [1,2,9], true)) {
  header('Location:login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Add Teacher</title>
  <script src="js/jquery-1.10.2.min.js"></script>
  <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="js/jquery-migrate-1.2.1.min.js"></script>

  <link href="css/chosen/chosen.css" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php';
    //   echo str_replace('\', ' ',$organisation);
    ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-8">
          <section class="panel">
            <header class="panel-heading">
              Add New Teacher
            </header>
            <div class="panel-body">
              <?php
              if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $errors = [];
                $image_name = $_FILES['image']['name'] ?? '';
                $image_size = $_FILES['image']['size'] ?? 0;
                $image_temp = $_FILES['image']['tmp_name'] ?? '';
                $allowed_ext = array('jpg', 'jpeg', 'png', 'gif', '');
                $image_ext = $image_name ? strtolower(pathinfo($image_name, PATHINFO_EXTENSION)) : '';

                $fullname = trim($_POST['fullname'] ?? '');
                $username = trim($_POST['username'] ?? '');
                $password = trim($_POST['password'] ?? '');
                $repeat = trim($_POST['repeat'] ?? '');
                $phone = trim($_POST['phone'] ?? '');
                $email = trim($_POST['email'] ?? '');
                $designation = trim($_POST['designation'] ?? '');
                $classteacher = trim($_POST['classteacher'] ?? '');
                $class = isset($_POST['class']) ? (int) $_POST['class'] : 0;
                $gender = trim($_POST['gender'] ?? '');

                if ($image_ext && !in_array($image_ext, $allowed_ext)) $errors[] = 'Image File type not allowed';
                if ($image_size > 2097152) $errors[] = 'Maximum Image size is 2Mb';

                if (empty($fullname)) $errors[] = 'Full name is required';
                if (empty($gender)) $errors[] = 'Gender Not Selected';
                if ($password === '' || $repeat === '') $errors[] = 'Password and confirmation are required';
                if ($password !== $repeat) $errors[] = 'Passwords do not match';

                // check email uniqueness
                if ($email !== '') {
                  $cstmt = mysqli_prepare($con, "SELECT teacher_id FROM teachers WHERE email = ? AND status = 1 LIMIT 1");
                  if ($cstmt) {
                    mysqli_stmt_bind_param($cstmt, 's', $email);
                    mysqli_stmt_execute($cstmt);
                    mysqli_stmt_store_result($cstmt);
                    if (mysqli_stmt_num_rows($cstmt) > 0) $errors[] = 'Email already exists';
                    mysqli_stmt_close($cstmt);
                  }
                }

                // check username uniqueness
                if ($username !== '') {
                  $ustmt = mysqli_prepare($con, "SELECT teacher_id FROM teachers WHERE username = ? LIMIT 1");
                  if ($ustmt) {
                    mysqli_stmt_bind_param($ustmt, 's', $username);
                    mysqli_stmt_execute($ustmt);
                    mysqli_stmt_store_result($ustmt);
                    if (mysqli_stmt_num_rows($ustmt) > 0) $errors[] = 'Username already exists';
                    mysqli_stmt_close($ustmt);
                  }
                }

                if (!empty($errors)) {
                  foreach ($errors as $error) {
                    echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                  }
                } else {
                  include 'includes/thumbs3.php';
                  $hashed = password_hash($password, PASSWORD_DEFAULT);

                  $stmt = mysqli_prepare($con, "INSERT INTO teachers(fullname,username,password,gender,phone,email,ext,designation,class_id,classteacher,status) VALUES(?,?,?,?,?,?,?,?,?,?,'1')");
                  if ($stmt) {
                    mysqli_stmt_bind_param($stmt, 'ssssssssis', $fullname, $username, $hashed, $gender, $phone, $email, $image_ext, $designation, $class, $classteacher);
                    mysqli_stmt_execute($stmt);
                    if (mysqli_stmt_affected_rows($stmt) > 0) {
                      $last_id = mysqli_insert_id($con);
                    } else {
                      include_once __DIR__ . '/includes/db_debug_logger.php';
                      log_db_error_global($con, 'teachers: insert (no rows)');
                      $last_id = 0;
                    }
                    mysqli_stmt_close($stmt);
                  } else {
                    // fallback
                    $q_full = mysqli_real_escape_string($con, $fullname);
                    $q_user = mysqli_real_escape_string($con, $username);
                    $q_pass = mysqli_real_escape_string($con, $hashed);
                    $q_gender = mysqli_real_escape_string($con, $gender);
                    $q_phone = mysqli_real_escape_string($con, $phone);
                    $q_email = mysqli_real_escape_string($con, $email);
                    $q_ext = mysqli_real_escape_string($con, $image_ext);
                    $q_design = mysqli_real_escape_string($con, $designation);
                    $ins = mysqli_query($con, "INSERT INTO teachers(fullname,username,password,gender,phone,email,ext,designation,class_id,classteacher,status) VALUES('$q_full','$q_user','$q_pass','$q_gender','$q_phone','$q_email','$q_ext','$q_design','".(int)$class."','".mysqli_real_escape_string($con,$classteacher)."','1')");
                    if ($ins === false) {
                      include_once __DIR__ . '/includes/db_debug_logger.php';
                      log_db_error_global($con, 'teachers: insert fallback');
                    }
                    $last_id = mysqli_insert_id($con);
                  }

                  if ($last_id && !empty($image_name) && is_uploaded_file($image_temp)) {
                    $image_file = md5($last_id) . '.' . $image_ext;
                    move_uploaded_file($image_temp, 'images/teachers/' . $image_file);
                    create_thumb('images/teachers/', $image_file, 'images/teachers/thumbs/');
                  }

                  if ($last_id && !empty($_POST['role']) && is_array($_POST['role'])) {
                    $ins_ts = mysqli_prepare($con, "INSERT INTO teacher_subjects(class_sub_id,teacher_id) VALUES(?,?)");
                    foreach ($_POST['role'] as $t) {
                      $csub = (int)$t;
                      if ($ins_ts) {
                        mysqli_stmt_bind_param($ins_ts, 'ii', $csub, $last_id);
                        mysqli_stmt_execute($ins_ts);
                      } else {
                        mysqli_query($con, "INSERT INTO teacher_subjects(class_sub_id,teacher_id) VALUES('".(int)$csub."','".(int)$last_id."')");
                      }
                    }
                    if ($ins_ts) mysqli_stmt_close($ins_ts);
                  }

                  echo '<div class="alert alert-success">Teacher Data successfully Added</div>';
                }
              }

              ?>

              <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
                <div class="form-group"><label class="control-label">* Fullname</label>
                  <input type="text" name='fullname' class="form-control" placeholder="Enter fullname" required="required">

                </div>
                <div class="hr-line-dashed"></div>
                <div class="form-group"><label class="control-label">* Gender</label>

                  <select name="gender" class="form-control">
                    <option value="">select gender...</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                  </select>
                </div>
                <div class="hr-line-dashed"></div>
                <div class="form-group"><label class="control-label">* Class teacher or not ?</label>

                  <select name="classteacher" class="form-control classteacher">
                    <option value="">select option...</option>
                    <option value="yes">Yes</option>
                    <option value="no">No</option>
                  </select>

                </div>
                <div class="getclasses" style="display: none">
                  <div class="hr-line-dashed"></div>
                  <div class="form-group"><label class="control-label">* Select Class</label>
                    <select name="class" class="form-control">
                      <option value="">select Class...</option>
                      <?php
                      $getclasses =  mysqli_query($con, "SELECT * FROM classes WHERE status=1");
                      while ($row2 =  mysqli_fetch_array($getclasses)) {
                        $class_id = $row2['class_id'];
                        $class = $row2['class'];
                      ?>
                        <option value="<?php echo $class_id; ?>"><?php echo $class; ?></option>
                      <?php } ?>
                    </select>

                  </div>
                </div>
                <div class="hr-line-dashed"></div>

                <div class="form-group"><label class="control-label">*Phone</label>

                  <input type="text" name="phone" class="form-control" placeholder="Enter  phone Number" required="required">

                </div>

                <div class="hr-line-dashed"></div>
                <div class="form-group"><label class="control-label">Designation</label>

                  <input type="text" name="designation" class="form-control " placeholder="Enter Designation e.g sports master">
                </div>

                <div class="hr-line-dashed"></div>
                <div class="form-group">
                  <label class="control-label">Subjects Taught</label>
                  <select data-placeholder="Choose Subject and Class..." class="chosen-select" name='role[]' multiple style="width:100%;" tabindex="4">
                    <option value="">Assign Subject and class</option>
                    <?php
                    $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects");
                    while ($row = mysqli_fetch_array($class_subjects)) {
                      $class_sub_id = $row['class_sub_id'];
                      $class_id = $row['class_id'];
                      $subject_id = $row['subject_id'];
                      $getclasses =  mysqli_query($con, "SELECT * FROM classes WHERE class_id='$class_id'");
                      $row2 =  mysqli_fetch_array($getclasses);
                      $class = $row2['class'];
                      $getsubjects =  mysqli_query($con, "SELECT * FROM subjects WHERE subject_id='$subject_id'");
                      $row3 =  mysqli_fetch_array($getsubjects);
                      $subject = $row3['subject'];
                    ?>
                      <option value="<?php echo $class_sub_id; ?>"><?php echo $class . ':' . $subject; ?></option>
                    <?php } ?>
                  </select>
                </div>

                <div class="hr-line-dashed"></div>
                <div class="form-group"><label class="control-label"> *Profile picture</label>

                  <input type="file" name="image" class="form-control " style="padding: 0px">
                </div>
                <div class="hr-line-dashed"></div>
                <div class="form-group"><label class="control-label"> Email Address</label>

                  <input type="email" name="email" class="form-control " placeholder="Enter a valid email address">
                  <div id='form_email_errorloc' class='text-danger'></div>

                </div>
                <div class="hr-line-dashed"></div>
                <div class="form-group"><label class="control-label"> Username</label>

                  <input type="text" name="username" class="form-control " placeholder="Enter your username">

                </div>
                <div class="hr-line-dashed"></div>
                <div class="form-group"><label class="control-label">Password</label>
                  <input type="password" name="password" class="form-control " placeholder="Enter  password" required="required">
                  <div id='form_password_errorloc' class='text-danger'></div>

                </div>
                <div class="hr-line-dashed"></div>
                <div class="form-group"><label class="control-label">Repeat Password</label>
                  <input type="password" name="repeat" class="form-control " placeholder="Repeat password" required="required">
                  <div id='form_repeat_errorloc' class='text-danger'></div>
                </div>


                <div class="hr-line-dashed"></div>


                <div class="form-group">
                  <button class="btn btn-primary" type="submit">Add Teacher</button>
                </div>
              </form>
            </div>

        </div>
    </section>

    </div>

    </div>


    </div>
    <!-- page end-->
  </section>
  <!--body wrapper end-->

  <!--footer section start-->

  <!--footer section end-->


  </div>
  <!-- main content end-->
  </section>

  <script src="js/bootstrap.min.js"></script>
  <script src="js/modernizr.min.js"></script>
  <script src="js/jquery.nicescroll.js"></script>
  <script type="text/javascript" src="js/gen_validatorv4.js"></script>
  <script src="js/chosen/chosen.jquery.js"></script>
  <script src="js/scripts.js"></script>
  <script>
    var config = {
      '.chosen-select': {},
      '.chosen-select-deselect': {
        allow_single_deselect: true
      },
      '.chosen-select-no-single': {
        disable_search_threshold: 10
      },
      '.chosen-select-no-results': {
        no_results_text: 'Oops, nothing found!'
      },
      '.chosen-select-width': {
        width: "95%"
      }
    }
    for (var selector in config) {
      $(selector).chosen(config[selector]);
    }
    var frmvalidator = new Validator("form");
    frmvalidator.EnableOnPageErrorDisplay();
    frmvalidator.EnableMsgsTogether();
    frmvalidator.addValidation("email", "email", "*Enter a valid  email address");
    //             frmvalidator.addValidation("password","minlength=6","*password  should atleast be 6 characters");
    frmvalidator.addValidation("repeat", "eqelmnt=password", "*The passwords dont match");
    $('.classteacher').on('change', function() {
      var getselect = $(this).val();

      if (getselect === 'yes') {
        $('.getclasses').show();
      } else {
        $('.getclasses').hide();
      }
    });
  </script>
</body>

</html>