<?php
include 'includes/conn.php';
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}
// require school admin
if (!isset($_SESSION['schoolsys']) || !isset($_SESSION['schoolsyslevel']) || (int)$_SESSION['schoolsyslevel'] !== 1) {
  header('Location:login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Add Subject</title>
  <script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>

       <link href="css/chosen/chosen.css" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; 
//   echo str_replace('\', ' ',$organisation);
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
                     
            <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                   Add  Subject
                    </header>
                    <div class="panel-body">
         <?php
        if (isset($_POST['subject'])) {
          $errors = [];
          $subject = trim($_POST['subject']);
          $classes_selected = isset($_POST['class']) && is_array($_POST['class']) ? $_POST['class'] : [];

          if (empty($subject)) {
            $errors[] = 'Enter subject name.';
          }

          if (!empty($errors)) {
            foreach ($errors as $error) {
              echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
            }
          } else {
            // ensure creator is an integer user id and status is an int
            $creator = isset($_SESSION['schoolsys']) ? (int) $_SESSION['schoolsys'] : 0;
            $status = 1;
            $stmt = mysqli_prepare($con, "INSERT INTO subjects(subject,creator,status) VALUES(?,?,?)");
            if ($stmt) {
              // subject = string, creator = int, status = int
              mysqli_stmt_bind_param($stmt, 'sii', $subject, $creator, $status);
              $exec = mysqli_stmt_execute($stmt);
              if ($exec) {
                $last_id = mysqli_insert_id($con);
              } else {
                error_log('DB error (subjects insert): ' . mysqli_stmt_error($stmt));
                echo '<div class="alert alert-danger">Could not add subject. Try again later.</div>';
                $last_id = 0;
              }
              mysqli_stmt_close($stmt);
            } else {
              $subject_e = mysqli_real_escape_string($con, $subject);
              $creator_e = mysqli_real_escape_string($con, $creator);
              $q = "INSERT INTO subjects(subject,creator,status) VALUES('$subject_e','$creator_e',1)";
              if (mysqli_query($con, $q)) {
                $last_id = mysqli_insert_id($con);
              } else {
                error_log('DB error (subjects insert fallback): ' . mysqli_error($con));
                echo '<div class="alert alert-danger">Could not add subject. Try again later.</div>';
                $last_id = 0;
              }
            }

            if ($last_id && !empty($classes_selected)) {
              $ins_stmt = mysqli_prepare($con, "INSERT INTO class_subjects(class_id,subject_id) VALUES(?,?)");
              foreach ($classes_selected as $c) {
                $c_id = (int) $c;
                if ($c_id <= 0) continue;
                if ($ins_stmt) {
                  mysqli_stmt_bind_param($ins_stmt, 'ii', $c_id, $last_id);
                  mysqli_stmt_execute($ins_stmt);
                } else {
                  $q = "INSERT INTO class_subjects(class_id,subject_id) VALUES('$c_id','$last_id')";
                  mysqli_query($con, $q);
                }
              }
              if ($ins_stmt) mysqli_stmt_close($ins_stmt);
            }

            if ($last_id) {
              echo '<div class="col-sm-2"></div><div class="col-sm-10"><div class="alert alert-success"><i class="fa fa-check"></i>Subject Successfully Added</div></div>';
            }
          }
        }
        ?>
                        
     <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">
                                  <div class="form-group"><label class="control-label"> *Subject Name</label>
<input type="text" name="subject" class="form-control "  placeholder="Enter  name" required="required">
                                                                     
                                </div>      
                                <div class="form-group">
                                <label class="control-label">Select Class(s)</label>
                                                  <select data-placeholder="Choose a class..." class="chosen-select" name='class[]' multiple style="width:100%;" tabindex="4">
                                    <option value="">Assign Role</option>
                  <?php
                  $classes_stmt = mysqli_prepare($con, "SELECT class_id,class FROM classes WHERE status = ? ORDER BY class ASC");
                  if ($classes_stmt) {
                    $active = 1;
                    mysqli_stmt_bind_param($classes_stmt, 'i', $active);
                    mysqli_stmt_execute($classes_stmt);
                    $res = mysqli_stmt_get_result($classes_stmt);
                    while ($row = mysqli_fetch_assoc($res)) {
                      $class_id = (int) $row['class_id'];
                      $class_name = $row['class'];
                      echo '<option value="' . $class_id . '">' . htmlspecialchars($class_name, ENT_QUOTES) . '</option>';
                    }
                    mysqli_stmt_close($classes_stmt);
                  } else {
                    $classes = mysqli_query($con, "SELECT class_id,class FROM classes WHERE status=1 ORDER BY class ASC");
                    if ($classes) {
                      while ($row = mysqli_fetch_assoc($classes)) {
                        $class_id = (int) $row['class_id'];
                        $class_name = $row['class'];
                        echo '<option value="' . $class_id . '">' . htmlspecialchars($class_name, ENT_QUOTES) . '</option>';
                      }
                    }
                  }
                  ?>
                                               </select>                     
                                                         </div>
                                                                                                  
                                <div class="form-group">
                                        <button class="btn btn-primary" type="submit">Add</button>
                              
                                </div>
                            </form>
                            </div>

                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="js/gen_validatorv4.js"></script>
  <script src="js/chosen/chosen.jquery.js"></script>
<script src="js/scripts.js"></script>
<script>
         var config = {
                '.chosen-select'           : {},
                '.chosen-select-deselect'  : {allow_single_deselect:true},
                '.chosen-select-no-single' : {disable_search_threshold:10},
                '.chosen-select-no-results': {no_results_text:'Oops, nothing found!'},
                '.chosen-select-width'     : {width:"95%"}
            }
            for (var selector in config) {
                $(selector).chosen(config[selector]);
            }
  
</script>
</body>
</html>
