<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel']!=1)&&($_SESSION['schoolsyslevel']!=2)&&($_SESSION['schoolsyslevel']!=6))){
    header('Location:login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Student</title>  
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/ckeditor/ckeditor.js"></script>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
  <link href="css/jquery.filer.css" rel="stylesheet">
 
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
   <link href="css/chosen/chosen.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; 
//   echo str_replace('\', ' ',$organisation);
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
            <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                   Add New Student
                    </header>
                    <div class="panel-body">
                         <?php
// Initialize image upload variables safely to avoid warnings when no file is uploaded
$image_name = $_FILES['image']['name'] ?? '';
$image_size = $_FILES['image']['size'] ?? 0;
$image_temp = $_FILES['image']['tmp_name'] ?? '';
$allowed_ext = array('jpg','jpeg','png','PNG','gif','JPG','PNG','GIF','JPEG','');
$image_ext = '';
       if(isset($_POST['fullname'],$_POST['nationality'],$_POST['gender'],$_POST['class'],$_POST['year'],$_POST['term'])){
           // re-read uploaded file info inside POST handling (fresh values)
           $image_name = $_FILES['image']['name'] ?? '';
           $image_size = $_FILES['image']['size'] ?? 0;
           $image_temp = $_FILES['image']['tmp_name'] ?? '';
           $allowed_ext = array('jpg','jpeg','png','gif','');
           $imgext = $image_name ? pathinfo($image_name, PATHINFO_EXTENSION) : '';
           $image_ext = strtolower($imgext);

        $fullname = trim($_POST['fullname']);
        $nationality = trim($_POST['nationality']);
        $regnumber = trim($_POST['regnumber'] ?? '');
        $birthday_ts = !empty($_POST['birthday']) ? strtotime($_POST['birthday']) : 0;
        $gender = $_POST['gender'];
        $class = $_POST['class'];
        $year = $_POST['year'];
        $term = $_POST['term'];
        $number = trim($_POST['number'] ?? '');
        $fathername = trim($_POST['fathername'] ?? '');
        $fatheroccupation = trim($_POST['fatheroccupation'] ?? '');
        $fatheremail = trim($_POST['fatheremail'] ?? '');
        $fatherphone = trim($_POST['fatherphone'] ?? '');
        $mothername = trim($_POST['mothername'] ?? '');
        $motheroccupation = trim($_POST['motheroccupation'] ?? '');
        $motheremail = trim($_POST['motheremail'] ?? '');
        $motherphone = trim($_POST['motherphone'] ?? '');
        $firstlanguage = trim($_POST['firstlanguage'] ?? '');
        $otherlanguages = trim($_POST['otherlanguages'] ?? '');
        $englishlevel = trim($_POST['englishlevel'] ?? '');
        $spokenhome = trim($_POST['spokenhome'] ?? '');
        $checkreg = mysqli_prepare($con, "SELECT student_id FROM students WHERE regnumber = ? AND status = 1 LIMIT 1");
        if ($checkreg && $regnumber !== '') {
            mysqli_stmt_bind_param($checkreg, 's', $regnumber);
            mysqli_stmt_execute($checkreg);
            mysqli_stmt_store_result($checkreg);
            if (mysqli_stmt_num_rows($checkreg) > 0) {
                $errors[] = 'Student Number already Exists';
            }
            mysqli_stmt_close($checkreg);
        }
                 if(!empty($regnumber)){
                     if(mysqli_num_rows($checkreg)>0){
                         $errors[]='Student Number already Exists';
                     }
                 }
                if(!empty($image_name)){
                    if (!in_array($image_ext,$allowed_ext)){
                        $errors[]='Image File type not allowed';
                    }
                    if($image_size>5097152){
                        $errors[]='Maximum Image size is 5Mb';
                    }
                }

  if(empty($class)){
   $errors[]='class Not Selected'; 
}
  if(empty($year)){
   $errors[]='Year Not Selected'; 
}
  if(empty($term)){
   $errors[]='Term Not Selected'; 
}
 if(empty($gender)){
   $errors[]='Gender Not Selected'; 
}
if(!empty($errors)){
foreach($errors as $error){ 
 ?>
 <div class="alert alert-danger"><?php echo $error; ?></div>
<?php 
}         }else{
        $split = explode('_', $class);
        $class_id = (int) current($split);
        $stream_id = (int) end($split);        
        include 'includes/thumbs3.php';

        // prepared insert for students
        $ins = mysqli_prepare($con, "INSERT INTO students(regnumber,fullname,gender,ext,joiningyear,joiningterm,birthday,nationality,class_id,stream_id,number,fathername,fatheroccupation,fatheremail,fatherphone,mothername,motheroccupation,motheremail,motherphone,firstlanguage,otherlanguages,englishlevel,spokenhome,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,1)");
        if ($ins) {
            $birthday_val = $birthday_ts > 0 ? $birthday_ts : 0;
            // dynamic bind: build parameter list and a types string that matches automatically
            $bind_params = array(
                $regnumber,$fullname,$gender,$image_ext,$year,$term,$birthday_val,$nationality,$class_id,$stream_id,$number,$fathername,$fatheroccupation,$fatheremail,$fatherphone,$mothername,$motheroccupation,$motheremail,$motherphone,$firstlanguage,$otherlanguages,$englishlevel,$spokenhome
            );
            $types = str_repeat('s', count($bind_params));
            // convert integers to strings for binding (mysqli will coerce types)
            $bind_refs = array();
            foreach ($bind_params as $key => $value) {
                $bind_refs[$key] = &$bind_params[$key];
            }
            array_unshift($bind_refs, $types);
            call_user_func_array(array($ins, 'bind_param'), $bind_refs);
            mysqli_stmt_execute($ins);
            $last_id = mysqli_insert_id($con);
            mysqli_stmt_close($ins);
        } else {
            // fallback escaped insert
            $q = sprintf("INSERT INTO students(regnumber,fullname,gender,ext,joiningyear,joiningterm,birthday,nationality,class_id,stream_id,number,fathername,fatheroccupation,fatheremail,fatherphone,mothername,motheroccupation,motheremail,motherphone,firstlanguage,otherlanguages,englishlevel,spokenhome,status) VALUES('%s','%s','%s','%s','%d','%d','%d','%s','%d','%d','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','1')",
                mysqli_real_escape_string($con,$regnumber),
                mysqli_real_escape_string($con,$fullname),
                mysqli_real_escape_string($con,$gender),
                mysqli_real_escape_string($con,$image_ext),
                (int)$year,
                (int)$term,
                (int)$birthday_ts,
                mysqli_real_escape_string($con,$nationality),
                (int)$class_id,
                (int)$stream_id,
                mysqli_real_escape_string($con,$number),
                mysqli_real_escape_string($con,$fathername),
                mysqli_real_escape_string($con,$fatheroccupation),
                mysqli_real_escape_string($con,$fatheremail),
                mysqli_real_escape_string($con,$fatherphone),
                mysqli_real_escape_string($con,$mothername),
                mysqli_real_escape_string($con,$motheroccupation),
                mysqli_real_escape_string($con,$motheremail),
                mysqli_real_escape_string($con,$motherphone),
                mysqli_real_escape_string($con,$firstlanguage),
                mysqli_real_escape_string($con,$otherlanguages),
                mysqli_real_escape_string($con,$englishlevel),
                mysqli_real_escape_string($con,$spokenhome)
            );
            $res = mysqli_query($con, $q);
            if ($res === false) {
                include_once __DIR__ . '/includes/db_debug_logger.php';
                log_db_error_global($con, 'students: insert fallback');
            }
            $last_id = mysqli_insert_id($con);
        }

        if ($last_id && !empty($image_name) && is_uploaded_file($image_temp)) {
            $image_file = md5($last_id) . '.' . $image_ext;
            move_uploaded_file($image_temp, 'images/students/' . $image_file);
            create_thumb('images/students/', $image_file, 'images/students/thumbs/');
        } elseif ($last_id) {
            $image_name = md5($last_id);
            if (!file_exists('images/students/' . $image_name . '.png')) {
                copy('images/avatar.png', 'images/students/' . $image_name . '.png');
            }
            create_thumb('images/students/', $image_name . '.png', 'images/students/thumbs/');
        }
                // --- sibling/family detection and automatic discount assignment ---
                // Ensure students table has family_id column
                // check if family_id column exists; do not alter schema automatically on production hosts
                $colCheck = mysqli_query($con, "SHOW COLUMNS FROM students LIKE 'family_id'");
                $hasFamilyIdColumn = ($colCheck && mysqli_num_rows($colCheck) > 0);

                // normalize parent identifiers
                $fphone = trim($fatherphone);
                $mphone = trim($motherphone);
                $femail = trim($fatheremail);
                $memail = trim($motheremail);

                // try to find existing family by matching parent contacts
                $foundFamilyId = 0;
                if ($hasFamilyIdColumn) {
                    $searchParts = [];
                    if ($fphone !== '') $searchParts[] = "fatherphone='" . mysqli_real_escape_string($con, $fphone) . "'";
                    if ($mphone !== '') $searchParts[] = "motherphone='" . mysqli_real_escape_string($con, $mphone) . "'";
                    if ($femail !== '') $searchParts[] = "fatheremail='" . mysqli_real_escape_string($con, $femail) . "'";
                    if ($memail !== '') $searchParts[] = "motheremail='" . mysqli_real_escape_string($con, $memail) . "'";
                    if (!empty($searchParts)) {
                        $where = implode(' OR ', $searchParts);
                        $q = mysqli_query($con, "SELECT * FROM students WHERE (" . $where . ") AND status=1 AND student_id!=$last_id LIMIT 1");
                        if ($q && mysqli_num_rows($q) > 0) {
                            $er = mysqli_fetch_assoc($q);
                            $foundFamilyId = isset($er['family_id']) && (int)$er['family_id'] > 0 ? (int)$er['family_id'] : (int)$er['student_id'];
                            // ensure existing record has the family_id set
                            if (empty($er['family_id']) || (int)$er['family_id'] == 0) {
                                mysqli_query($con, "UPDATE students SET family_id={$foundFamilyId} WHERE student_id=" . (int)$er['student_id']);
                            }
                        }
                    }
                }

                // if no existing family found, leave family_id as 0. If found, update new student
                if ($foundFamilyId > 0 && $hasFamilyIdColumn) {
                    mysqli_query($con, "UPDATE students SET family_id={$foundFamilyId} WHERE student_id=" . (int)$last_id);

                    // Determine how many siblings (excluding nursery) are in this family
                    // Exclude classes with name containing 'nursery' (case-insensitive)
                    $cntQ = mysqli_query($con, "SELECT COUNT(*) AS cnt FROM students s JOIN classes c ON s.class_id=c.class_id WHERE s.family_id={$foundFamilyId} AND s.status=1 AND LOWER(c.class) NOT LIKE '%nursery%'");
                    $cntRow = $cntQ ? mysqli_fetch_assoc($cntQ) : null;
                    $siblingCount = isset($cntRow['cnt']) ? (int)$cntRow['cnt'] : 0; // includes the newly added student

                    // Determine new student's class name to ensure it's not nursery
                    $classQ = mysqli_query($con, "SELECT class FROM classes WHERE class_id=" . (int)$class_id . " LIMIT 1");
                    $classRow = $classQ ? mysqli_fetch_assoc($classQ) : null;
                    $newClassName = $classRow['class'] ?? '';

                    if (stripos($newClassName, 'nursery') === false) {
                        // siblingCount includes the new student; compute position
                        if ($siblingCount == 2) {
                            $discountPercent = 10;
                        } elseif ($siblingCount >= 3) {
                            $discountPercent = 20;
                        } else {
                            $discountPercent = 0;
                        }

                        if ($discountPercent > 0) {
                            // find current financial term (active)
                            $termQ = mysqli_query($con, "SELECT financialterm_id FROM financialterms WHERE status=1 ORDER BY financialterm_id DESC LIMIT 1");
                            $termRow = $termQ ? mysqli_fetch_assoc($termQ) : null;
                            $currentTerm = $termRow['financialterm_id'] ?? 0;
                            if ($currentTerm > 0) {
                                // avoid duplicate discount entries
                                $chk = mysqli_query($con, "SELECT * FROM discounts WHERE student_id=" . (int)$last_id . " AND term_id=" . (int)$currentTerm . " AND status=1");
                                if (!$chk || mysqli_num_rows($chk) == 0) {
                                    mysqli_query($con, "INSERT INTO discounts(student_id,discount,class_id,term_id,status) VALUES('" . (int)$last_id . "','" . (int)$discountPercent . "','" . (int)$class_id . "','" . (int)$currentTerm . "','1')");
                                }
                            }
                        }
                    }
                }
                // --- end sibling/family detection ---
                echo '<div class="alert alert-success">Student Data succesfully Added</div>';      
                                }
                                }                                
                                    ?>                        
     <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">         
                                <div class="form-group"><label class="control-label">* Full name</label>
<input type="text" name='fullname' class="form-control" placeholder="Enter full Name" required="required">
                                                                                                            </div>                             
                                  <div class="form-group"><label class="control-label">* Gender</label>
                                        <select name="gender" class="form-control">
                                            <option value="">select gender...</option>
                                            <option value="Male">Male</option>
                                            <option value="Female">Female</option>
                                        </select>
                                  </div>
                                 <div class="hr-line-dashed"></div>
                                  <div class="form-group"><label class="control-label">* Class & Stream</label>
                                      <select data-placeholder="Choose class..." name="class" class="chosen-select" style="width:100%;" tabindex="2">
                                            <option value="">Select Class...</option>
                                               <?php
                                   $getclass=  mysqli_query($con,"SELECT * FROM classes WHERE  status=1");
                                   while($row2=  mysqli_fetch_array($getclass)){
                                     $classname=$row2['class'];
                                     $class_id=$row2['class_id'];
                                        $getstreams=mysqli_query($con,"SELECT * FROM streams WHERE class_id='$class_id'");
                                            if(mysqli_num_rows($getstreams)>0){
                            while ($row = mysqli_fetch_array($getstreams)) {
                                    $stream_id=$row['stream_id'];
                                    $stream=$row['stream'];    
                            ?>
                                            <option value="<?php echo $class_id.'_'.$stream_id;?>"><?php echo $classname.' '.$stream; ?></option>
                            <?php }}else{ ?>
                                        <option value="<?php echo $class_id.'_0';?>"><?php echo $classname; ?></option>
                                   <?php    }} ?>
                                                                                 </select>
                                                                                                     </div>
                                <div class="hr-line-dashed"></div>
                                  <div class="form-group"><label class="control-label">* Joining Year</label>
                                        <select name="year" class="form-control">
                                            <option value="">select joining year...</option>
                                        <option value="<?php echo date('Y',$timenow); ?>"><?php echo date('Y',$timenow); ?></option>
                                                            <?php
                                                            $datenow=date('Y',$timenow); 
                                                                 for ($x = 0; $x <= 15; $x++) {
                                                                     $datenow=$datenow-1;
                                                      echo '<option value="'.$datenow.'">'.$datenow.'</option>';
                                                                        }
                                                                                  ?> 
                                        </select>
                                                                        </div>
                                    <div class="form-group"><label class="control-label">* Joining Term</label>
                                        <select name="term" class="form-control">
                                            <option value="">select term...</option>
                                           <option value="1">Term 1</option>
                                            <option value="2">Term 2</option>
                                            <option value="3">Term 3</option>
                                        </select>
                                        </div>
                                                                                                 <div class="form-group" id="data_1">
                              <label class="control-label">Birthday</label>
                                    <div class="input-group date">
                                          <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="birthday" required="required" placeholder="Select Birthday">
                                                 </div>
                                                              </div>
                                                    
                                  <div class="form-group"><label class="control-label">Profile picture</label>

                             <input type="file"  name="image" class="form-control " style="padding: 0px"></div>
                             
                                   <div class="form-group"><label class="control-label">Nationality</label>
                         <input type="text" name='nationality' class="form-control" placeholder="Enter Student Nationality">
                                                                            </div>
                                 <div class="form-group"><label class="control-label">Phone Number</label>
                         <input type="text" name='number' class="form-control" placeholder="Enter Phone Number">
                                                                            </div>
                                                          <div class="form-group">
                                                              <label class="control-label">Student Number</label>
                         <input type="text" name='regnumber' class="form-control" placeholder="Enter Student Number">
                                                                            </div>       
                                <h2>Parents Details</h2>
                                <div class='row'>
                                <div class='col-lg-6'>
                                <h4>Father's Details</h4>
                                    <div class="form-group">
                                                              <label class="control-label">Father's Name</label>
                         <input type="text" name='fathername' class="form-control" placeholder="Enter Father's name">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Father's Occupation</label>
                         <input type="text" name='fatheroccupation' class="form-control" placeholder="Enter Father's Occupation">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Father's Contact Number</label>
                         <input type="text" name='fatherphone' class="form-control" placeholder="Enter Father's contact">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Father's Email</label>
                         <input type="text" name='fatheremail' class="form-control" placeholder="Enter Father's email">
                                                                            </div> 
                                      </div>
                                      <div class='col-lg-6'>
                                <h4>Mother's Details</h4>
                                   <div class="form-group">
                                                              <label class="control-label">Mother's Name</label>
                         <input type="text" name='mothername' class="form-control" placeholder="Enter Mother's name">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Mother's Occupation</label>
                         <input type="text" name='motheroccupation' class="form-control" placeholder="Enter Mother's Occupation">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Mother's Contact Number</label>
                         <input type="text" name='motherphone' class="form-control" placeholder="Enter Mother's contact">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Mother's Email</label>
                         <input type="text" name='motheremail' class="form-control" placeholder="Enter Mother's email">
                                                                            </div> 
                                      </div>
                                    
                                                                </div>
                                <h2>Language proficiency</h2>
                                   <div class="form-group">
                                                              <label class="control-label">Student first language</label>
                         <input type="text" name='firstlanguage' class="form-control" placeholder="Enter First Language">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Student other languages (Seperate with comma)</label>
                         <input type="text" name='otherlanguages' class="form-control" placeholder="Enter other languages seperated with commas">
                                                                            </div> 
 <div class="form-group">
                                                              <label class="control-label">How is student’s English level?</label>
                         <input type="text" name='englishlevel' class="form-control" placeholder="Enter English Level">
                                                                            </div> 
 <div class="form-group">
                                                              <label class="control-label">Language spoken home</label>
                         <input type="text" name='spokenhome' class="form-control" placeholder="Enter  Language spoken home">
                                                                            </div>
                                <div class="form-group">
                                        <button class="btn btn-primary" type="submit">Add Student</button>
                               
                                </div>
                            </form>
                            </div>

                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="js/gen_validatorv4.js"></script>
   <script src="datapicker/bootstrap-datepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/chosen/chosen.jquery.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
</body>
</html>
<script>
    $(document).ready(function(){
            $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });
            });
             var config = {
                '.chosen-select'           : {},
                '.chosen-select-deselect'  : {allow_single_deselect:true},
                '.chosen-select-no-single' : {disable_search_threshold:10},
                '.chosen-select-no-results': {no_results_text:'Oops, nothing found!'},
                '.chosen-select-width'     : {width:"95%"}
            }
            for (var selector in config) {
                $(selector).chosen(config[selector]);
            }

                </script>