<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
  header('Location:login.php');
  exit;
}
?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Add attendance-School Manager</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="css/chosen/chosen.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-10">
          <section class="panel">
            <header class="panel-heading">
              Add Staff Attendance
            </header>
            <?php
              if (isset($_POST['date'], $_POST['term'], $_POST['time'])) {
                include_once __DIR__ . '/includes/db_debug_logger.php';
                $date_input = !empty($_POST['date']) ? trim($_POST['date']) : '';
                $date_ts = strtotime($date_input);
                $date_val = $date_ts ? date('Y-m-d', $date_ts) : '';  // Convert to DATE format
                $term = isset($_POST['term']) ? (int)$_POST['term'] : 0;
                $time = isset($_POST['time']) ? trim($_POST['time']) : '';
                $attendance = isset($_POST['attendance']) && is_array($_POST['attendance']) ? $_POST['attendance'] : [];
                $status_arr = isset($_POST['status']) && is_array($_POST['status']) ? $_POST['status'] : [];

                if (empty($date_val) || $term <= 0 || $time === '') {
                  echo '<div class="alert alert-danger">Some Fields are Empty or invalid</div>';
                } else {
                  // insert main attendance row
                  $last_id = 0;
                  $ins_stmt = mysqli_prepare($con, "INSERT INTO staffattendance(`date`,term_id,time,status) VALUES(?,?,?,1)");
                  if ($ins_stmt) {
                    mysqli_stmt_bind_param($ins_stmt, 'sis', $date_val, $term, $time);  // Changed from 'iis' to 'sis'
                    mysqli_stmt_execute($ins_stmt);
                    $last_id = mysqli_insert_id($con);
                    mysqli_stmt_close($ins_stmt);
                  } else {
                    $q = sprintf("INSERT INTO staffattendance(`date`,term_id,time,status) VALUES('%s','%d','%s',1)", mysqli_real_escape_string($con, $date_val), (int)$term, mysqli_real_escape_string($con, $time));
                    $res = mysqli_query($con, $q);
                    if ($res === false) log_db_error($con, 'staffattendance: insert fallback');
                    $last_id = mysqli_insert_id($con);
                  }

                  // insert provided attendance details
                  if ($last_id && !empty($attendance)) {
                    $detail_stmt = mysqli_prepare($con, "INSERT INTO staffattendancedetails(staffattendance_id,staff_id,details,status) VALUES(?,?,?,?)");
                    for ($i = 0; $i < count($attendance); $i++) {
                      $staff_id = (int) $attendance[$i];
                      $stat = isset($status_arr[$i]) ? (int)$status_arr[$i] : 0;
                      if ($detail_stmt) {
                        $details = '';
                        mysqli_stmt_bind_param($detail_stmt, 'iisi', $last_id, $staff_id, $details, $stat);
                        mysqli_stmt_execute($detail_stmt);
                      } else {
                        $q = sprintf("INSERT INTO staffattendancedetails(staffattendance_id,staff_id,details,status) VALUES('%d','%d','%s','%d')", (int)$last_id, (int)$staff_id, mysqli_real_escape_string($con, ''), (int)$stat);
                        $r = mysqli_query($con, $q);
                        if ($r === false) log_db_error($con, 'staffattendancedetails: insert fallback');
                      }
                    }
                    if ($detail_stmt) mysqli_stmt_close($detail_stmt);
                  }

                  // ensure all staff have a row
                  $getstaff = mysqli_query($con, "SELECT staff_id FROM staff WHERE status=1");
                  while ($row = mysqli_fetch_assoc($getstaff)) {
                    $staff_id = (int)$row['staff_id'];
                    // check existence
                    $check_stmt = mysqli_prepare($con, "SELECT staff_id FROM staffattendancedetails WHERE staffattendance_id = ? AND staff_id = ?");
                    if ($check_stmt) {
                      mysqli_stmt_bind_param($check_stmt, 'ii', $last_id, $staff_id);
                      mysqli_stmt_execute($check_stmt);
                      mysqli_stmt_store_result($check_stmt);
                      if (mysqli_stmt_num_rows($check_stmt) == 0) {
                        mysqli_stmt_close($check_stmt);
                        $ins_q = mysqli_query($con, "INSERT INTO staffattendancedetails(staffattendance_id,staff_id,details,status) VALUES('".(int)$last_id."','".(int)$staff_id."','',0)") or log_db_error($con, 'staffattendancedetails: missing row fallback');
                      } else {
                        mysqli_stmt_close($check_stmt);
                      }
                    } else {
                      $checkstudent =  mysqli_query($con, "SELECT * FROM staffattendancedetails WHERE staffattendance_id='" . (int)$last_id . "' AND staff_id='" . (int)$staff_id . "'");
                      if (!$checkstudent || mysqli_num_rows($checkstudent) == 0) {
                        mysqli_query($con, "INSERT INTO staffattendancedetails(staffattendance_id,staff_id,details,status) VALUES('" . (int)$last_id . "','" . (int)$staff_id . "','',0)") or log_db_error($con, 'staffattendancedetails: missing row fallback2');
                      }
                    }
                  }

                  echo '<div class="alert alert-success">Attendance Successfully Added.</div>';
                }
              }
              ?>
            <div class="panel-body">
            <form action="" method="post">
                <div class="row">

                  <div class="form-group col-lg-4" id="data_1">
                    <label class="control-label">Date</label>
                    <div class="input-group date">
                      <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="date" required="required" placeholder="Date">
                    </div>
                  </div>
                  <div class="form-group col-lg-4">
                    <label class="control-label">*Term and Year</label>
                    <select name="term" class="form-control">
                      <?php
                      $terms =  mysqli_query($con, "SELECT  * FROM financialterms WHERE status=1");
                      while ($row =  mysqli_fetch_array($terms)) {
                        $financialterm_id = $row['financialterm_id'];
                        $term = $row['term'];
                        $year = $row['year'];
                        $startdate = $row['startdate'];
                        $enddate = $row['enddate'];
                        $status = $row['status'];
                      ?>
                        <option value="<?php echo $financialterm_id; ?>"><?php echo 'Term ' . $term . ' ' . $year; ?></option>
                      <?php } ?>
                    </select>
                  </div>
                  <div class="form-group col-lg-4">
                    <label class="control-label">* Time</label>
                    <select name="time" class="form-control">
                      <option value="" selected="selected">AM or PM ?</option>
                      <option value="AM">AM</option>
                      <option value="PM">PM</option>
                    </select>
                  </div>
                  <table class="display table  table-striped" id="datatable">
                    <thead>
                      <tr>
                        <th>&nbsp;</th>
                        <th>Full Names</th>
                        <th>Attendance</th>
                        <!-- <th>Nationality</th>
                        <th>Gender</th> -->

                      </tr>
                    </thead>
                    <tbody>

                      <?php
                      $students =  mysqli_query($con, "SELECT * FROM staff WHERE status=1");
                      while ($row = mysqli_fetch_array($students)) {
                        $student_id = $row['staff_id'];
                        $fullname = $row['fullname'];                       

                      ?>
                        <tr class="gradeA">
                          <td><input type="checkbox" class="hidden" id="attend<?php echo $student_id; ?>" name="attendance[]" value="<?php echo $student_id; ?>"></td>

                          <td><?php echo $fullname; ?></td>
                          <td>
                            <select name="status[]" class="form-control select_all" data-id="<?php echo $student_id; ?>">
                              <option selected="selected" value="">Select status</option>
                              <option value="1">Present</option>
                              <option value="2"> Late</option>
                              <option value="0">Absent</option>
                            </select>
                          </td>
                        </tr>
                      <?php } ?>
                    </tbody>
                  </table>
                  <button type="submit" class="btn btn-danger" id="hid" name="submit" disabled>Submit</button>
            </form>
            </div>
          </section>
        </div>

      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
  <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
  <script src="js/chosen/chosen.jquery.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script>
    var config = {
      '.chosen-select': {},
      '.chosen-select-deselect': {
        allow_single_deselect: true
      },
      '.chosen-select-no-single': {
        disable_search_threshold: 10
      },
      '.chosen-select-no-results': {
        no_results_text: 'Oops, nothing found!'
      },
      '.chosen-select-width': {
        width: "95%"
      }
    }
    for (var selector in config) {
      $(selector).chosen(config[selector]);
    }
  </script>
    <script>
    //         var checkboxe = $("#datatable input[type='checkbox']"),
    submitButt = $("#hid");
    // checkboxe.click(function() {
    //     submitButt.attr("disabled", !checkboxe.is(":checked"));
    // });
    // function to check if all select box options are selected
    function allSelected(selector) {
      let allSelected = true;
      selector.each(function() {
        // console.log(this.value)
        if (this.value == '') {
          // set submit button to disabled if any option is not selected
          submitButt.attr("disabled", true);
          allSelected = false;
        }
      });
      // set submit button to enabled if all options are selected
      if (allSelected) {
        submitButt.attr("disabled", false);
      }
    }
    // function to check/uncheck checkboxes based on selected dropdown option
    function check(val, selector) {
      if (val == '1') {
        selector.attr('checked', true);
      } else if (val == '2') {
        selector.attr('checked', true);
      } else {
        selector.attr('checked', false);
      }
    }

    $(document).ready(function() {
      // add onchange event to dropdown
      $(".select_all").change(function() {
        console.log(this.value)
        const selector = `#attend${$(this).data('id')}`;
        // check/uncheck checkboxes based on dropdown option
        check(this.value, $(selector));
        allSelected($(".select_all"));
      });

      $('#data_1 .input-group.date').datepicker({
        todayBtn: "linked",
        keyboardNavigation: false,
        forceParse: false,
        calendarWeeks: true,
        autoclose: true
      });
    });
  </script>
</body>

</html>