<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
// start output buffering early so we can safely send headers after includes
if (!ob_get_level()) ob_start();
include 'includes/conn.php';
include 'includes/roles.php'; // Include centralized role management
if (!isset($_SESSION['schoolsys'])) {
  header('Location:login.php');
  exit;
}
// POST handler moved here (before any output) to allow safe header redirects
$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['fullname'])) {
  $fullname = trim($_POST['fullname']);
  $gender = isset($_POST['gender']) ? $_POST['gender'] : '';
  $phone = trim($_POST['phone'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $designation = trim($_POST['designation'] ?? '');
  $username = trim($_POST['username'] ?? '');
  $password = trim($_POST['password'] ?? '');
  $repeat = trim($_POST['repeat'] ?? '');
  $role = isset($_POST['role']) ? (int)$_POST['role'] : 0;
  $category = isset($_POST['category']) ? (int)$_POST['category'] : 0;

    // file info
    $image_name = $_FILES['image']['name'] ?? '';
    $image_size = $_FILES['image']['size'] ?? 0;
    $image_temp = $_FILES['image']['tmp_name'] ?? '';
    $imgext = $image_name ? pathinfo($image_name, PATHINFO_EXTENSION) : '';
    $image_ext = strtolower($imgext);
    $allowed_ext = ['jpg','jpeg','png','gif',''];

    if (empty($fullname)) $errors[] = 'Full name is required.';
    if (empty($gender)) $errors[] = 'Gender Not Selected';
    if (empty($phone)) $errors[] = 'Phone is required.';
    if (!empty($email)) {
      $check_stmt = mysqli_prepare($con, "SELECT staff_id FROM staff WHERE email = ? AND status = 1 LIMIT 1");
      if ($check_stmt) {
        mysqli_stmt_bind_param($check_stmt,'s',$email);
        mysqli_stmt_execute($check_stmt);
        mysqli_stmt_store_result($check_stmt);
        if (mysqli_stmt_num_rows($check_stmt) > 0) $errors[] = 'Email Already Exists';
        mysqli_stmt_close($check_stmt);
      }
    }

  if (!empty($username)) {
    if ($role === 4 && $category <= 0) $errors[] = 'Select Category to Proceed';
    if (!isValidRole($role) || empty($password) || empty($repeat)) $errors[] = 'Some Fields are empty';
  }    if ($image_ext && !in_array($image_ext,$allowed_ext)) $errors[] = 'Image File type not allowed';
    if ($image_size > 2097152) $errors[] = 'Maximum Image size is 2Mb';

    if (!empty($password) && $password !== $repeat) $errors[] = 'Passwords do not match';

    if (empty($errors)) {
      include 'includes/thumbs.func.php';

    // insert staff with prepared stmt
    $stmt = mysqli_prepare($con, "INSERT INTO staff(fullname,phone,gender,email,ext,designation,status) VALUES(?,?,?,?,?,?,'1')");
    if ($stmt) {
      mysqli_stmt_bind_param($stmt,'ssssss',$fullname,$phone,$gender,$email,$image_ext,$designation);
      mysqli_stmt_execute($stmt);
      $last_id = mysqli_insert_id($con);
      mysqli_stmt_close($stmt);
    } else {
      include_once __DIR__ . '/includes/db_debug_logger.php';
      $q_full = mysqli_real_escape_string($con,$fullname);
      $q_phone = mysqli_real_escape_string($con,$phone);
      $q_gender = mysqli_real_escape_string($con,$gender);
      $q_email = mysqli_real_escape_string($con,$email);
      $q_ext = mysqli_real_escape_string($con,$image_ext);
      $q_design = mysqli_real_escape_string($con,$designation);
      $ins = mysqli_query($con,"INSERT INTO staff(fullname,phone,gender,email,ext,designation,status) VALUES('$q_full','$q_phone','$q_gender','$q_email','$q_ext','$q_design','1')");
      if ($ins === false) {
        log_db_error_global($con, 'staff: insert fallback');
      }
      $last_id = mysqli_insert_id($con);
    }

    if ($last_id && !empty($image_name) && is_uploaded_file($image_temp)) {
      $image_file = md5($last_id) . '.' . $image_ext;
      if (@move_uploaded_file($image_temp, 'images/nonteaching/' . $image_file)) {
        if (function_exists('create_thumb')) {
          @create_thumb('images/nonteaching/', $image_file, 'images/nonteaching/thumbs/');
        }
      }
    }

    if (!empty($username) && $last_id) {
      $ucheck = mysqli_prepare($con, "SELECT user_id FROM users WHERE username = ? LIMIT 1");
      if ($ucheck) {
        mysqli_stmt_bind_param($ucheck, 's', $username);
        mysqli_stmt_execute($ucheck);
        mysqli_stmt_store_result($ucheck);
        if (mysqli_stmt_num_rows($ucheck) > 0) {
          $errors[] = 'Username already exists. User account not created.';
          mysqli_stmt_close($ucheck);
          $create_user = false;
        } else {
          mysqli_stmt_close($ucheck);
          $create_user = true;
        }
      } else {
        $create_user = true;
      }

      if (!empty($create_user)) {
        $cat_id = ($role === 4) ? $category : 0;
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $u_stmt = mysqli_prepare($con, "INSERT INTO users(staff_id,username,password,cat_id,level,status) VALUES(?,?,?,?,?,1)");
        if ($u_stmt) {
          mysqli_stmt_bind_param($u_stmt,'issii',$last_id,$username,$hashed_password,$cat_id,$role);
          mysqli_stmt_execute($u_stmt);
          mysqli_stmt_close($u_stmt);
        } else {
          $u_user = mysqli_real_escape_string($con,$username);
          $u_pass = mysqli_real_escape_string($con,$hashed_password);
          $insu = mysqli_query($con,"INSERT INTO users(staff_id,username,password,cat_id,level,status) VALUES('".(int)$last_id."','$u_user','$u_pass','".(int)$cat_id."','".(int)$role."',1)");
          if ($insu === false) {
            include_once __DIR__ . '/includes/db_debug_logger.php';
            log_db_error_global($con, 'users: insert fallback');
          }
        }
      }
    }

    // redirect after successful create (no errors)
    if (empty($errors)) {
      header('Location: addstaff.php?added=1');
      exit;
    }
  }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Staff</title>
  <script src="js/jquery-1.10.2.min.js"></script>
  <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="js/jquery-migrate-1.2.1.min.js"></script>
  <script src="js/ckeditor/ckeditor.js"></script>
  <link rel="stylesheet" href="js/ckeditor/samples/sample.css">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/chosen/chosen.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php';
    //   echo str_replace('\', ' ',$organisation);
    ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-8">
          <section class="panel">
            <header class="panel-heading">
              Add New Staff
            </header>
            <div class="panel-body">
              <?php
              // Display errors if any from the POST processing at the top
              if (!empty($errors)) {
                foreach ($errors as $error) {
                  echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                }
              }
              ?>

              <?php if (isset($_GET['added']) && $_GET['added'] == '1'): ?>
                <div class="alert alert-success">Staff Member successfully Added</div>
              <?php endif; ?>
              <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
                <div class="form-group"><label class="control-label">* Full Name</label>
                  <input type="text" name='fullname' class="form-control" placeholder="Enter fullname" required="required">
                </div>

                <div class="form-group"><label class="control-label">* Gender</label>

                  <select name="gender" class="form-control">
                    <option value="">select gender...</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                  </select>
                </div>



                <div class="form-group"><label class="control-label">*Phone</label>

                  <input type="text" name="phone" class="form-control" placeholder="Enter  phone Number" required="required">

                </div>

                <div class="form-group"><label class=" control-label">*Designation</label>

                  <input type="text" name="designation" class="form-control " placeholder="Enter Designation e.g Admin" required="required">

                </div>

                <div class="form-group"><label class="control-label"> Profile picture</label>
                  <input type="file" name="image" class="form-control " style="padding: 0px">
                </div>

                <div class="form-group"><label class="control-label"> Email Address</label>
                  <input type="email" name="email" class="form-control " placeholder="Enter a valid email address">
                  <div id='form_email_errorloc' class='text-danger'></div>
                </div>
                <h4>Fill this part below if member should access the system</h4>
                <div class="form-group"><label class=" control-label">* Username</label>

                  <input type="text" name="username" class="form-control" placeholder="Enter your username">

                </div>

                <div class="form-group"><label class="control-label">* Select Role</label>
                  <select name="role" class="form-control" id="role">
                    <option value="" selected="selected">Assign Role... </option>
                    <?php echo generateRoleOptions(); ?>
                  </select>
                </div>

                <div class="cats" style="display: none">
                  <div class="form-group"><label class="control-label">* Select Section</label>
                    <select name="category" class="form-control" id="role">
                      <option value="" selected="selected">Select Section... </option>
                      <?php
                      $classes = mysqli_query($con, "SELECT * FROM classcategories WHERE status=1");
                      while ($row = mysqli_fetch_array($classes)) {
                        $classcategory_id = $row['classcategory_id'];
                        $classcategory = $row['classcategory'];
                      ?>
                        <option value="<?php echo $classcategory_id; ?>"><?php echo $classcategory; ?></option>
                      <?php } ?>
                    </select>

                  </div>
                </div>
                <div class="form-group"><label class="control-label">*Password</label>
                  <input type="password" name="password" class="form-control" placeholder="Enter  your password">
                  <div id='form_password_errorloc' class='text-danger'></div>
                </div>

                <div class="form-group"><label class="control-label"> *Repeat Password</label>

                  <input type="password" name="repeat" class="form-control" placeholder="Repeat your password">
                  <div id='form_repeat_errorloc' class='text-danger'></div>

                </div>
                <div class="form-group">
                  <button class="btn btn-primary" type="submit">Add Staff Member</button>
                </div>
              </form>
            </div>

        </div>
    </section>

    </div>

    </div>


    </div>
    <!-- page end-->
  </section>
  <!--body wrapper end-->

  <!--footer section start-->

  <!--footer section end-->


  </div>
  <!-- main content end-->
  </section>

  <script src="js/bootstrap.min.js"></script>
  <script src="js/modernizr.min.js"></script>
  <script src="js/jquery.nicescroll.js"></script>
  <script type="text/javascript" src="js/gen_validatorv4.js"></script>
  <script src="js/chosen/chosen.jquery.js"></script>

  <script src="js/scripts.js"></script>
  <script>
    var frmvalidator = new Validator("form");
    frmvalidator.EnableOnPageErrorDisplay();
    frmvalidator.EnableMsgsTogether();
    frmvalidator.addValidation("email", "email", "*Enter a valid  email address");
    //             frmvalidator.addValidation("password","minlength=6","*password  should atleast be 6 characters");
    frmvalidator.addValidation("repeat", "eqelmnt=password", "*The passwords dont match");
    $(document).ready(function() {
      var getval = $('#role').val();
      if (getval === '4') {
        $('.cats').show();
      }
      $('#role').on('change', function() {
        var getselect = $(this).val();
        if (getselect === '4') {
          $('.cats').show();
        } else {
          $('.cats').hide();
        }
      });
    });
  </script>
</body>

</html>
<?php
// flush output buffer if started
if (ob_get_level()) {
  @ob_end_flush();
}