<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
    header('Location:login.php');
    exit;
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ThemeBucket">
    <link rel="shortcut icon" href="#" type="image/png">

    <title>Add Section</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
    <section>
        <?php include 'includes/header.php'; ?>

        <section class="wrapper">
            <div class="row">
                <div class="col-lg-6">
                    <section class="panel">
                        <header class="panel-heading">
                            Add Section
                        </header>
                        <div class="panel-body">
                            <?php
                            if (isset($_POST['updatesubmit'])) {
                                $classcategory2 =  mysqli_real_escape_string($con, trim($_POST['classcategory2']));
                                $std =  mysqli_real_escape_string($con, trim($_POST['std']));
                                $check2 = mysqli_query($con, "SELECT * FROM classcategories WHERE classcategory_id='$std'");
                                if ((empty($classcategory2))) {
                                    $errors[] = 'Enter All Fields To Proceed';
                                }
                                if (mysqli_num_rows($check2) == 0) {
                                    $errors[] = 'section Name Already Exists';
                                }
                                if (!empty($errors)) {
                                    foreach ($errors as $error) {
                                        echo '<div class="alert alert-danger">' . $error . '</div>';
                                    }
                                } else {
                                    // Use prepared statement for update when possible
                                    $upd = mysqli_prepare($con, "UPDATE classcategories SET classcategory=? WHERE classcategory_id=?");
                                    if ($upd) {
                                        mysqli_stmt_bind_param($upd, 'si', $classcategory2, $std);
                                        mysqli_stmt_execute($upd);
                                        mysqli_stmt_close($upd);
                                    } else {
                                        mysqli_query($con, "UPDATE classcategories SET classcategory='" . mysqli_real_escape_string($con, $classcategory2) . "' WHERE classcategory_id='" . (int)$std . "'") or die(mysqli_error($con));
                                    }

                                    // Delete existing grade configurations
                                    $del = mysqli_prepare($con, "DELETE FROM grade_config WHERE classcategory_id=?");
                                    if ($del) {
                                        mysqli_stmt_bind_param($del, 'i', $std);
                                        mysqli_stmt_execute($del);
                                        mysqli_stmt_close($del);
                                    } else {
                                        mysqli_query($con, "DELETE FROM grade_config WHERE classcategory_id='" . (int)$std . "'") or die(mysqli_error($con));
                                    }

                                    // Process new grade data (use prepared insert)
                                    if (isset($_POST['grade_letter']) && is_array($_POST['grade_letter'])) {
                                        $ins_gc = mysqli_prepare($con, "INSERT INTO grade_config(classcategory_id, grade_letter, grade_modifier, mark_range, created_at) VALUES(?,?,?,?,NOW())");
                                        foreach ($_POST['grade_letter'] as $key => $grade_letter) {
                                            if (!empty($grade_letter) && isset($_POST['grade_modifier'][$key]) && isset($_POST['mark_range'][$key])) {
                                                $grade_modifier = trim($_POST['grade_modifier'][$key]);
                                                $mark_range = trim($_POST['mark_range'][$key]);
                                                if ($ins_gc) {
                                                    mysqli_stmt_bind_param($ins_gc, 'isss', $std, $grade_letter, $grade_modifier, $mark_range);
                                                    mysqli_stmt_execute($ins_gc);
                                                } else {
                                                    mysqli_query($con, "INSERT INTO grade_config(classcategory_id, grade_letter, grade_modifier, mark_range, created_at) VALUES('" . (int)$std . "','" . mysqli_real_escape_string($con, $grade_letter) . "','" . mysqli_real_escape_string($con, $grade_modifier) . "','" . mysqli_real_escape_string($con, $mark_range) . "',NOW())") or die(mysqli_error($con));
                                                }
                                            }
                                        }
                                        if ($ins_gc) mysqli_stmt_close($ins_gc);
                                    }

                                    echo '<div class="alert alert-success"><i class="fa fa-check"></i>Section successfully Updated</div>';
                                }
                            }
                            ?>
                            <?php
                            if (isset($_POST['classcategory'])) {
                                $classcategory =  mysqli_real_escape_string($con, trim($_POST['classcategory']));
                                $check2 = mysqli_query($con, "SELECT * FROM classcategories WHERE classcategory='$classcategory'");
                                if ((empty($classcategory))) {
                                    $errors[] = 'Enter All Fields To Proceed';
                                }
                                if (mysqli_num_rows($check2) > 0) {
                                    $errors[] = 'section Name Already Exists';
                                }
                                if (!empty($errors)) {
                                    foreach ($errors as $error) {
                                        echo '<div class="alert alert-danger">' . $error . '</div>';
                                    }
                                } else {
                                    mysqli_query($con, "INSERT INTO classcategories(classcategory,creator,status) VALUES('$classcategory','" . $_SESSION['schoolsys'] . "','1')") or die(mysqli_error($con));

                                    // Get the newly inserted classcategory_id
                                    $classcategory_id = mysqli_insert_id($con);

                                    // Process grade data
                                    if (isset($_POST['grade_letter']) && is_array($_POST['grade_letter'])) {
                                        foreach ($_POST['grade_letter'] as $key => $grade_letter) {
                                            $grade_modifier = mysqli_real_escape_string($con, $_POST['grade_modifier'][$key]);
                                            $mark_range = mysqli_real_escape_string($con, $_POST['mark_range'][$key]);

                                            mysqli_query($con, "INSERT INTO grade_config(classcategory_id, grade_letter, grade_modifier, mark_range) 
                                                              VALUES('$classcategory_id', '$grade_letter', '$grade_modifier', '$mark_range')")
                                                or die(mysqli_error($con));
                                        }
                                    }

                                    echo '<div class="alert alert-success"><i class="fa fa-check"></i>Class successfully added</div>';
                                }
                            }

                            ?>
                            <form method="post" class="form" action='' name="form" enctype="multipart/form-data">
                                <div class="form-group"><label class="control-label">Section Name</label>
                                    <input type="text" class="form-control" name='classcategory' placeholder="Enter Class Section" required='required'>
                                </div>

                                <div class="form-group">
                                    <label class="control-label">Grade Management</label>
                                    <div class="grade-sec">
                                        <div class="row">

                                            <div class="form-group col-lg-3">
                                                <label>Grade Letter</label>
                                                <select name="grade_letter[]" class="form-control" required>
                                                    <option value="">Select</option>
                                                    <option value="A">A</option>
                                                    <option value="B">B</option>
                                                    <option value="C">C</option>
                                                    <option value="D">D</option>
                                                    <option value="E">E</option>
                                                    <option value="F">F</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <label>Modifier</label>
                                                <select name="grade_modifier[]" class="form-control" required>
                                                    <option value="">Select</option>
                                                    <option value="+">+</option>
                                                    <option value="-">-</option>
                                                    <option value="*">*</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <label>Mark Range</label>
                                                <input type="text" name="mark_range[]" class="form-control" placeholder="e.g. 90 - 100" required>

                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-success btn-sm add_grade" style="margin-top:10px">
                                        <i class="fa fa-plus"></i> Add Another Grade
                                    </button>
                                </div>

                                <div class="form-group">
                                    <button class="btn btn-primary" name="submit" type="submit">Add</button>
                                </div>
                            </form>
                        </div>
                    </section>
                </div>
                <div class="col-lg-6">
                    <section class="panel">
                        <header class="panel-heading">
                            Sections
                        </header>
                        <div class="panel-body">
                            <table class="display table  table-striped">
                                <thead>
                                    <tr>
                                        <th>Category</th>
                                        <!-- <th>Streams</th> -->
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $getclasses = mysqli_query($con, "SELECT * FROM classcategories WHERE status=1 ");
                                    while ($row = mysqli_fetch_array($getclasses)) {
                                        $class_id = $row['classcategory_id'];
                                        $class = $row['classcategory'];
                                    ?>
                                        <tr class="gradeA">
                                            <td><?php echo $class; ?></td>

                                            <td>
                                                <?php
                                                if (($_SESSION['schoolsyslevel'] == 1)) {
                                                ?>
                                                    <a data-toggle="modal" href="#modal-form<?php echo $class_id; ?>" class="btn btn-xs btn-success"><i class="fa fa-edit"></i> Edit </a>
                                                    <!-- <a href="streams?id=<?php echo $class_id; ?>" class="btn btn-xs btn-primary"><i class="fa fa-building-o"></i> Streams</a> -->
                                                    <a href="hideclasscategory?id=<?php echo $class_id; ?>" class="btn btn-xs btn-danger" onclick="return confirm_delete<?php echo $class_id; ?>()"><i class="fa fa-trash-o"></i>Remove</a>
                                                <?php } ?>
                                                <!-- <a href="class?id=<?php echo $class_id; ?>" class="btn btn-xs btn-info"><i class="fa fa-group"></i> Students</a>                                     -->
                                            </td>
                                            <script type="text/javascript">
                                                function confirm_delete<?php echo $class_id; ?>() {
                                                    return confirm('You are about To Remove this Item.Are you sure you want to proceed?');
                                                }
                                            </script>
                                        </tr>
                                        <div id="modal-form<?php echo $class_id; ?>" class="modal fade" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                                                        <h3 class="m-t-none m-b">Edit <?php echo $class; ?></h3>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row">
                                                            <div class="col-sm-12">
                                                                <form role="form" method="POST" action="" enctype="multipart/form-data" id="editForm">
                                                                    <input type="hidden" value="<?php echo $class_id; ?>" name="std">
                                                                    <div class="form-group">
                                                                        <label for="username" class="control-label">Section Name</label>
                                                                        <input type="text" class="form-control" name='classcategory2'
                                                                            value="<?php echo $class; ?>"
                                                                            placeholder="Enter Class Section" required='required'>
                                                                    </div>

                                                                    <div class="form-group">
                                                                        <label class="control-label">Grade Management</label>
                                                                        <div class="grade-sec-edit">
                                                                            <?php
                                                                            // Fetch existing grade configurations
                                                                            $grade_query = mysqli_query($con, "SELECT * FROM grade_config WHERE classcategory_id='$class_id'");
                                                                            if (mysqli_num_rows($grade_query) > 0) {
                                                                                while ($grade_row = mysqli_fetch_array($grade_query)) {
                                                                            ?>
                                                                                    <div class="row">
                                                                                        <div class="form-group col-lg-3">
                                                                                            <label>Grade Letter</label>
                                                                                            <select name="grade_letter[]" class="form-control" required>
                                                                                                <option value="">Select</option>
                                                                                                <option value="A" <?php echo ($grade_row['grade_letter'] == 'A') ? 'selected' : ''; ?>>A</option>
                                                                                                <option value="B" <?php echo ($grade_row['grade_letter'] == 'B') ? 'selected' : ''; ?>>B</option>
                                                                                                <option value="C" <?php echo ($grade_row['grade_letter'] == 'C') ? 'selected' : ''; ?>>C</option>
                                                                                                <option value="D" <?php echo ($grade_row['grade_letter'] == 'D') ? 'selected' : ''; ?>>D</option>
                                                                                                <option value="E" <?php echo ($grade_row['grade_letter'] == 'E') ? 'selected' : ''; ?>>E</option>
                                                                                                <option value="F" <?php echo ($grade_row['grade_letter'] == 'F') ? 'selected' : ''; ?>>F</option>
                                                                                            </select>
                                                                                        </div>
                                                                                        <div class="form-group col-lg-3">
                                                                                            <label>Modifier</label>
                                                                                            <select name="grade_modifier[]" class="form-control">
                                                                                                <option value="">Select</option>
                                                                                                <option value="+" <?php echo ($grade_row['grade_modifier'] == '+') ? 'selected' : ''; ?>>+</option>
                                                                                                <option value="-" <?php echo ($grade_row['grade_modifier'] == '-') ? 'selected' : ''; ?>>-</option>
                                                                                                <option value="*" <?php echo ($grade_row['grade_modifier'] == '*') ? 'selected' : ''; ?>>*</option>
                                                                                            </select>
                                                                                        </div>
                                                                                        <div class="form-group col-lg-3">
                                                                                            <label>Mark Range</label>
                                                                                            <input type="text" name="mark_range[]" class="form-control" placeholder="e.g. 90 - 100" value="<?php echo $grade_row['mark_range']; ?>" required>

                                                                                        </div>
                                                                                        <div class="form-group col-lg-3">
                                                                                            <label>&nbsp;</label>
                                                                                            <button class="btn btn-danger btn-sm remove_grade" style="width:100%">
                                                                                                <i class="fa fa-minus"></i> Remove
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                <?php
                                                                                }
                                                                            } else {
                                                                                ?>
                                                                                <div class="row">
                                                                                    <div class="form-group col-lg-3">
                                                                                        <label>Grade Letter</label>
                                                                                        <select name="grade_letter[]" class="form-control">
                                                                                            <option value="">Select</option>
                                                                                            <option value="A">A</option>
                                                                                            <option value="B">B</option>
                                                                                            <option value="C">C</option>
                                                                                            <option value="D">D</option>
                                                                                            <option value="E">E</option>
                                                                                            <option value="F">F</option>
                                                                                        </select>
                                                                                    </div>
                                                                                    <div class="form-group col-lg-3">
                                                                                        <label>Modifier</label>
                                                                                        <select name="grade_modifier[]" class="form-control">
                                                                                            <option value="">Select</option>
                                                                                            <option value="+">+</option>
                                                                                            <option value="-">-</option>
                                                                                            <option value="*">*</option>
                                                                                        </select>
                                                                                    </div>
                                                                                    <div class="form-group col-lg-3">
                                                                                        <label>Mark Range</label>
                                                                                        <input type="text" name="mark_range[]" class="form-control" placeholder="e.g. 90 - 100" required>

                                                                                    </div>
                                                                                </div>
                                                                            <?php } ?>
                                                                        </div>
                                                                        <button type="button" class="btn btn-success btn-sm add_grade_edit" style="margin-top:10px">
                                                                            <i class="fa fa-plus"></i> Add Another Grade
                                                                        </button>
                                                                    </div>

                                                                    <button class="btn btn-sm btn-primary pull-right m-t-n-xs" type="submit" name="updatesubmit"><strong>Update</strong></button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </tbody>


                            </table>
                        </div>
                    </section>
                </div>

            </div>


            </div>
            <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->

        <!--footer section end-->


        </div>
        <!-- main content end-->
    </section>

    <!-- Placed js at the end of the document so the pages load faster -->
    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/modernizr.min.js"></script>
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
    <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
    <script src="js/dynamic_table_init.js"></script>
    <!--common scripts for all pages-->
    <script src="js/scripts.js"></script>

    <script>
        $(document).ready(function() {
            // Original add grade functionality
            $('.add_grade').click(function(e) {
                e.preventDefault();
                $('.grade-sec').append(`
                    <div class="row">
                        <div class="form-group col-lg-3">
                            <label>Grade Letter</label>
                            <select name="grade_letter[]" class="form-control" required>
                                <option value="">Select</option>
                                <option value="A">A</option>
                                <option value="B">B</option>
                                <option value="C">C</option>
                                <option value="D">D</option>
                                <option value="E">E</option>
                                <option value="F">F</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label>Modifier</label>
                            <select name="grade_modifier[]" class="form-control">
                                <option value="">Select</option>
                                <option value="+">+</option>
                                <option value="-">-</option>
                                <option value="*">*</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label>Mark Range</label>
                            <input type="text" name="mark_range[]" class="form-control" placeholder="e.g. 90 - 100" required>
                        </div>
                        <div class="form-group col-lg-3">
                            <label>&nbsp;</label>
                            <button class="btn btn-danger btn-sm remove_grade" style="width:100%">
                                <i class="fa fa-minus"></i> Remove
                            </button>
                        </div>
                    </div>
                `);
            });

            // Edit modal add grade functionality
            $('.add_grade_edit').click(function(e) {
                e.preventDefault();
                $('.grade-sec-edit').append(`
                    <div class="row">
                        <div class="form-group col-lg-3">
                            <label>Grade Letter</label>
                            <select name="grade_letter[]" class="form-control" required>
                                <option value="">Select</option>
                                <option value="A">A</option>
                                <option value="B">B</option>
                                <option value="C">C</option>
                                <option value="D">D</option>
                                <option value="E">E</option>
                                <option value="F">F</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label>Modifier</label>
                            <select name="grade_modifier[]" class="form-control">
                                <option value="">Select</option>
                                <option value="+">+</option>
                                <option value="-">-</option>
                                <option value="*">*</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label>Mark Range</label>
                            <input type="text" name="mark_range[]" class="form-control" placeholder="e.g. 90 - 100" required>
                        </div>
                        <div class="form-group col-lg-3">
                            <label>&nbsp;</label>
                            <button class="btn btn-danger btn-sm remove_grade" style="width:100%">
                                <i class="fa fa-minus"></i> Remove
                            </button>
                        </div>
                    </div>
                `);
            });

            // Remove grade functionality for both forms
            $(document).on("click", ".remove_grade", function(e) {
                e.preventDefault();
                $(this).closest('.row').remove();
            });

            // Fix for edit modal form submission
            $('#editForm').on('submit', function(e) {
                // Ensure all dynamic inputs are included in the form submission
                var formData = new FormData(this);

                // Add any hidden inputs for dynamic fields if needed
                $('.grade-sec-edit input, .grade-sec-edit select').each(function() {
                    if (!formData.has($(this).attr('name'))) {
                        formData.append($(this).attr('name'), $(this).val());
                    }
                });

                // You can add AJAX submission here if needed
                // $.ajax({
                //     url: $(this).attr('action'),
                //     type: 'POST',
                //     data: formData,
                //     processData: false,
                //     contentType: false,
                //     success: function(response) {
                //         // Handle success
                //     }
                // });

                // Or let the form submit normally
                return true;
            });
        });
    </script>
</body>

</html>