<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Allow Super Admin (1), Principal (2), Accounts Management (3), Finance Manager (8), Accountant (10)
if ((!isset($_SESSION['schoolsys'])) || !in_array((int)($_SESSION['schoolsyslevel'] ?? 0), [1,2,3,8,10], true)) {
  header('Location:login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add School Fee</title>  
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/ckeditor/ckeditor.js"></script>
 <link rel="stylesheet" href="js/ckeditor/samples/sample.css">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
  <link href="css/jquery.filer.css" rel="stylesheet">
  <link href="css/chosen/chosen.css" rel="stylesheet">
 
</head>

<body class="sticky-header">
<section>
   <?php
   include 'includes/header.php'; 
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
            <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                   Add School Fees
                    </header>
                    <div class="panel-body">
          <?php
          if (isset($_POST['amount'], $_POST['class'], $_POST['year'])) {
            $errors = [];
            $amount_raw = trim($_POST['amount']);
            $amount = (float) str_replace([',', ' '], ['', ''], $amount_raw);
            $class = (int) $_POST['class'];
            $year = (int) $_POST['year'];

            if ($amount <= 0) {
              $errors[] = 'Enter a valid amount.';
            }
            if ($class <= 0) {
              $errors[] = 'Select a valid class.';
            }
            if ($year <= 1900) {
              $errors[] = 'Select a valid year.';
            }

            // Discover actual column name for year in `schoolfees` table to avoid column-name mismatches
            $year_col = 'year';
            $cols_res = mysqli_query($con, "SHOW COLUMNS FROM schoolfees");
            if ($cols_res) {
                $available = [];
                while ($c = mysqli_fetch_assoc($cols_res)) { $available[] = $c['Field']; }
                // prefer common names
                $candidates = ['year','term_year','academic_year','fee_year','financial_year','year_id'];
                $found = null;
                foreach ($candidates as $cand) { if (in_array($cand, $available, true)) { $found = $cand; break; } }
                if ($found) { $year_col = $found; }
                // if none of the candidates exists but there is a single int/date-like field other than ids, try to guess
                if (!$found) {
                    foreach ($available as $f) {
                        if (preg_match('/year|term|academic|financial|fee/i', $f)) { $year_col = $f; break; }
                    }
                }
            }

            // check existing - use discovered year column name
            // table uses `schoolfees_id` as primary key, not `id`
            $check_sql = "SELECT schoolfees_id FROM schoolfees WHERE `" . mysqli_real_escape_string($con, $year_col) . "` = ? AND class_id = ?";
            $check_stmt = mysqli_prepare($con, $check_sql);
            if ($check_stmt) {
              mysqli_stmt_bind_param($check_stmt, 'ii', $year, $class);
              mysqli_stmt_execute($check_stmt);
              mysqli_stmt_store_result($check_stmt);
              if (mysqli_stmt_num_rows($check_stmt) > 0) {
                $errors[] = 'Oops!! the school fees for this year and class are already set';
              }
              mysqli_stmt_close($check_stmt);
            } else {
              $check_fallback_sql = "SELECT schoolfees_id FROM schoolfees WHERE `" . mysqli_real_escape_string($con, $year_col) . "`='$year' AND class_id='$class'";
              $check = mysqli_query($con, $check_fallback_sql) or die(mysqli_error($con));
              if (mysqli_num_rows($check) > 0) {
                $errors[] = 'Oops!! the school fees for this year and class are already set';
              }
            }

            if (!empty($errors)) {
              foreach ($errors as $error) {
                echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
              }
            } else {
              $status = 1;
              // Prepare insert using the resolved year column name
              // Detect if term_id (or other required non-null columns) exists and prepare values
              $needs_term = false;
              $term_id_val = 0;
              $cols_res2 = mysqli_query($con, "SHOW COLUMNS FROM schoolfees");
              if ($cols_res2) {
                  while ($c = mysqli_fetch_assoc($cols_res2)) {
                      if ($c['Field'] === 'term_id' && strtoupper($c['Null']) === 'NO') {
                          $needs_term = true;
                          break;
                      }
                  }
              }
              if ($needs_term) {
                  // Try to get current financial term
                  $term_q = mysqli_query($con, "SELECT financialterm_id FROM financialterms WHERE status=1 ORDER BY financialterm_id DESC LIMIT 1");
                  if ($term_q && mysqli_num_rows($term_q) > 0) {
                      $tr = mysqli_fetch_assoc($term_q);
                      $term_id_val = (int)($tr['financialterm_id'] ?? 0);
                  } else {
                      $term_id_val = 0; // fallback
                  }
              }

              $insCols = ['amount', mysqli_real_escape_string($con, $year_col), 'class_id', 'status'];
              $insValues = [$amount, $year, $class, $status];
              if ($needs_term) { $insCols[] = 'term_id'; $insValues[] = $term_id_val; }

              $cols_sql = implode(',', array_map(function($c){ return "`".$c."`"; }, $insCols));
              $placeholders = implode(',', array_fill(0, count($insCols), '?'));
              $insert_sql = "INSERT INTO schoolfees(".$cols_sql.") VALUES(".$placeholders.")";
              $insert_stmt = mysqli_prepare($con, $insert_sql);
               if ($insert_stmt) {
                 // build types string dynamically
                 $types = '';
                 foreach ($insValues as $val) {
                     if (is_int($val)) $types .= 'i';
                     elseif (is_float($val) || is_double($val)) $types .= 'd';
                     else $types .= 's';
                 }
                 // bind params dynamically - build parameter array with references
                 $bind_params = [];
                 $bind_params[] = $insert_stmt;
                 $bind_params[] = $types;
                 // add references to values
                 for ($i = 0; $i < count($insValues); $i++) {
                   $bind_params[] = & $insValues[$i];
                 }
                 // call bind_param with dynamic args
                 call_user_func_array('mysqli_stmt_bind_param', $bind_params);
                 if (mysqli_stmt_execute($insert_stmt)) {
                   echo '<div class="alert alert-success">School Fees successfully Added</div>';
                 } else {
                   include_once __DIR__ . '/includes/db_debug_logger.php';
                   log_db_error_global($con, 'schoolfees: insert execute');
                   echo '<div class="alert alert-danger">Could not add school fees. Try again later.</div>';
                 }
                 mysqli_stmt_close($insert_stmt);
               } else {
                // Fallback raw query
                $cols_esc = implode(',', array_map(function($c){ return "`".$c."`"; }, $insCols));
                $vals_esc = array_map(function($v) use ($con) { return mysqli_real_escape_string($con, (string)$v); }, $insValues);
                $q = "INSERT INTO schoolfees(".$cols_esc.") VALUES('" . implode("','", $vals_esc) . "')";
                if (mysqli_query($con, $q)) {
                  echo '<div class="alert alert-success">School Fees successfully Added</div>';
                } else {
                  include_once __DIR__ . '/includes/db_debug_logger.php';
                  log_db_error_global($con, 'schoolfees: insert fallback');
                  echo '<div class="alert alert-danger">Could not add school fees. Try again later.</div>';
                }
              }
            }
          }
          ?>                        
     <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">
            <div class="form-group"><label class="control-label">* Amount (Should be Numeric)</label>

                                  <input type="text" name='amount' class="form-control" placeholder="Enter Amount" required="required">
                                                                         
                                </div>
                                                                  <div class="form-group"><label class="control-label">* Class</label>
                                                                                              <select name="class" class="form-control">
                                                                                                  <option value="">select class...</option>
                                                                                                 <?php
                                                                     // Ensure we have a sane $timenow for year dropdown below
                                                                     if (!isset($timenow) || !is_int($timenow)) { $timenow = time(); }

                                                                     // Use a simple query to reliably fetch classes. If none, show a helpful message.
                                                                     $classes_q = mysqli_query($con, "SELECT class_id, class FROM classes WHERE status=1 ORDER BY class ASC");
                                                                     if ($classes_q && mysqli_num_rows($classes_q) > 0) {
                                                                         while ($crow = mysqli_fetch_assoc($classes_q)) {
                                                                             $class_id = (int) ($crow['class_id'] ?? 0);
                                                                             $class_name = $crow['class'] ?? '';
                                                                             echo '<option value="' . $class_id . '">' . htmlspecialchars($class_name, ENT_QUOTES) . '</option>';
                                                                         }
                                                                     } else {
                                                                         echo '<option value="">No classes found - create classes first</option>';
                                                                     }
                                                                  ?>
                                                                                                                                       </select>
                                                                                                                                                          </div>                                          
                                                                            <div class="form-group"><label class="control-label">* Year</label>
                                                            <select name="year" class="form-control">
                                            <option value="">select  year...</option>
                                        <option value="<?php echo date('Y',$timenow); ?>"><?php echo date('Y',$timenow); ?></option>
                                                            <?php
                                                            $datenow=date('Y',$timenow); 
                                                                 for ($x = 0; $x <= 15; $x++) {
                                                                     $datenow=$datenow-1;
                                                      echo '<option value="'.$datenow.'">'.$datenow.'</option>';
                                                                        }
                                                                                  ?> 
                                        </select>
                                                                     
                                </div> 
                                <div class="form-group">
                              <button class="btn btn-primary" type="submit">Add School Fees</button>
                                                                  </div>
                            </form>
                            </div>

                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
      
    </div>
    <!-- main content end-->
</section>

<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="js/gen_validatorv4.js"></script>
<script src="js/chosen/chosen.jquery.js"></script>
<script src="js/scripts.js"></script>
<script src="js/jquery.filer.min.js"></script>
<script>
      $(document).ready(function() {             
                     $('#filer_input').filer({
		showThumbs: true,
		addMore: true
    });
    });
               var config = {
                '.chosen-select'           : {},
                '.chosen-select-deselect'  : {allow_single_deselect:true},
                '.chosen-select-no-single' : {disable_search_threshold:10},
                '.chosen-select-no-results': {no_results_text:'Oops, nothing found!'},
                '.chosen-select-width'     : {width:"95%"}
            }
            for (var selector in config) {
                $(selector).chosen(config[selector]);
            }
</script>
</body>
</html>
