<?php
include 'includes/conn.php';
// Session is already started in conn.php

// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

// Allow Super Admin (1), Principal (2), Finance/Admin (3), Finance Manager (8), HR Admin Director (9), Accountant (10)
if ($user_level === 0 || !in_array($user_level, [1,2,3,8,9,10], true)) {
  header('Location:login.php');
  exit;
}

$ty = isset($_GET['ty']) ? (int) $_GET['ty'] : 0;
$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($ty <= 0 || $id <= 0) {
  // Redirect to the staff/guards selector instead of `staff.php`.
  // `staff.php` only allows Super Admin/Principal and would redirect other roles to login.
  header('Location:select_staff_for_salary.php');
  exit;
}
     if ($ty == 1) {
      // Detect whether staff table has a role_id column
      $staff_has_role_id = false;
      $rcol = @mysqli_query($con, "SHOW COLUMNS FROM `staff` LIKE 'role_id'");
      if ($rcol && mysqli_num_rows($rcol) > 0) {
        $staff_has_role_id = true;
      }

      if ($staff_has_role_id) {
        $stmt = mysqli_prepare($con, "SELECT fullname,gender,ext,email,phone,salary,role_id FROM staff WHERE staff_id = ? LIMIT 1");
        if ($stmt) {
          mysqli_stmt_bind_param($stmt, 'i', $id);
          mysqli_stmt_execute($stmt);
          $res = mysqli_stmt_get_result($stmt);
          $row1 = mysqli_fetch_assoc($res);
          mysqli_stmt_close($stmt);
        } else {
          $getstaff = mysqli_query($con, "SELECT fullname,gender,ext,email,phone,salary,role_id FROM staff WHERE staff_id='$id'");
          $row1 = mysqli_fetch_array($getstaff);
        }
        $fullname = isset($row1['fullname']) ? $row1['fullname'] : '';
        $gender = isset($row1['gender']) ? $row1['gender'] : '';
        $ext = isset($row1['ext']) ? $row1['ext'] : '';
        $email = isset($row1['email']) ? $row1['email'] : '';
        $phone = isset($row1['phone']) ? $row1['phone'] : '';
        $salary = isset($row1['salary']) ? $row1['salary'] : 0;
        $role_id = isset($row1['role_id']) ? $row1['role_id'] : 0;
        $staffrole = '';
        if ($role_id > 0) {
          $stmt = mysqli_prepare($con, "SELECT role FROM staffroles WHERE staffrole_id = ? LIMIT 1");
          if ($stmt) {
            mysqli_stmt_bind_param($stmt, 'i', $role_id);
            mysqli_stmt_execute($stmt);
            $res = mysqli_stmt_get_result($stmt);
            $row2 = mysqli_fetch_assoc($res);
            mysqli_stmt_close($stmt);
            if ($row2) $staffrole = $row2['role'];
          }
        }
      } else {
        // Fallback: staff table doesn't have role_id; use designation as role text
        $stmt = mysqli_prepare($con, "SELECT fullname,gender,ext,email,phone,salary,designation FROM staff WHERE staff_id = ? LIMIT 1");
        if ($stmt) {
          mysqli_stmt_bind_param($stmt, 'i', $id);
          mysqli_stmt_execute($stmt);
          $res = mysqli_stmt_get_result($stmt);
          $row1 = mysqli_fetch_assoc($res);
          mysqli_stmt_close($stmt);
        } else {
          $getstaff = mysqli_query($con, "SELECT fullname,gender,ext,email,phone,salary,designation FROM staff WHERE staff_id='$id'");
          $row1 = mysqli_fetch_array($getstaff);
        }
        $fullname = isset($row1['fullname']) ? $row1['fullname'] : '';
        $gender = isset($row1['gender']) ? $row1['gender'] : '';
        $ext = isset($row1['ext']) ? $row1['ext'] : '';
        $email = isset($row1['email']) ? $row1['email'] : '';
        $phone = isset($row1['phone']) ? $row1['phone'] : '';
        $salary = isset($row1['salary']) ? $row1['salary'] : 0;
        $role_id = 0;
        $staffrole = isset($row1['designation']) ? $row1['designation'] : '';
      }
    } else {
      $stmt = mysqli_prepare($con, "SELECT fullname,ext,salary FROM guards WHERE guard_id = ? LIMIT 1");
      if ($stmt) {
        mysqli_stmt_bind_param($stmt, 'i', $id);
        mysqli_stmt_execute($stmt);
        $res = mysqli_stmt_get_result($stmt);
        $row3 = mysqli_fetch_assoc($res);
        mysqli_stmt_close($stmt);
      } else {
        $getguard = mysqli_query($con, "SELECT fullname,ext,salary FROM guards WHERE guard_id='$id' ");
        $row3 = mysqli_fetch_array($getguard);
      }
      $fullname = isset($row3['fullname']) ? $row3['fullname'] : '';
      $ext = isset($row3['ext']) ? $row3['ext'] : '';
      $salary = isset($row3['salary']) ? $row3['salary'] : 0;
    }
                
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Add Salary for <?php echo $fullname; ?></title>
   <link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/bootstrap-fullcalendar.css" rel="stylesheet" />
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/prettyphoto/css/prettyPhoto.css" type="text/css" media="screen" title="prettyPhoto main stylesheet" charset="utf-8" />
<script src='<?php echo BASE_URL; ?>/js/fullcalendar/moment.min.js'></script>
      <script src='<?php echo BASE_URL; ?>/js/fullcalendar/jquery-ui.custom.min.js'></script>
    <script src='<?php echo BASE_URL; ?>/js/fullcalendar/fullcalendar.min.js'></script>
  <link href="css/chosen/chosen.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; 
//   echo str_replace('\', ' ',$organisation);
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
               <div class="col-lg-3">
                      <section class="panel">
                  
                          <div class="panel-body">
                       
                              <?php
                     if(!empty($ext)){
                         if($ty==1){
                     ?>
                        <img src="images/staff/thumbs/<?php echo md5($id).'.'.$ext.'?'.time(); ?>" class="img img-responsive">
                         <?php }else{ ?>
                        <img src="<?php echo BASE_URL;?>/images/guardphotos/profile/<?php echo md5($id).'.'.$ext.'?'.time(); ?>" class="img img-responsive">                                                    
                     <?php  }}else{?>
                        <img src="images/avatar.png" class="img img-responsive">
                     <?php }
                     ?>
                          </div>
                          </section>
                   <strong>Basic  : <?php echo number_format($salary); ?></strong>
                                     </div>
            <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                   Add Salary Payment for  <?php echo $fullname; ?>
                    </header>
                    <div class="panel-body">
              <?php
                                                      if (isset($_POST['month'], $_POST['year'], $_POST['payee'], $_POST['date'])) {
                                                        $errors = [];
                                                        $month = trim($_POST['month']);
                                                        $deductions = trim($_POST['deductions'] ?? '0');
                                                        $allowance = trim($_POST['allowance'] ?? '0');
                                                        $payee = trim($_POST['payee']);
                                                        $loan = trim($_POST['loan'] ?? '0');
                                                        $welfare = trim($_POST['welfare'] ?? '0');
                                                        $nssf = trim($_POST['nssf'] ?? '0');
                                                        $lapf = trim($_POST['lapf'] ?? '0');
                                                        $date_raw = trim($_POST['date']);
                                                        $year = (int) trim($_POST['year']);

                                                        if (empty($month) || empty($year) || empty($date_raw) || $payee === '' || $nssf === '') {
                                                          $errors[] = 'Fields with * Should not be left blank';
                                                        }

                                                        // numeric validations
                                                        $numericFields = ['payee' => $payee, 'allowance' => $allowance, 'lapf' => $lapf, 'loan' => $loan, 'nssf' => $nssf, 'welfare' => $welfare, 'deductions' => $deductions];
                                                        foreach ($numericFields as $label => $val) {
                                                          if ($val !== '' && !is_numeric($val)) $errors[] = ucfirst($label) . ' should be numeric';
                                                        }

                                                        // Check that the `salary` table exists before running duplicate checks
                                                        $salary_table_exists = false;
                                                        $tblCheck = @mysqli_query($con, "SHOW TABLES LIKE 'salary'");
                                                        if ($tblCheck && mysqli_num_rows($tblCheck) > 0) {
                                                          $salary_table_exists = true;
                                                        }

                                                        if ($salary_table_exists) {
                                                          // duplicate check (prepared)
                                                          $dup_stmt = mysqli_prepare($con, "SELECT 1 FROM salary WHERE year = ? AND month = ? AND employee_id = ? AND type = ? LIMIT 1");
                                                          if ($dup_stmt) {
                                                            mysqli_stmt_bind_param($dup_stmt, 'isii', $year, $month, $id, $ty);
                                                            mysqli_stmt_execute($dup_stmt);
                                                            mysqli_stmt_store_result($dup_stmt);
                                                            if (mysqli_stmt_num_rows($dup_stmt) > 0) $errors[] = 'Salary for Employee Already Added';
                                                            mysqli_stmt_close($dup_stmt);
                                                          } else {
                                                            $check = mysqli_query($con, "SELECT 1 FROM salary WHERE year='".(int)$year."' AND month='".mysqli_real_escape_string($con,$month)."' AND employee_id='".(int)$id."' AND type='".(int)$ty."'");
                                                            if ($check && mysqli_num_rows($check) > 0) $errors[] = 'Salary for Employee Already Added';
                                                          }
                                                        } else {
                                                          $errors[] = 'Payroll is not configured: missing `salary` table. Please create the `salary` table before adding salary payments.';
                                                        }

                                                        if (!empty($errors)) {
                                                          foreach ($errors as $error) {
                                                            echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                                                          }
                                                        } else {
                                                          $allowance_f = (float)$allowance;
                                                          $deductions_f = (float)$deductions;
                                                          $loan_f = (float)$loan;
                                                          $nssf_f = (float)$nssf;
                                                          $lapf_f = (float)$lapf;
                                                          $welfare_f = (float)$welfare;
                                                          $payee_i = (int)$payee;

                                                          $gross = $salary + $allowance_f;
                                                          $computed_nssf = ($gross * 10) / 100;
                                                          $date_ts = strtotime(str_replace('-', '/', $date_raw));
                                                          if ($date_ts === false || $date_ts <= 0) {
                                                            $date_sql = date('Y-m-d');
                                                          } else {
                                                            $date_sql = date('Y-m-d', $date_ts);
                                                          }

                                                          $ins = mysqli_prepare($con, "INSERT INTO salary(employee_id,type,year,month,date,salary,nssf,lapf,payee,loan,welfare,bonus,deduction) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                                          if ($ins) {
                                                            // types: employee_id(i), type(i), year(i), month(s), date(s), salary(d), nssf(d), lapf(d), payee(i), loan(d), welfare(d), bonus(d), deduction(d)
                                                            mysqli_stmt_bind_param($ins, 'iiissdddidddd', $id, $ty, $year, $month, $date_sql, $salary, $nssf_f, $lapf_f, $payee_i, $loan_f, $welfare_f, $allowance_f, $deductions_f);
                                                            if (mysqli_stmt_execute($ins)) {
                                                              echo '<div class="alert alert-success"><i class="fa fa-check"></i>Salary Payment successfully added</div>';
                                                            } else {
                                                              include_once __DIR__ . '/includes/db_debug_logger.php';
                                                              log_db_error_global($con, 'salary: insert execute');
                                                              echo '<div class="alert alert-danger">Failed to add salary. Administrator notified.</div>';
                                                            }
                                                            mysqli_stmt_close($ins);
                                                          } else {
                                                            $q = sprintf("INSERT INTO salary(employee_id,type,year,month,date,salary,nssf,lapf,payee,loan,welfare,bonus,deduction) VALUES('%d','%d','%d','%s','%s','%s','%s','%s','%d','%s','%s','%s','%s')",
                                                              (int)$id, (int)$ty, (int)$year, mysqli_real_escape_string($con, $month), mysqli_real_escape_string($con, $date_sql), mysqli_real_escape_string($con, (string)$salary), mysqli_real_escape_string($con, (string)$nssf_f), mysqli_real_escape_string($con, (string)$lapf_f), (int)$payee_i, mysqli_real_escape_string($con, (string)$loan_f), mysqli_real_escape_string($con, (string)$welfare_f), mysqli_real_escape_string($con, (string)$allowance_f), mysqli_real_escape_string($con, (string)$deductions_f)
                                                            );
                                                            if (mysqli_query($con, $q)) {
                                                              echo '<div class="alert alert-success"><i class="fa fa-check"></i>Salary Payment successfully added</div>';
                                                            } else {
                                                              include_once __DIR__ . '/includes/db_debug_logger.php';
                                                              log_db_error_global($con, 'salary: insert fallback');
                                                              echo '<div class="alert alert-danger">Failed to add salary. Administrator notified.</div>';
                                                            }
                                                          }
                                                        }
                                                      }
		
                           ?>
  <form method="post" class="form" action=''  name="form" enctype="multipart/form-data">
                                <div class="form-group"><label class="control-label">*Select Month</label>
                                              <select name="month" class="form-control">
                                            <option value="">Select month...</option>
                                            <option value="january">January</option>
                                            <option value="february">February</option>
                                            <option value="march">March</option>
                                            <option value="april">April</option>
                                            <option value="may">May</option>
                                            <option value="may">June</option>
                                            <option value="july">July</option>
                                            <option value="august">August</option>
                                            <option value="september">September</option>
                                            <option value="october">October</option>
                                           <option value="november">November</option>
                                            <option value="december">December</option>
                                            </select>
                                                                   </div>
        <div class="form-group"><label class="control-label">*Year (e.g <?php echo date('Y',$timenow); ?>)</label>
            <input type="text"  class="form-control" name="year" required="required">                                                                                                           
                                </div>
       <div class="form-group" id="data_1">
                              <label class=" control-label">*Payment Date</label>                                  
                              <input class="form-control form-control-inline input-medium default-date-picker"  name="date"  size="16" type="text" required=""/>      
                            </div>
        <div class="form-group"><label class="control-label">Allowance</label>
                  <input type="text"  class="form-control" name="allowance">
                                </div>                          
      <div class="row"><div class="col-md-8 col-md-offset-2"><h2>Deductions</h2></div></div>
       
       <div class="form-group"><label class="control-label">*P.A.Y.E.E</label>
<input type="text" class="form-control" name="payee" required="required">                             
                                </div>
         <div class="form-group"><label class="control-label">*N.S.S.F</label>
<input type="text" class="form-control" name="nssf" required="required">
                             
                                </div>
       <div class="form-group"><label class="control-label">L.A.P.F</label>
<input type="text" class="form-control" name="lapf">
                             
                                </div>
        <div class="form-group"><label class="control-label">Advance/Loan</label>
<input type="text" class="form-control" name="loan">
                         </div>
                            
        <div class="form-group"><label class="control-label">Social Welfare</label>
                <input type="text" class="form-control" name="welfare">
                                                             </div>
        <div class="form-group"><label class="control-label">Other Fee Deductions</label>
       
                                           <input type="text" class="form-control" name="deductions">
                                                          </div>
                           

                        
                                                                                                                                  <div class="form-group">
                                
                                                                           <button class="btn btn-primary" name="submit" type="submit">Add Payment</button>
                                   
                                </div>
                            </form>
                            </div>

                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
</body>
</html>
