<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include 'includes/conn.php';

// Require login
if (!isset($_SESSION['schoolsys'])) {
    header('Location:login.php');
    exit;
}

// Require admin or manager levels
if (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2)) {
    header('Location:login.php');
    exit;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Add Papers </title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
             <div class="row">
          <div class="col-lg-6">
                      <section class="panel">
                    <header class="panel-heading">
                   Add Paper
                    </header>
                          <div class="panel-body">
                          <?php
        if (isset($_POST['updatesubmit'])) {
            $classcategory2 = trim((string)($_POST['classcategory2'] ?? ''));
            $std = (int)($_POST['std'] ?? 0);
            $errors = [];

            if ($classcategory2 === '') {
                $errors[] = 'Enter all fields to proceed';
            }

            // Ensure the paper exists
            $exists = false;
            $stmt = mysqli_prepare($con, "SELECT paper_id FROM papers WHERE paper_id = ?");
            if ($stmt) {
                mysqli_stmt_bind_param($stmt, 'i', $std);
                mysqli_stmt_execute($stmt);
                mysqli_stmt_store_result($stmt);
                if (mysqli_stmt_num_rows($stmt) > 0) {
                    $exists = true;
                }
                mysqli_stmt_close($stmt);
            } else {
                // fallback: escaped query
                $res = mysqli_query($con, "SELECT paper_id FROM papers WHERE paper_id = " . (int)$std);
                if ($res && mysqli_num_rows($res) > 0) {
                    $exists = true;
                }
            }

            if (! $exists) {
                $errors[] = 'Paper not found';
            }

            if (!empty($errors)) {
                foreach ($errors as $error) {
                    echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                }
            } else {
                // Prevent duplicate paper names (excluding current id)
                $dup = false;
                $stmt = mysqli_prepare($con, "SELECT paper_id FROM papers WHERE paper_name = ? AND paper_id != ?");
                if ($stmt) {
                    mysqli_stmt_bind_param($stmt, 'si', $classcategory2, $std);
                    mysqli_stmt_execute($stmt);
                    mysqli_stmt_store_result($stmt);
                    if (mysqli_stmt_num_rows($stmt) > 0) {
                        $dup = true;
                    }
                    mysqli_stmt_close($stmt);
                } else {
                    $escaped_name = mysqli_real_escape_string($con, $classcategory2);
                    $res = mysqli_query($con, "SELECT paper_id FROM papers WHERE paper_name = '" . $escaped_name . "' AND paper_id != " . (int)$std);
                    if ($res && mysqli_num_rows($res) > 0) {
                        $dup = true;
                    }
                }

                if ($dup) {
                    echo '<div class="alert alert-danger">' . htmlspecialchars('Paper name already in use', ENT_QUOTES) . '</div>';
                } else {
                    $stmt = mysqli_prepare($con, "UPDATE papers SET paper_name = ? WHERE paper_id = ?");
                    if ($stmt) {
                        mysqli_stmt_bind_param($stmt, 'si', $classcategory2, $std);
                        if (mysqli_stmt_execute($stmt)) {
                            echo '<div class="alert alert-success"><i class="fa fa-check"></i>Paper successfully updated</div>';
                        } else {
                            error_log('DB update error (addpapers update): ' . mysqli_error($con));
                            echo '<div class="alert alert-danger">An internal error occurred. Please try again.</div>';
                        }
                        mysqli_stmt_close($stmt);
                    } else {
                        // fallback
                        $escaped_name = mysqli_real_escape_string($con, $classcategory2);
                        if (mysqli_query($con, "UPDATE papers SET paper_name = '$escaped_name' WHERE paper_id = " . (int)$std)) {
                            echo '<div class="alert alert-success"><i class="fa fa-check"></i>Paper successfully updated</div>';
                        } else {
                            error_log('DB update fallback error (addpapers update): ' . mysqli_error($con));
                            echo '<div class="alert alert-danger">An internal error occurred. Please try again.</div>';
                        }
                    }
                }
            }
        }
        ?>
                                                   <?php
                                         if (isset($_POST['submit'])) {
                                             $classcategory = trim((string)($_POST['classcategory'] ?? ''));
                                             $errors = [];
                                             if ($classcategory === '') {
                                                 $errors[] = 'Enter all fields to proceed';
                                             }

                                             // Check duplicate
                                             $dup = false;
                                             $stmt = mysqli_prepare($con, "SELECT paper_id FROM papers WHERE paper_name = ?");
                                             if ($stmt) {
                                                 mysqli_stmt_bind_param($stmt, 's', $classcategory);
                                                 mysqli_stmt_execute($stmt);
                                                 mysqli_stmt_store_result($stmt);
                                                 if (mysqli_stmt_num_rows($stmt) > 0) {
                                                     $dup = true;
                                                 }
                                                 mysqli_stmt_close($stmt);
                                             } else {
                                                 $escaped = mysqli_real_escape_string($con, $classcategory);
                                                 $res = mysqli_query($con, "SELECT paper_id FROM papers WHERE paper_name = '" . $escaped . "'");
                                                 if ($res && mysqli_num_rows($res) > 0) {
                                                     $dup = true;
                                                 }
                                             }

                                             if ($dup) {
                                                 $errors[] = 'Paper name already exists';
                                             }

                                             if (!empty($errors)) {
                                                 foreach ($errors as $error) {
                                                     echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                                                 }
                                             } else {
                                                 $creator = (int)($_SESSION['schoolsys'] ?? 0);
                                                 $stmt = mysqli_prepare($con, "INSERT INTO papers (paper_name, creator, status) VALUES (?, ?, 1)");
                                                 if ($stmt) {
                                                     mysqli_stmt_bind_param($stmt, 'si', $classcategory, $creator);
                                                     if (mysqli_stmt_execute($stmt)) {
                                                         echo '<div class="alert alert-success"><i class="fa fa-check"></i>Paper successfully added</div>';
                                                     } else {
                                                         error_log('DB insert error (addpapers insert): ' . mysqli_error($con));
                                                         echo '<div class="alert alert-danger">An internal error occurred. Please try again.</div>';
                                                     }
                                                     mysqli_stmt_close($stmt);
                                                 } else {
                                                     // fallback
                                                     $escaped = mysqli_real_escape_string($con, $classcategory);
                                                     if (mysqli_query($con, "INSERT INTO papers(paper_name,creator,status) VALUES('$escaped'," . (int)$creator . ",1)")) {
                                                         echo '<div class="alert alert-success"><i class="fa fa-check"></i>Paper successfully added</div>';
                                                     } else {
                                                         error_log('DB insert fallback error (addpapers insert): ' . mysqli_error($con));
                                                         echo '<div class="alert alert-danger">An internal error occurred. Please try again.</div>';
                                                     }
                                                 }
                                             }
                                         }
	
                           ?>
  <form method="post" class="form" action=''  name="form" enctype="multipart/form-data">
                                <div class="form-group"><label class="control-label">Paper Name</label>
                               <input type="text" class="form-control" name='classcategory' placeholder="Enter Paper Name" required='required'>
                                </div>
                               <div class="form-group">
                 <button class="btn btn-primary" name="submit" type="submit">Add</button>
                                                               </div>
                          </form >
                          </div>
                      </section>
                          </div>
                          <div class="col-lg-6">
                      <section class="panel">
                    <header class="panel-heading">
                    Papers
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped">
        <thead>
        <tr>
                   <th>Paper Name</th>
                        <!-- <th>Streams</th> -->
                                            <th>Action</th>
                  </tr>
        </thead>
        <tbody>
           <?php
                 $getclasses = mysqli_query($con, "SELECT * FROM papers WHERE status = 1");
                while ($row = mysqli_fetch_assoc($getclasses)) {
                    $class_id = (int)$row['paper_id'];
                    $class = htmlspecialchars($row['paper_name'], ENT_QUOTES);                                               
                                  ?>
                <tr class="gradeA">
           <td><?php echo $class; ?></td>
                               
                                   <td>
                                           <?php
                                      if(($_SESSION['schoolsyslevel']==1)){
                                   ?>
                       <a data-toggle="modal" href="#modal-form<?php echo $class_id; ?>" class="btn btn-xs btn-success"><i class="fa fa-edit"></i> Edit </a>
                                       <!-- <a href="streams?id=<?php echo $class_id; ?>" class="btn btn-xs btn-primary"><i class="fa fa-building-o"></i> Streams</a> -->
                      <a href="hidepaper?id=<?php echo $class_id; ?>" class="btn btn-xs btn-danger" onclick="return confirm_delete<?php echo $class_id;?>()"><i class="fa fa-trash-o"></i>Remove</a>
                                        <?php } ?>
                                       <!-- <a href="class?id=<?php echo $class_id; ?>" class="btn btn-xs btn-info"><i class="fa fa-group"></i> Students</a>                                     -->
                                   </td>                                     
                                  <script type="text/javascript">
function confirm_delete<?php echo $class_id; ?>() {
  return confirm('You are about To Remove this Item.Are you sure you want to proceed?');
}
</script>              
                </tr>
                <div id="modal-form<?php echo $class_id; ?>" class="modal fade" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <h3 class="m-t-none m-b">Edit  <?php echo $class; ?></h3>
                                    <form role="form" method="POST" action="" enctype="multipart/form-data">
                                    <input  type="hidden" value="<?php echo $class_id;?>" name="std" >
                                        <div class="form-group">
                                              <label for="username" class="control-label">Paper Name</label>
                                              <input type="text" class="form-control" name='classcategory2'
                                              value="<?php echo $class; ?>"
                                              placeholder="Enter Class Section" required='required'>
                                        </div>
                                        <button class="btn btn-sm btn-primary pull-right m-t-n-xs" type="submit" name="updatesubmit"><strong>Update</strong></button>
                                    </form>
                                                </div>
                                                
                                        </div>
                                    </div>
                                    </div>
                                </div>
            </div>
            <?php } ?>
        </tbody>
      

                        </table>
                          </div>
                          </section>
                          </div>
      
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
