<?php
include '../includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if (!isset($_SESSION['teachersys'])) {
  header('Location:login.php');
  exit;
}

// validate GET params
$cl = isset($_GET['cl']) ? (int) $_GET['cl'] : 0;
$as = isset($_GET['as']) ? (int) $_GET['as'] : 0;
$sub = isset($_GET['sub']) ? (int) $_GET['sub'] : 0;
$tm = isset($_GET['tm']) ? (int) $_GET['tm'] : 0;
$dt = isset($_GET['dt']) ? (int) $_GET['dt'] : 0;
$rk = isset($_GET['rk']) ? (int) $_GET['rk'] : 0;
$paper = isset($_GET['paper']) ? (int) $_GET['paper'] : 0;

if ($cl <= 0 || $as <= 0 || $sub <= 0 || $tm <= 0) {
  echo '<div class="alert alert-danger">Invalid parameters.</div>';
  exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Add Marks-School Manager</title>
   <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                     Add assesment Results
                    </header>
                          <div class="panel-body">  
                        
                                <?php
                // get class
                $class2 = '';
                $category_id2 = 0;
                $stmt = mysqli_prepare($con, "SELECT class,category_id FROM classes WHERE class_id = ?");
                if ($stmt) {
                  mysqli_stmt_bind_param($stmt, 'i', $cl);
                  mysqli_stmt_execute($stmt);
                  $res = mysqli_stmt_get_result($stmt);
                  $row2 = mysqli_fetch_assoc($res);
                  mysqli_stmt_close($stmt);
                } else {
                  $getclasses = mysqli_query($con, "SELECT class,category_id FROM classes WHERE class_id='$cl'");
                  $row2 = mysqli_fetch_array($getclasses);
                }
                if ($row2) {
                  $class2 = $row2['class'];
                  $category_id2 = $row2['category_id'];
                }

                // subject
                $subject2 = '';
                $stmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ?");
                if ($stmt) {
                  mysqli_stmt_bind_param($stmt, 'i', $sub);
                  mysqli_stmt_execute($stmt);
                  $res = mysqli_stmt_get_result($stmt);
                  $row3 = mysqli_fetch_assoc($res);
                  mysqli_stmt_close($stmt);
                } else {
                  $getsubjects = mysqli_query($con, "SELECT subject FROM subjects WHERE subject_id='$sub'");
                  $row3 = mysqli_fetch_array($getsubjects);
                }
                if ($row3) {
                  $subject2 = $row3['subject'];
                }

                // term
                $term2 = '';
                $year = '';
                $stmt = mysqli_prepare($con, "SELECT term,year FROM financialterms WHERE financialterm_id = ?");
                if ($stmt) {
                  mysqli_stmt_bind_param($stmt, 'i', $tm);
                  mysqli_stmt_execute($stmt);
                  $res = mysqli_stmt_get_result($stmt);
                  $row4 = mysqli_fetch_assoc($res);
                  mysqli_stmt_close($stmt);
                } else {
                  $getterm = mysqli_query($con, "SELECT term,year FROM financialterms WHERE financialterm_id='$tm'");
                  $row4 = mysqli_fetch_array($getterm);
                }
                if ($row4) {
                  $term2 = $row4['term'];
                  $year = $row4['year'];
                }

                // paper
                $paper_name = '';
                if ($paper > 0) {
                  $stmt = mysqli_prepare($con, "SELECT paper_name FROM papers WHERE paper_id = ?");
                  if ($stmt) {
                    mysqli_stmt_bind_param($stmt, 'i', $paper);
                    mysqli_stmt_execute($stmt);
                    $res = mysqli_stmt_get_result($stmt);
                    $row_single_paper = mysqli_fetch_assoc($res);
                    mysqli_stmt_close($stmt);
                  } else {
                    $single_paper = mysqli_query($con, "SELECT paper_name FROM papers WHERE paper_id='$paper'");
                    $row_single_paper = mysqli_fetch_array($single_paper);
                  }
                  if ($row_single_paper) {
                    $paper_name = $row_single_paper['paper_name'];
                  }
                }

                // assessment type
                $assessment = '';
                $stmt = mysqli_prepare($con, "SELECT assessmenttype FROM assessmenttypes WHERE assessmenttype_id = ?");
                if ($stmt) {
                  mysqli_stmt_bind_param($stmt, 'i', $as);
                  mysqli_stmt_execute($stmt);
                  $res = mysqli_stmt_get_result($stmt);
                  $rowt = mysqli_fetch_assoc($res);
                  mysqli_stmt_close($stmt);
                } else {
                  $gettypes = mysqli_query($con, "SELECT assessmenttype FROM assessmenttypes WHERE assessmenttype_id='$as'");
                  $rowt = mysqli_fetch_array($gettypes);
                }
                if ($rowt) {
                  $assessment = $rowt['assessmenttype'];
                }
                                ?>
                                    <table  class="display table  table-striped" id="dynamic-table">
     
        <tbody>
         
                <tr class="gradeA">
                       <th>Assessment</th>
                       <td><?php echo $assessment;?></td>
                  </tr>
                 <tr class="gradeA">
                       <th>Class</th>
                       <td><?php echo $class2;?></td>
                  </tr>
                       <tr class="gradeA">
                             <th>Subject</th>
            <td><?php echo $subject2; ?></td>
            </tr>
            <tr class="gradeA">
                             <th>Paper</th>
            <td><?php echo $paper_name; ?></td>
            </tr>
                           <tr class="gradeA">
                             <th> Term</th>
                             <td><?php echo $term2.' '.$year;?></td>
            </tr>
               <tr class="gradeA">
                             <th> Date</th>
                             <td><?php echo date('d/M/Y',$dt);?></td>
            </tr>
                 <tr class="gradeA">
                             <th>Rank</th>
                             <td><?php 
                                $getranks=mysqli_query($con,"SELECT * FROM ranks WHERE status=1  AND rank_id='$rk'");
                            $row = mysqli_fetch_array($getranks);
                                    $rank_id=$row['rank_id'];
                                    $rank=$row['rank'];     
                             echo $rank;?></td>
            </tr>
                   </tbody>
                        </table>
                              
                        </div>
                      </section>
                        </div>
                <div class="col-lg-8">
                   <section class="panel">
                    <header class="panel-heading">
                     Add Assesment Results
                    </header>
                          <div class="panel-body">  
  <?php
  $check_stmt = mysqli_prepare($con, "SELECT mark_id FROM marks WHERE assessment = ? AND term_id = ? AND subject_id = ? AND class_id = ? AND date = ?");
  $already = false;
  if ($check_stmt) {
    mysqli_stmt_bind_param($check_stmt, 'iiiii', $as, $tm, $sub, $cl, $dt);
    mysqli_stmt_execute($check_stmt);
    mysqli_stmt_store_result($check_stmt);
    if (mysqli_stmt_num_rows($check_stmt) > 0) {
      $already = true;
    }
    mysqli_stmt_close($check_stmt);
  } else {
    $check = mysqli_query($con, "SELECT mark_id FROM marks WHERE assessment='$as' AND term_id='$tm' AND subject_id='$sub' AND class_id='$cl' AND date='$dt'");
    if (mysqli_num_rows($check) > 0) {
      $already = true;
    }
  }

  if ($already) {
    echo '<div class="alert alert-danger">Marks Already Added for that day</div>';
  } else {
    include_once __DIR__ . '/includes/db_debug_logger.php';
    if (isset($_POST['mark'], $_POST['student'])) {
      $stdmark = $_POST['mark'];
      $student = $_POST['student'];
      $allstudents = sizeof($student);

      // prepare insert
      $ins_stmt = mysqli_prepare($con, "INSERT INTO marks(marks,rank,subject_id,paper_id,class_id,assessment,student_id,term_id,date,status) VALUES(?,?,?,?,?,?,?,?,?,?)");
      for ($x = 0; $x < $allstudents; $x++) {
        $m = $stdmark[$x];
        $s_id = (int) $student[$x];
        // allow numeric marks or 'N/A' when not in class
        if ($m === 'N/A' || $m === 'n/a') {
          $m_val = null;
        } else {
          $m_val = is_numeric($m) ? $m : null;
        }

        if ($ins_stmt) {
          mysqli_stmt_bind_param($ins_stmt, 'diiiiiiiii', $m_val, $rk, $sub, $paper, $cl, $as, $s_id, $tm, $dt, $status = 1);
          $exec = mysqli_stmt_execute($ins_stmt);
          if ($exec === false) {
            log_db_error_global($con, 'marks: insert');
          }
        } else {
          // fallback
          $m_safe = $m_val === null ? 'NULL' : "'" . mysqli_real_escape_string($con, $m_val) . "'";
          $q = "INSERT INTO marks(marks,rank,subject_id,paper_id,class_id,assessment,student_id,term_id,date,status) VALUES($m_safe,'$rk','$sub','$paper','$cl','$as','$s_id','$tm','$dt','1')";
          $ins = mysqli_query($con, $q);
          if ($ins === false) {
            log_db_error_global($con, 'marks: insert fallback');
          }
        }
      }
      if ($ins_stmt) {
        mysqli_stmt_close($ins_stmt);
      }
      echo '<div class="alert alert-success">Marks Successfully Added</div>';
    }
  }
                                  ?> 
                                  <table  class="display table" id="dynamic-table">
                                            <tr>
                                                <th>Student Name</th>
                                                <th>Mark</th>
                                                <th>Not in My Class</th>
                                            </tr>
 <form method="POST" name='form' class="form-horizontal" action=""  enctype="multipart/form-data">
                              <?php
                                     $getstudents=  mysqli_query($con,"SELECT * FROM students WHERE class_id='$cl'");
                                while ($row = mysqli_fetch_array($getstudents)) {
                                              $student_id=$row['student_id'];
                                              $fullname=$row['fullname'];       
                                                                                
                                      ?>
                                      
                                        <tbody class="table table-striped table-advance table-hover">
                                            
                                            <tr>
                                                <td><?php echo $fullname; ?></td>
                                                <td>
                                                <div class="col-sm-8">                                      
                                        <input type="number" name="student[]" value="<?php echo $student_id; ?>" style="display:none">
                                        <input type="text" class="form-control" name="mark[]" id="mark<?php echo $student_id; ?>"  step="0.01">
                                                                        </div></td>
                                                <td>
                                                <div class="form-group">
                                <input type="checkbox" class="attend" data-id="<?php echo $student_id; ?>" id="attend<?php echo $student_id; ?>"  name="attendance[]" value="<?php echo $student_id; ?>">
                                </div>
                                                  </td>
                                            </tr>
                                        </tbody>
                         
                <!-- <div class="form-group"><label class="col-sm-4 control-label">*<?php echo $fullname; ?></label>

                                   
                                </div> -->
                               
           
                                                <?php } ?> 
                                                </table>

                                                        <!-- <div class="hr-line-dashed"></div> -->
                            
                                                                                                  
                                <div class="form-group col-lg-12">
                                                                      
                                        <button class="btn btn-primary" type="submit">Submit Marks</button>
                                                                </div>
                            </form>
                         </div>
                   </section>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
        <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
<script>
  // function to toggle student marks if not in class
  function toggleStudent(student_id) {
    var mark = document.getElementById('mark' + student_id);
    var attend = document.getElementById('attend' + student_id);
    if (attend.checked) {
      mark.style.display = 'none';
      // pass N/A to the input field
      mark.value = 'N/A';
    } else {
      mark.style.display = 'block';
      // clear the input field
      mark.value = '';
    }
  }

  $(document).on('click','.attend',function(){
    var student_id = $(this).attr('data-id');
    console.log(student_id)
    toggleStudent(student_id);
  }
  );
  </script>

  
</body>

</html>
 