<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if ((!isset($_SESSION['schoolsys'])) || ($_SESSION['schoolsyslevel'] != 3)) {
  header('Location:login.php');
  exit;
}

$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($id <= 0) {
  header('Location:accountstudents.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Lunch Fees Payment</title>  
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
  <link href="css/jquery.filer.css" rel="stylesheet">
  <link href="css/chosen/chosen.css" rel="stylesheet">
 
</head>

<body class="sticky-header">
<section>
   <?php
   include 'includes/header.php'; 
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
              <div class="col-lg-3">
                      <section class="panel">
                  
                          <div class="panel-body">
                                 <?php
         $getstudent_stmt = mysqli_prepare($con, "SELECT regnumber,student_id,fullname,ext FROM students WHERE status=1 AND student_id = ?");
         if ($getstudent_stmt) {
           mysqli_stmt_bind_param($getstudent_stmt, 'i', $id);
           mysqli_stmt_execute($getstudent_stmt);
           $res = mysqli_stmt_get_result($getstudent_stmt);
           $row = mysqli_fetch_assoc($res);
           mysqli_stmt_close($getstudent_stmt);
         } else {
           $getstudent = mysqli_query($con, "SELECT regnumber,student_id,fullname,ext FROM students WHERE status=1 AND student_id='$id'") or die(mysqli_error($con));
           $row = mysqli_fetch_array($getstudent);
         }
         $regnumber = isset($row['regnumber']) ? $row['regnumber'] : '';
         $student_id = isset($row['student_id']) ? $row['student_id'] : '';
         $fullname = isset($row['fullname']) ? $row['fullname'] : '';
         $ext = isset($row['ext']) ? $row['ext'] : '';
                                                               ?>
                              <img src="<?php echo BASE_URL;?>/images/students/<?php echo md5($id).'.'.$ext.'?'.time(); ?>" class="img img-responsive">
                          </div>
                          </section> 
                  <a href="accountstudent?id=<?php echo (int)$id; ?>" class="btn btn-success" ><i class="fa fa-reply"></i> Back to Profile</a>
                                                         </div>
            <div class="col-lg-7">
                      <section class="panel">
                    <header class="panel-heading">
                  Add Lunch Fees Payment for <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                    </header>
                    <div class="panel-body">
          <?php
          if (isset($_POST['term'], $_POST['date'])) {
            $errors = [];
            $date = strtotime($_POST['date']);
            $term = (int) $_POST['term'];

            if ($term <= 0) {
              $errors[] = 'Select a valid term.';
            }
            if ($date === false || $date === -1) {
              $errors[] = 'Select a valid date.';
            }

            if (!empty($errors)) {
              foreach ($errors as $error) {
                echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
              }
            } else {
              $status = 1;
              $insert_stmt = mysqli_prepare($con, "INSERT INTO lunchfeespayments(student_id,term_id,timestamp,status) VALUES(?,?,?,?)");
              if ($insert_stmt) {
                mysqli_stmt_bind_param($insert_stmt, 'iiii', $id, $term, $date, $status);
                if (mysqli_stmt_execute($insert_stmt)) {
                  echo '<div class="alert alert-success">Lunch Fees Payment successfully Added</div>';
                } else {
                  error_log('DB error (lunchfeespayments insert): ' . mysqli_stmt_error($insert_stmt));
                  echo '<div class="alert alert-danger">Could not add payment. Try again later.</div>';
                }
                mysqli_stmt_close($insert_stmt);
              } else {
                $q = "INSERT INTO lunchfeespayments(student_id,term_id,timestamp,status) VALUES('$id','$term','$date','1')";
                if (mysqli_query($con, $q)) {
                  echo '<div class="alert alert-success">Lunch Fees Payment successfully Added</div>';
                } else {
                  error_log('DB error (lunchfeespayments insert fallback): ' . mysqli_error($con));
                  echo '<div class="alert alert-danger">Could not add payment. Try again later.</div>';
                }
              }
            }
          }
          ?>                        
     <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">
                                                       
                                                                            <div class="form-group">
                                                                                <label class="control-label">* Year & Term</label>
                                                          <select name="term" class="form-control">
                                                              <option value="" selected="selected">Select Term & Year ...</option>
                                                                                                                                                   <?php
                                                                                                                       $terms = mysqli_query($con, "SELECT * FROM financialterms WHERE status=1");
                                                          while ($row = mysqli_fetch_assoc($terms)) {
                                                              $financialterm_id = (int)$row['financialterm_id'];
                                                              $term_label = 'Term ' . htmlspecialchars($row['term'], ENT_QUOTES) . ' ' . htmlspecialchars($row['year'], ENT_QUOTES);
                                                              echo '<option value="' . $financialterm_id . '">' . $term_label . '</option>';
                                                          }
                                                          ?>
                                        </select>         
                                                                     
                                </div> 
          <div class="form-group" id="data_1">
                              <label class="control-label">Payment Date (Click on the Icon to select)</label>
                                                         <div class="input-group date">
                                                             <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="date" placeholder="select date" required="required">
                                                                </div>
                            </div>
                                <div class="form-group">
                              <button class="btn btn-primary" type="submit">Add Payment</button>
                                                                  </div>
                            </form>
                            </div>

                    </div>
                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
      
    </div>
    <!-- main content end-->
</section>

<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="js/gen_validatorv4.js"></script>
 <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
<script src="js/scripts.js"></script>
<script>
  $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });   
</script>
</body>
</html>
