<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}
if ((!isset($_SESSION['schoolsys'])) || ($_SESSION['schoolsyslevel'] != 3)) {
  header('Location:login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Lunch Fee</title>  
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/ckeditor/ckeditor.js"></script>
 <link rel="stylesheet" href="js/ckeditor/samples/sample.css">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
  <link href="css/jquery.filer.css" rel="stylesheet">
  <link href="css/chosen/chosen.css" rel="stylesheet">
 
</head>

<body class="sticky-header">
<section>
   <?php
   include 'includes/header.php'; 
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
            <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                   Add Lunch Fees
                    </header>
                    <div class="panel-body">
          <?php
          if (isset($_POST['amount'], $_POST['class'])) {
            $errors = [];

            $amount_raw = trim($_POST['amount']);
            $amount = (float) str_replace([',', ' '], ['', ''], $amount_raw);
            $class = (int) $_POST['class'];

            if ($amount <= 0) {
              $errors[] = 'Enter a valid amount.';
            }
            if ($class <= 0) {
              $errors[] = 'Select a valid class.';
            }

            // check existing
            $check_stmt = mysqli_prepare($con, "SELECT id FROM lunchfees WHERE class_id = ?");
            if ($check_stmt) {
              mysqli_stmt_bind_param($check_stmt, 'i', $class);
              mysqli_stmt_execute($check_stmt);
              mysqli_stmt_store_result($check_stmt);
              if (mysqli_stmt_num_rows($check_stmt) > 0) {
                $errors[] = 'Oops!! the lunch fees for this class are already set';
              }
              mysqli_stmt_close($check_stmt);
            } else {
              $check = mysqli_query($con, "SELECT id FROM lunchfees WHERE class_id='$class'") or die(mysqli_error($con));
              if (mysqli_num_rows($check) > 0) {
                $errors[] = 'Oops!! the lunch fees for this class are already set';
              }
            }

            if (!empty($errors)) {
                foreach ($errors as $error) {
                    echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                }
            } else {
              $status = 1;
              $insert_stmt = mysqli_prepare($con, "INSERT INTO lunchfees(amount,class_id,status) VALUES(?,?,?)");
              if ($insert_stmt) {
                mysqli_stmt_bind_param($insert_stmt, 'dii', $amount, $class, $status);
                if (mysqli_stmt_execute($insert_stmt)) {
                  echo '<div class="alert alert-success">Lunch Fees successfully Added</div>';
                } else {
                  error_log('DB error (lunchfees insert): ' . mysqli_stmt_error($insert_stmt));
                  echo '<div class="alert alert-danger">Could not add lunch fees. Try again later.</div>';
                }
                mysqli_stmt_close($insert_stmt);
              } else {
                $amount_e = (float) $amount;
                $class_e = (int) $class;
                $q = "INSERT INTO lunchfees(amount,class_id,status) VALUES('$amount_e','$class_e','1')";
                if (mysqli_query($con, $q)) {
                  echo '<div class="alert alert-success">Lunch Fees successfully Added</div>';
                } else {
                  error_log('DB error (lunchfees insert fallback): ' . mysqli_error($con));
                  echo '<div class="alert alert-danger">Could not add lunch fees. Try again later.</div>';
                }
              }
            }
          }
          ?>
     <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">
            <div class="form-group"><label class="control-label">* Amount (Should be Numeric)</label>
                                  <input type="text" name='amount' class="form-control" placeholder="Enter Amount" required="required">                                                                         
                                </div>
                                                                  <div class="form-group"><label class="control-label">* Class</label>
                                        <select name="class" class="form-control">
                                            <option value="">select class...</option>
                                           <?php
               $classes_stmt = mysqli_prepare($con, "SELECT class_id,class,level FROM classes WHERE status = ? ORDER BY class ASC");
               if ($classes_stmt) {
                 $active = 1;
                 mysqli_stmt_bind_param($classes_stmt, 'i', $active);
                 mysqli_stmt_execute($classes_stmt);
                 $res = mysqli_stmt_get_result($classes_stmt);
                 while ($row = mysqli_fetch_assoc($res)) {
                   $class_id = (int) $row['class_id'];
                   $class_name = $row['class'];
                   echo '<option value="' . $class_id . '">' . htmlspecialchars($class_name, ENT_QUOTES) . '</option>';
                 }
                 mysqli_stmt_close($classes_stmt);
               } else {
                 $classes = mysqli_query($con, "SELECT class_id,class,level FROM classes WHERE status=1") or die(mysqli_error($con));
                 while ($row = mysqli_fetch_array($classes)) {
                   $class_id = $row['class_id'];
                   $class_name = $row['class'];
                   echo '<option value="' . (int) $class_id . '">' . htmlspecialchars($class_name, ENT_QUOTES) . '</option>';
                 }
               }
            ?>
                                                                                 </select>
                                                                                                    </div>                                          
                                                                           
                                <div class="form-group">
                              <button class="btn btn-primary" type="submit">Add  Fees</button>
                                                                  </div>
                            </form>
                            </div>

                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
      
    </div>
    <!-- main content end-->
</section>

<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="js/gen_validatorv4.js"></script>
<script src="js/chosen/chosen.jquery.js"></script>
<script src="js/scripts.js"></script>
<script src="js/jquery.filer.min.js"></script>
<script>
      $(document).ready(function() {             
                     $('#filer_input').filer({
		showThumbs: true,
		addMore: true
    });
    });
               var config = {
                '.chosen-select'           : {},
                '.chosen-select-deselect'  : {allow_single_deselect:true},
                '.chosen-select-no-single' : {disable_search_threshold:10},
                '.chosen-select-no-results': {no_results_text:'Oops, nothing found!'},
                '.chosen-select-width'     : {width:"95%"}
            }
            for (var selector in config) {
                $(selector).chosen(config[selector]);
            }
</script>
</body>
</html>
