<?php
include 'includes/conn.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['schoolsys'])) {
    header('Location:login.php');
    exit;
}
   ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Journal Records</title>  
     <link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/bootstrap-fullcalendar.css" rel="stylesheet" />
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
<script src="ckeditor/ckeditor.js"></script>
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/prettyphoto/css/prettyPhoto.css" type="text/css" media="screen" title="prettyPhoto main stylesheet" charset="utf-8" />
  <link href="datapicker/datepicker3.css" rel="stylesheet">
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; 
//   echo str_replace('\', ' ',$organisation);
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
            <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                Add Journal Transaction
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_POST['description'], $_POST['type_tran'], $_POST['transact_amt'], $_POST['account'], $_POST['startdate'])) {
                            $errors = [];

                            // sanitize and validate
                            $amt_raw = trim($_POST['transact_amt']);
                            // allow commas in amounts like 1,234.56
                            $amt = (float) str_replace([',', ' '], ['', ''], $amt_raw);
                            $acc = (int) $_POST['account'];
                            $type = (int) $_POST['type_tran'];
                            $description = trim($_POST['description']);
                            $date = strtotime($_POST['startdate']);

                            if ($acc <= 0) {
                                $errors[] = 'Select a valid account.';
                            }
                            if ($amt <= 0) {
                                $errors[] = 'Enter a valid amount.';
                            }
                            if ($type !== 1 && $type !== 2) {
                                $errors[] = 'Select transaction type.';
                            }
                            if (empty($description)) {
                                $errors[] = 'Provide transaction details.';
                            }
                            if ($date === false || $date === -1) {
                                $errors[] = 'Provide a valid transaction date.';
                            }

                            if (!empty($errors)) {
                                foreach ($errors as $error) {
                                    echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                                }
                            } else {
                                $status = 1;
                                $creator = isset($_SESSION['schoolsys']) ? $_SESSION['schoolsys'] : '';

                                $stmt = mysqli_prepare($con, "INSERT INTO accounts_transactions(`date`,account_id,entry_wording,`type`,amount,status,creator) VALUES (?,?,?,?,?,?,?)");
                                if ($stmt) {
                                    // types: date(i), account_id(i), entry_wording(s), type(i), amount(d), status(i), creator(s)
                                    mysqli_stmt_bind_param($stmt, 'iisidis', $date, $acc, $description, $type, $amt, $status, $creator);
                                    $exec = mysqli_stmt_execute($stmt);
                                    if ($exec) {
                                        echo '<div class="alert alert-success"><i class="fa fa-check"></i>Transaction successfully added</div>';
                                    } else {
                                        // log and show safe error
                                        error_log('DB error (accounts_transactions insert): ' . mysqli_stmt_error($stmt));
                                        echo '<div class="alert alert-danger">Could not add transaction. Try again later.</div>';
                                    }
                                    mysqli_stmt_close($stmt);
                                } else {
                                    // fallback (shouldn't usually happen) - escape values
                                    $date_e = (int) $date;
                                    $acc_e = (int) $acc;
                                    $desc_e = mysqli_real_escape_string($con, $description);
                                    $type_e = (int) $type;
                                    $amt_e = (float) $amt;
                                    $creator_e = mysqli_real_escape_string($con, $creator);
                                    $q = "INSERT INTO accounts_transactions(`date`,account_id,entry_wording,`type`,amount,status,creator) VALUES('$date_e','$acc_e','$desc_e','$type_e','$amt_e','$status','$creator_e')";
                                    if (mysqli_query($con, $q)) {
                                        echo '<div class="alert alert-success"><i class="fa fa-check"></i>Transaction successfully added</div>';
                                    } else {
                                        error_log('DB error (accounts_transactions insert fallback): ' . mysqli_error($con));
                                        echo '<div class="alert alert-danger">Could not add transaction. Try again later.</div>';
                                    }
                                }
                            }
                        }
                        ?>
  <form method="post" class="form" action=''  name="form" enctype="multipart/form-data">
  <div class="form-group" id="data_1">
                              <label class="control-label">Transaction Date</label>
                                      <div class="input-group date">
                                          <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="startdate" required="required" placeholder="Transaction date">
                                                 </div>
                            </div>
                                
      <div class="form-group"><label class="control-label">Accounts</label>
                                        <select name="account" class="form-control">
                                            <option value="">select Account...</option>
                                        <?php
                                        // fetch active accounts securely; handle environments without mysqli_stmt_get_result()
                                        $accounts_stmt = mysqli_prepare($con, "SELECT id,title FROM accounts WHERE status = ?");
                                        if ($accounts_stmt) {
                                            $active = 1;
                                            mysqli_stmt_bind_param($accounts_stmt, 'i', $active);
                                            mysqli_stmt_execute($accounts_stmt);

                                            // Prefer get_result when available
                                            if (function_exists('mysqli_stmt_get_result')) {
                                                $res = mysqli_stmt_get_result($accounts_stmt);
                                                if ($res) {
                                                    while ($account = mysqli_fetch_assoc($res)) {
                                                        echo '<option value="' . (int) $account['id'] . '">' . htmlspecialchars($account['title'], ENT_QUOTES) . '</option>';
                                                    }
                                                }
                                            } else {
                                                // Fallback to bind_result + fetch for installations without mysqlnd
                                                mysqli_stmt_store_result($accounts_stmt);
                                                mysqli_stmt_bind_result($accounts_stmt, $acct_id, $acct_title);
                                                while (mysqli_stmt_fetch($accounts_stmt)) {
                                                    echo '<option value="' . (int) $acct_id . '">' . htmlspecialchars($acct_title, ENT_QUOTES) . '</option>';
                                                }
                                            }

                                            mysqli_stmt_close($accounts_stmt);

                                            // If no rows were output (for any reason), try a simple query as a last resort
                                            // This handles unexpected driver/env issues.
                                            if (!isset($res) || ($res && mysqli_num_rows($res) == 0)) {
                                                $accounts = mysqli_query($con, "SELECT id,title FROM accounts WHERE status=1") or die(mysqli_error($con));
                                                while ($account = mysqli_fetch_assoc($accounts)) {
                                                    echo '<option value="' . (int) $account['id'] . '">' . htmlspecialchars($account['title'], ENT_QUOTES) . '</option>';
                                                }
                                            }
                                        } else {
                                            // prepare failed — fallback to simple query
                                            $accounts = mysqli_query($con, "SELECT id,title FROM accounts WHERE status=1") or die(mysqli_error($con));
                                            while ($account = mysqli_fetch_assoc($accounts)) {
                                                echo '<option value="' . (int) $account['id'] . '">' . htmlspecialchars($account['title'], ENT_QUOTES) . '</option>';
                                            }
                                        }
                                        ?>
                                                  
                                        </select>
                                                                        </div>
        <div class="form-group">
            <label class="control-label">Amount</label>
            <input type="text" name="transact_amt" class="form-control" required="required" placeholder="Amount">
        </div>
        <!-- add radio button to select debited or credited  -->
        <div class="mt-2 mb-2">
        <div class="form-check" style="
  display: inline-block;
  margin-right: 1rem;
">
            <input type="radio" name="type_tran" class="form-check-input" value="1" id="debited">
            <label class="form-check-label" for="debited">Debited</label>
        </div>
        <div class="form-check " style="
  display: inline-block;
  margin-right: 1rem;
">
            <input type="radio" name="type_tran" class="form-check-input" value="2" id="credited">
            <label class="form-check-label " for="credited" >Credited</label>
        </div>
        </div>
                            
       
          <div class="form-group">
                                            <label class="control-label">Transaction Details</label>
                                                     <textarea class="ckeditor" cols="80" id="editor1" name="description" rows="100"></textarea>
                                                                                                                        </div>
      <div class="form-group">                                 
                                    <button class="btn btn-primary" name="submit" type="submit">Add Transaction</button>                                
                                </div>
                            </form>
                                                 
                            </div>

                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
     </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
   <script src="datapicker/bootstrap-datepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
</body>
</html>
<script>
    $(document).ready(function(){
            $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });
            });
                </script>