<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Check authorization
if (!hasFinancialAccess($_SESSION['schoolsyslevel'])) {
    header('Location:login.php');
    exit();
}



// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $structure_name = mysqli_real_escape_string($con, $_POST['structure_name'] ?? '');
    $academic_year_id = (int)($_POST['academic_year_id'] ?? 0);
    $term_id = (int)($_POST['term_id'] ?? 0);
    $class_id = (int)($_POST['class_id'] ?? 0);
    $stream_id = (int)($_POST['stream_id'] ?? 0);
    
    $base_tuition = floatval($_POST['base_tuition_fee'] ?? 0);
    $boarding = floatval($_POST['boarding_fee'] ?? 0);
    $activity = floatval($_POST['activity_fee'] ?? 0);
    $examination = floatval($_POST['examination_fee'] ?? 0);
    $technology = floatval($_POST['technology_fee'] ?? 0);
    $sports = floatval($_POST['sports_fee'] ?? 0);
    $other = floatval($_POST['other_fees'] ?? 0);
    
    $total_fee = $base_tuition + $boarding + $activity + $examination + $technology + $sports + $other;
    $description = mysqli_real_escape_string($con, $_POST['description'] ?? '');
    $status = (int)($_POST['status'] ?? 1);
    
    if (empty($structure_name)) {
        $_SESSION['message'] = 'Structure name is required';
        $_SESSION['msg_type'] = 'danger';
    } else {
        // Ensure we have a numeric creator id (avoid undefined session key causing SQL syntax errors)
        $created_by = (int)($_SESSION['user_id'] ?? 0);

        // Build INSERT using the validated variables (numbers unquoted, strings escaped)
        $query = "INSERT INTO fee_structures (
                  structure_name, academic_year_id, term_id, class_id, stream_id,
                  base_tuition_fee, boarding_fee, activity_fee, examination_fee, technology_fee, sports_fee,
                  other_fees, total_fee, description, status, created_by
                  ) VALUES (
                  '" . mysqli_real_escape_string($con, $structure_name) . "',
                  " . (int)$academic_year_id . ",
                  " . (int)$term_id . ",
                  " . (int)$class_id . ",
                  " . (int)$stream_id . ",
                  " . (float)$base_tuition . ",
                  " . (float)$boarding . ",
                  " . (float)$activity . ",
                  " . (float)$examination . ",
                  " . (float)$technology . ",
                  " . (float)$sports . ",
                  " . (float)$other . ",
                  " . (float)$total_fee . ",
                  '" . mysqli_real_escape_string($con, $description) . "',
                  " . (int)$status . ",
                  " . $created_by . 
                  ")";
        
        if (mysqli_query($con, $query)) {
            $_SESSION['message'] = 'Fee structure added successfully';
            $_SESSION['msg_type'] = 'success';
            header('Location: feestructures.php');
            exit();
        } else {
            $_SESSION['message'] = 'Error adding fee structure: ' . mysqli_error($con);
            $_SESSION['msg_type'] = 'danger';
        }
    }
}

// Prepare warnings and prefetch lists safely so the form always renders
$warnings = array();

$yearsRes = false; $termsRes = false; $classesRes = false; $streamsRes = false;

$check = mysqli_query($con, "SHOW TABLES LIKE 'academicyears'");
if ($check && mysqli_num_rows($check) > 0) {
    $colCheck = mysqli_query($con, "SHOW COLUMNS FROM academicyears LIKE 'status'");
    $hasStatusCol = $colCheck && mysqli_num_rows($colCheck) > 0;
    $q = $hasStatusCol ? "SELECT * FROM academicyears WHERE status=1 ORDER BY year DESC" : "SELECT * FROM academicyears ORDER BY year DESC";
    $yearsRes = @mysqli_query($con, $q);
    if (!$yearsRes) $warnings[] = 'Failed to fetch academic years: ' . mysqli_error($con);
} else {
    $warnings[] = 'Table `academicyears` not found. Add academic years in Academics > Academic Years.';
}

$check = mysqli_query($con, "SHOW TABLES LIKE 'financialterms'");
if ($check && mysqli_num_rows($check) > 0) {
    $colCheck = mysqli_query($con, "SHOW COLUMNS FROM financialterms LIKE 'status'");
    $hasStatusCol = $colCheck && mysqli_num_rows($colCheck) > 0;
    $q = $hasStatusCol ? "SELECT * FROM financialterms WHERE status=1 ORDER BY year DESC, term DESC" : "SELECT * FROM financialterms ORDER BY year DESC, term DESC";
    $termsRes = @mysqli_query($con, $q);
    if (!$termsRes) $warnings[] = 'Failed to fetch financial terms: ' . mysqli_error($con);
} else {
    $warnings[] = 'Table `financialterms` not found. Add terms in Academics > Terms.';
}

$check = mysqli_query($con, "SHOW TABLES LIKE 'classes'");
if ($check && mysqli_num_rows($check) > 0) {
    $colCheck = mysqli_query($con, "SHOW COLUMNS FROM classes LIKE 'status'");
    $hasStatusCol = $colCheck && mysqli_num_rows($colCheck) > 0;
    $q = $hasStatusCol ? "SELECT * FROM classes WHERE status=1 ORDER BY class" : "SELECT * FROM classes ORDER BY class";
    $classesRes = @mysqli_query($con, $q);
    if (!$classesRes) $warnings[] = 'Failed to fetch classes: ' . mysqli_error($con);
} else {
    $warnings[] = 'Table `classes` not found. Add classes in Academics > Classes.';
}

$check = mysqli_query($con, "SHOW TABLES LIKE 'streams'");
if ($check && mysqli_num_rows($check) > 0) {
    $colCheck = mysqli_query($con, "SHOW COLUMNS FROM streams LIKE 'status'");
    $hasStatusCol = $colCheck && mysqli_num_rows($colCheck) > 0;
    $q = $hasStatusCol ? "SELECT * FROM streams WHERE status=1 ORDER BY stream" : "SELECT * FROM streams ORDER BY stream";
    $streamsRes = @mysqli_query($con, $q);
    if (!$streamsRes) $warnings[] = 'Failed to fetch streams: ' . mysqli_error($con);
} else {
    $warnings[] = 'Table `streams` not found. Add streams in Academics > Streams.';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Add Fee Structure</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-8 col-lg-offset-2">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-credit-card"></i> Add New Fee Structure
                        </h4>
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_SESSION['message'])) {
                            $type = isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info';
                            echo '<div class="alert alert-' . $type . ' alert-dismissible">';
                            echo '<button type="button" class="close" data-dismiss="alert">&times;</button>';
                            echo htmlspecialchars($_SESSION['message']);
                            echo '</div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }

                        // Show DB warnings (non-fatal) so the user knows why selects may be empty
                        if (!empty($warnings)) {
                            echo '<div class="alert alert-warning"><strong>Notes:</strong><ul style="margin:0; padding-left:18px;">';
                            foreach ($warnings as $w) {
                                echo '<li>' . htmlspecialchars($w) . '</li>';
                            }
                            echo '</ul></div>';
                        }
                        ?>
                        
                        <form method="POST" action="">
                            <div class="form-group">
                                <label class="control-label">* Structure Name</label>
                                <input type="text" name="structure_name" class="form-control" placeholder="e.g., Form 1 2024" required>
                            </div>
                            
                            <div class="form-group">
                                <label class="control-label">Academic Year</label>
                                <select name="academic_year_id" class="form-control">
                                    <option value="">Select Academic Year</option>
                                    <?php
                                    if ($yearsRes && mysqli_num_rows($yearsRes) > 0) {
                                        while ($y = mysqli_fetch_assoc($yearsRes)) {
                                            echo '<option value="' . $y['academicyear_id'] . '">' . htmlspecialchars($y['year']) . '</option>';
                                        }
                                    } else {
                                        echo '<option value="">No academic years available</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label class="control-label">Term</label>
                                <select name="term_id" class="form-control">
                                    <option value="">Select Term</option>
                                    <?php
                                    if ($termsRes && mysqli_num_rows($termsRes) > 0) {
                                        while ($t = mysqli_fetch_assoc($termsRes)) {
                                            echo '<option value="' . $t['financialterm_id'] . '">Term ' . htmlspecialchars($t['term']) . ' ' . htmlspecialchars($t['year']) . '</option>';
                                        }
                                    } else {
                                        echo '<option value="">No terms available</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label class="control-label">Class</label>
                                <select name="class_id" class="form-control">
                                    <option value="">Select Class</option>
                                    <?php
                                    if ($classesRes && mysqli_num_rows($classesRes) > 0) {
                                        while ($cl = mysqli_fetch_assoc($classesRes)) {
                                            echo '<option value="' . $cl['class_id'] . '">' . htmlspecialchars($cl['class']) . '</option>';
                                        }
                                    } else {
                                        echo '<option value="">No classes available</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label class="control-label">Stream</label>
                                <select name="stream_id" class="form-control">
                                    <option value="">Select Stream</option>
                                    <?php
                                    if ($streamsRes && mysqli_num_rows($streamsRes) > 0) {
                                        while ($s = mysqli_fetch_assoc($streamsRes)) {
                                            echo '<option value="' . $s['stream_id'] . '">' . htmlspecialchars($s['stream']) . '</option>';
                                        }
                                    } else {
                                        echo '<option value="">No streams available</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            
                            <div class="form-divider"></div>
                            <h4>Fee Components</h4>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Base Tuition Fee</label>
                                        <input type="number" name="base_tuition_fee" class="form-control fee-input" step="0.01" value="0">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Boarding Fee</label>
                                        <input type="number" name="boarding_fee" class="form-control fee-input" step="0.01" value="0">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Activity Fee</label>
                                        <input type="number" name="activity_fee" class="form-control fee-input" step="0.01" value="0">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Examination Fee</label>
                                        <input type="number" name="examination_fee" class="form-control fee-input" step="0.01" value="0">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Technology Fee</label>
                                        <input type="number" name="technology_fee" class="form-control fee-input" step="0.01" value="0">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Sports Fee</label>
                                        <input type="number" name="sports_fee" class="form-control fee-input" step="0.01" value="0">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label class="control-label">Other Fees</label>
                                <input type="number" name="other_fees" class="form-control fee-input" step="0.01" value="0">
                            </div>
                            
                            <div class="alert alert-info">
                                <strong>Total Fee:</strong> <span id="total-fee">0.00</span>
                            </div>
                            
                            <div class="form-group">
                                <label class="control-label">Description</label>
                                <textarea name="description" class="form-control" rows="3" placeholder="Additional notes..."></textarea>
                            </div>
                            
                            <div class="form-group">
                                <label class="control-label">Status</label>
                                <select name="status" class="form-control">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <button type="submit" class="btn btn-success">
                                    <i class="fa fa-check"></i> Save Fee Structure
                                </button>
                                <a href="feestructures.php" class="btn btn-default">
                                    <i class="fa fa-times"></i> Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script>
$(document).ready(function() {
    function calculateTotal() {
        var total = 0;
        $('.fee-input').each(function() {
            total += parseFloat($(this).val()) || 0;
        });
        $('#total-fee').text(total.toFixed(2));
    }
    
    $('.fee-input').on('change keyup', function() {
        calculateTotal();
    });
    
    calculateTotal();
});
</script>
<script src="js/scripts.js"></script>
</body>
</html>
