<?php
/**
 * Enhanced Fee Payment Processing with Early/Late Payment Adjustments
 * - 5% early payment discount if paid before term start (not for new students)
 * - 5% late payment penalty if unpaid 1 week after half term
 * - Links payments to bank accounts
 * - Records payer information
 */
include 'includes/conn.php';
if(session_status()!==PHP_SESSION_ACTIVE) session_start();
if((!isset($_SESSION['schoolsys']))||(!isset($_SESSION['schoolsyslevel']))||($_SESSION['schoolsyslevel']!=3)){
  header('Location:login.php');
  exit;
}
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if($id<=0){ header('Location:accountstudents.php'); exit; }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Add School Fees Payment</title>  
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

<section class="wrapper">
<div class="row">
    <div class="col-lg-3">
        <section class="panel">
            <div class="panel-body">
                <?php
                $stmt = mysqli_prepare($con, "SELECT student_id,regnumber,fullname,ext,joiningterm FROM students WHERE status=1 AND student_id=? LIMIT 1");
                if($stmt){
                    mysqli_stmt_bind_param($stmt,'i',$id);
                    mysqli_stmt_execute($stmt);
                    $res = mysqli_stmt_get_result($stmt);
                    $student = mysqli_fetch_assoc($res);
                    mysqli_stmt_close($stmt);
                } else {
                    $res = mysqli_query($con,"SELECT * FROM students WHERE status=1 AND student_id='".(int)$id."'");
                    $student = mysqli_fetch_assoc($res);
                }
                $regnumber = $student['regnumber'] ?? '';
                $student_id = $student['student_id'] ?? 0;
                $fullname = $student['fullname'] ?? '';
                $ext = $student['ext'] ?? '';
                $joiningterm = $student['joiningterm'] ?? 0;
                ?>
                <img src="<?php echo BASE_URL;?>/images/students/<?php echo md5($id).'.'.$ext.'?'.time(); ?>" class="img img-responsive">
            </div>
        </section> 
        <a href="studentfeedetails.php?id=<?php echo (int)$id; ?>" class="btn btn-info"><i class="fa fa-eye"></i> View Fee Details</a>
        <a href="accountstudent.php?id=<?php echo (int)$id; ?>" class="btn btn-success"><i class="fa fa-reply"></i> Back to Profile</a>
    </div>
    
    <div class="col-lg-9">
        <section class="panel">
            <header class="panel-heading">
                Add Fees Payment for <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
            </header>
            <div class="panel-body">
                <?php
                if(isset($_POST['amount'],$_POST['term'],$_POST['class'],$_POST['date'],$_POST['bank_account'],$_POST['payment_method'])){
                    $amount_raw = trim($_POST['amount']);
                    $amount_val = is_numeric(str_replace([',',' '],['',''],$amount_raw)) ? (float)str_replace([',',' '],['',''],$amount_raw) : null;
                    $date_ts = !empty($_POST['date']) ? strtotime(str_replace('-','/',$_POST['date'])) : 0;
                    $class = (int)($_POST['class']);
                    $term = (int)($_POST['term']);
                    $bank_account_id = (int)($_POST['bank_account']);
                    $payment_method_id = (int)($_POST['payment_method']);
                    $payer_name = trim($_POST['payer_name'] ?? '');
                    $payer_phone = trim($_POST['payer_phone'] ?? '');
                    $transaction_ref = trim($_POST['transaction_reference'] ?? '');
                    
                    $errors = [];
                    if($amount_raw === '' || empty($class) || empty($term) || empty($date_ts)){
                        $errors[]='Enter All Required Fields';
                    }
                    if($amount_val === null || $amount_val <= 0){
                        $errors[]='Amount Should be a Positive Number'; 
                    }
                    
                    if(!empty($errors)){
                        foreach($errors as $error){ 
                            echo '<div class="alert alert-danger">'.htmlspecialchars($error,ENT_QUOTES).'</div>';
                        }
                    } else {
                        // Get term dates for early/late calculation
                        $termDatesQ = mysqli_query($con, "SELECT * FROM term_important_dates WHERE term_id = $term LIMIT 1");
                        $termDates = mysqli_fetch_assoc($termDatesQ);
                        
                        // Check if student is new (joined this term)
                        $isNewStudent = ($joiningterm == $term) ? 1 : 0;
                        
                        // Calculate early payment discount (5% if paid before term start, excluding new students)
                        $earlyDiscount = 0;
                        $earlyApplied = false;
                        if (!$isNewStudent && $termDates && !empty($termDates['early_payment_deadline'])) {
                            $paymentDate = date('Y-m-d', $date_ts);
                            $earlyDeadline = $termDates['early_payment_deadline'];
                            if ($paymentDate <= $earlyDeadline) {
                                $earlyDiscount = $amount_val * 0.05; // 5% discount
                                $earlyApplied = true;
                            }
                        }
                        
                        // Insert payment
                        $ins = mysqli_prepare($con, "INSERT INTO feespayments(student_id,amount,class_id,term_id,`date`,status) VALUES(?,?,?,?,?,?)");
                        if($ins){
                            $status = 1;
                            mysqli_stmt_bind_param($ins,'idiiii',$id,$amount_val,$class,$term,$date_ts,$status);
                            mysqli_stmt_execute($ins);
                            $last_id = mysqli_insert_id($con);
                            mysqli_stmt_close($ins);
                        } else {
                            $q = "INSERT INTO feespayments(student_id,amount,class_id,term_id,`date`,status) VALUES('".(int)$id."','".mysqli_real_escape_string($con,$amount_val)."','".(int)$class."','".(int)$term."','".(int)$date_ts."','1')";
                            mysqli_query($con,$q);
                            $last_id = mysqli_insert_id($con);
                        }
                        
                        if($last_id > 0){
                            // Insert payment bank details
                            $payerNameEsc = mysqli_real_escape_string($con, $payer_name);
                            $payerPhoneEsc = mysqli_real_escape_string($con, $payer_phone);
                            $transRefEsc = mysqli_real_escape_string($con, $transaction_ref);
                            $paymentDateStr = date('Y-m-d', $date_ts);
                            
                            $bankDetailsQ = "INSERT INTO payment_bank_details (feespayment_id, student_id, bank_account_id, payment_method_id, transaction_reference, payer_name, payer_phone, payment_date, amount, status) 
                                VALUES ($last_id, $id, $bank_account_id, $payment_method_id, '$transRefEsc', '$payerNameEsc', '$payerPhoneEsc', '$paymentDateStr', $amount_val, 1)";
                            mysqli_query($con, $bankDetailsQ);
                            
                            // Record early payment discount if applicable
                            if ($earlyApplied && $earlyDiscount > 0) {
                                // Get base fee for this term/class
                                $feeQ = mysqli_query($con, "SELECT sf.amount FROM schoolfees sf 
                                    JOIN financialterms ft ON ft.year = sf.year 
                                    WHERE sf.class_id = $class AND ft.financialterm_id = $term LIMIT 1");
                                $feeRow = mysqli_fetch_assoc($feeQ);
                                $baseFee = $feeRow['amount'] ?? $amount_val;
                                
                                $termStartDate = $termDates['term_start_date'] ?? date('Y-m-d');
                                $adjustedAmount = $amount_val - $earlyDiscount;
                                $userId = $_SESSION['schoolsys'] ?? 0;
                                
                                $adjQ = "INSERT INTO payment_adjustments (student_id, term_id, adjustment_type, percentage, amount, base_fee_amount, adjusted_amount, reason, payment_date, term_start_date, is_new_student, applied_by, status)
                                    VALUES ($id, $term, 'Early Payment Discount', 5.00, $earlyDiscount, $baseFee, $adjustedAmount, 'Early payment discount applied', '$paymentDateStr', '$termStartDate', $isNewStudent, $userId, 1)";
                                mysqli_query($con, $adjQ);
                                
                                echo '<div class="alert alert-success"><strong>Early Payment Bonus Applied!</strong> KSh '.number_format($earlyDiscount, 2).' discount for early payment.</div>';
                            }
                            
                            // Recalculate student fees
                            mysqli_query($con, "CALL sp_calculate_student_fees($id, $term)");
                            
                            echo '<div class="alert alert-success">School Fees Payment Successfully Added! Amount: KSh '.number_format($amount_val, 2);
                            if ($earlyApplied) {
                                echo ' (Early Payment Discount: KSh '.number_format($earlyDiscount, 2).')';
                            }
                            echo '<br><a href="feesreceipt.php?id=' . (int)$last_id . '" target="_blank" class="btn btn-primary btn-sm"><i class="fa fa-print"></i> Print Receipt</a>';
                            echo ' <a href="studentfeedetails.php?id='.$id.'" class="btn btn-info btn-sm"><i class="fa fa-eye"></i> View Full Fee Details</a></div>';
                        } else {
                            echo '<div class="alert alert-danger">Failed to add payment. Please try again.</div>';
                        }
                    }
                }
                ?>

                <form method="post" class="form" action="">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>* Amount (KSh)</label>
                                <input type="text" name='amount' class="form-control" placeholder="Enter Amount" required="required">
                                <small class="text-muted">Enter full amount. Early payment discount will be calculated automatically.</small>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>* Payment Date (Click icon to select)</label>
                                <div class="input-group date" id="data_1">
                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                    <input type="text" class="form-control" name="date" placeholder="Select date" required="required">
                                </div>
                                <small class="text-success">Pay before term starts for 5% early discount!</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>* Class</label>
                                <select name="class" class="form-control" required>
                                    <option value="">Select class...</option>
                                    <?php
                                    $classes_stmt = mysqli_prepare($con, "SELECT class_id,class FROM classes WHERE status = ? ORDER BY class ASC");
                                    if ($classes_stmt) {
                                        $active = 1;
                                        mysqli_stmt_bind_param($classes_stmt, 'i', $active);
                                        mysqli_stmt_execute($classes_stmt);
                                        $cres = mysqli_stmt_get_result($classes_stmt);
                                        while ($crow = mysqli_fetch_assoc($cres)) {
                                            echo '<option value="' . (int)$crow['class_id'] . '">' . htmlspecialchars($crow['class'], ENT_QUOTES) . '</option>';
                                        }
                                        mysqli_stmt_close($classes_stmt);
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>* Year & Term</label>
                                <select name="term" class="form-control" required>
                                    <option value="" selected="selected">Select Term & Year...</option>
                                    <?php
                                    $terms = mysqli_query($con,"SELECT * FROM financialterms WHERE status=1 ORDER BY financialterm_id DESC");
                                    while($row = mysqli_fetch_array($terms)){
                                        $financialterm_id = $row['financialterm_id'];
                                        $term = $row['term'];
                                        $year = $row['year'];
                                        echo '<option value="'.$financialterm_id.'">Term '.$term.' '.$year.'</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>* Bank Account (Where payment was received)</label>
                                <select name="bank_account" class="form-control" required>
                                    <option value="">Select bank account...</option>
                                    <?php
                                    $banks = mysqli_query($con,"SELECT * FROM bank_accounts WHERE status=1 ORDER BY bank_name ASC");
                                    while($bank = mysqli_fetch_array($banks)){
                                        echo '<option value="'.(int)$bank['bank_account_id'].'">'.htmlspecialchars($bank['bank_name'].' - '.$bank['account_number']).'</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>* Payment Method</label>
                                <select name="payment_method" class="form-control" required>
                                    <option value="">Select method...</option>
                                    <?php
                                    $methods = mysqli_query($con,"SELECT * FROM payment_methods WHERE status=1 ORDER BY method_name ASC");
                                    while($method = mysqli_fetch_array($methods)){
                                        echo '<option value="'.(int)$method['payment_method_id'].'">'.htmlspecialchars($method['method_name']).'</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Payer Name (Optional)</label>
                                <input type="text" name="payer_name" class="form-control" placeholder="Name of person who paid">
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Payer Phone (Optional)</label>
                                <input type="text" name="payer_phone" class="form-control" placeholder="Phone number">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Transaction Reference (Optional)</label>
                        <input type="text" name="transaction_reference" class="form-control" placeholder="Bank reference number, M-Pesa code, etc.">
                    </div>
                    
                    <div class="alert alert-info">
                        <strong><i class="fa fa-info-circle"></i> Payment Policy:</strong>
                        <ul style="margin-bottom: 0;">
                            <li><strong>Early Payment:</strong> 5% discount if paid before term starts (not for new students)</li>
                            <li><strong>Late Payment:</strong> 5% penalty if unpaid 1 week after half term</li>
                            <li><strong>Sibling Discount:</strong> Automatically applied (10% for 2nd child, 20% for 3rd+)</li>
                        </ul>
                    </div>
                    
                    <div class="form-group">
                        <button class="btn btn-success btn-lg" type="submit">
                            <i class="fa fa-check"></i> Add Payment
                        </button>
                        <a href="studentfeedetails.php?id=<?php echo $id; ?>" class="btn btn-default btn-lg">
                            <i class="fa fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </section>
    </div>
</div>
</section>

</section>

<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
<script src="js/scripts.js"></script>
<script>
$('#data_1 .input-group.date').datepicker({
    todayBtn: "linked",
    keyboardNavigation: false,
    forceParse: false,
    calendarWeeks: true,
    autoclose: true,
    format: 'yyyy-mm-dd'
});   
</script>
</body>
</html>
