<?php
include 'includes/conn.php';
if(session_status()!==PHP_SESSION_ACTIVE) session_start();
// Allow finance and accounts roles to add discounts (Super Admin, Principal, Accounts Management, Finance Manager, HR Admin, Accountant)
if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], [1,2,3,8,9,10], true)) {
  header('Location:login.php');
  exit;
}
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if($id<=0){ header('Location:accountstudents.php'); exit; }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add School Fees Discount</title>  
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
  <link href="css/jquery.filer.css" rel="stylesheet">
  <link href="css/chosen/chosen.css" rel="stylesheet">
 
</head>

<body class="sticky-header">
<section>
   <?php
   include 'includes/header.php'; 
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
              <div class="col-lg-3">
                      <section class="panel">
                  
                          <div class="panel-body">
                                 <?php
         $student = null;
         $stmt = mysqli_prepare($con, "SELECT student_id,regnumber,fullname,ext FROM students WHERE status=1 AND student_id=? LIMIT 1");
         if($stmt){
           mysqli_stmt_bind_param($stmt,'i',$id);
           mysqli_stmt_execute($stmt);
           $res = mysqli_stmt_get_result($stmt);
           $student = mysqli_fetch_assoc($res);
           mysqli_stmt_close($stmt);
         } else {
           $res = mysqli_query($con,"SELECT * FROM students WHERE status=1 AND student_id='".(int)$id."'");
           $student = mysqli_fetch_assoc($res);
         }
         $regnumber = $student['regnumber'] ?? '';
         $student_id = $student['student_id'] ?? 0;
         $fullname = $student['fullname'] ?? '';
         $ext = $student['ext'] ?? '';
                                                               ?>
                              <img src="<?php echo BASE_URL;?>/images/students/<?php echo md5($id).'.'.$ext.'?'.time(); ?>" class="img img-responsive">
                          </div>
                          </section> 
                  <a href="accountstudent?id=<?php echo (int)$id; ?>" class="btn btn-success" ><i class="fa fa-reply"></i> Back to Profile</a>
                                                         </div>
            <div class="col-lg-7">
                      <section class="panel">
                    <header class="panel-heading">
                   Add Fees Discount for <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                    </header>
                    <div class="panel-body">
          <?php
  if(isset($_POST['discount'],$_POST['term'],$_POST['class'])){
   $discount = trim($_POST['discount']);
   $discount = str_replace([',','%',' '],['','',''],$discount);
   $class = (int)($_POST['class']);
   $term = (int)($_POST['term']);
     $errors = [];
    if($discount === '' || empty($class) || empty($term)){
     $errors[]='Enter All Fields to proceed';
   }
  if(!is_numeric($discount)){
   $errors[]='Discount Should be a Number'; 
}
   $discount_val = (float)$discount;
   if($discount_val < 0 || $discount_val > 100){
     $errors[]='Discount Should be between 0 and 100 ';
   }
if(!empty($errors)){
foreach($errors as $error){ 
 ?>
 <div class="alert alert-danger"><?php echo htmlspecialchars($error,ENT_QUOTES); ?></div>
<?php 
}         }else{
        $ins = mysqli_prepare($con, "INSERT INTO discounts(student_id,discount,class_id,term_id,status) VALUES(?,?,?,?,?)");
        if($ins){
          $status = 1;
          // Bind parameters using variables (bind_param requires variables passed by reference)
          $sid = (int)$id;
          $disc_val = (float)$discount_val;
          $cid = (int)$class;
          $tid = (int)$term;
          // types: i = integer, d = double/float
          mysqli_stmt_bind_param($ins,'idiii',$sid,$disc_val,$cid,$tid,$status);
          mysqli_stmt_execute($ins);
          if(mysqli_stmt_affected_rows($ins) > 0){
            echo '<div class="alert alert-success">School Fees Discount successfully Added</div>';
          } else {
            echo '<div class="alert alert-danger">Failed to add discount</div>';
          }
          mysqli_stmt_close($ins);
        } else {
          $q = "INSERT INTO discounts(student_id,discount,class_id,term_id,status) VALUES('".(int)$id."','".mysqli_real_escape_string($con,$discount_val)."','".(int)$class."','".(int)$term."','1')";
          if(mysqli_query($con,$q)){
            echo '<div class="alert alert-success">School Fees Discount successfully Added</div>';
          } else {
            error_log('DB error (discounts insert fallback): '.mysqli_error($con));
            echo '<div class="alert alert-danger">Could not add discount. Try again later.</div>';
          }
        }
                }
                }
                       ?>                        
     <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">
            <div class="form-group"><label class="control-label">* Discount (%)</label>
                                  <input type="text" name='discount' class="form-control" placeholder="Enter Discount in Percentage" required="required">                                                                         
                                </div>
                                                                  <div class="form-group"><label class="control-label">* Class</label>
                                        <select name="class" class="form-control">
                                            <option value="">select class...</option>
                                                                                     <?php
                             $classes=mysqli_query($con,"SELECT * FROM classes WHERE status=1");
                                                        
                                while ($row = mysqli_fetch_array($classes)) {
                                    $class_id=$row['class_id'];
                                    $class=$row['class'];
                                    $level=$row['level'];
                            
                            ?>
                                            <option value="<?php echo $class_id;?>"><?php echo $class; ?></option>
                                <?php } ?>
                                                                                 </select>
                                                                                                    </div>                                          
                                                                            <div class="form-group">
                                                                                <label class="control-label">* Year & Term</label>
                                                          <select name="term" class="form-control">
                                                              <option value="" selected="selected">Select Term & Year ...</option>
                                                                                           <?php
$terms=  mysqli_query($con,"SELECT  * FROM financialterms WHERE status=1");
  while($row=  mysqli_fetch_array($terms)){
  $financialterm_id=$row['financialterm_id'];
$term=$row['term'];
$year=$row['year'];
$startdate=$row['startdate'];
$enddate=$row['enddate'];
$status=$row['status'];
  ?>
                                            <option value="<?php echo $financialterm_id;?>"><?php echo 'Term '.$term.' '.$year;?></option>
  <?php } ?>
                                        </select>         
                                                                     
                                </div> 
    
                                <div class="form-group">
                              <button class="btn btn-primary" type="submit">Add Discount</button>
                                                                  </div>
                            </form>
                            </div>

                    </div>
                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
      
    </div>
    <!-- main content end-->
</section>

<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="js/gen_validatorv4.js"></script>
 <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
<script src="js/scripts.js"></script>
<script>
  $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });   
</script>
</body>
</html>
