<?php
include 'includes/conn.php';
if(session_status()!==PHP_SESSION_ACTIVE) session_start();
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Allow Super Admin (1), Principal (2), Finance/Admin (3), Finance Manager (8), HR Admin Director (9), Accountant (10)
if ($user_level === 0 || !in_array($user_level, [1,2,3,8,9,10], true)) {
    header('Location:login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Expense</title>  
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/ckeditor/ckeditor.js"></script>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; 
//   echo str_replace('\', ' ',$organisation);
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
            <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                   Add Expense
                    </header>
                    <div class="panel-body">
                       <?php
    if (isset($_POST['expense'], $_POST['date'], $_POST['amount'])) {
        $date_raw = trim($_POST['date']);
        $date_ts = !empty($date_raw) ? strtotime(str_replace('-', '/', $date_raw)) : 0;
        $amount_raw = trim($_POST['amount']);
        $amount = is_numeric(str_replace([',', ' '], ['', ''], $amount_raw)) ? (float)str_replace([',', ' '], ['', ''], $amount_raw) : null;
        $expense = trim($_POST['expense']);

        $errors = [];
        if ($date_raw === '' || $amount === null || $expense === '') {
            $errors[] = 'Fields Marked * Should not be empty';
        }
        if ($amount === null) {
            $errors[] = 'Amount should be Numeric';
        }
        if ($date_ts === false || $date_ts <= 0) {
            $errors[] = 'Enter a valid date';
        }

        if (!empty($errors)) {
            foreach ($errors as $error) {
                echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
            }
        } else {
            // Determine actual table name (some DBs may use `expense` or `expenses`)
            $expenses_table = null;
            $t = @mysqli_query($con, "SHOW TABLES LIKE 'expenses'");
            if ($t && mysqli_num_rows($t) > 0) {
                $expenses_table = 'expenses';
            } else {
                $t = @mysqli_query($con, "SHOW TABLES LIKE 'expense'");
                if ($t && mysqli_num_rows($t) > 0) {
                    $expenses_table = 'expense';
                }
            }

            if ($expenses_table === null && file_exists(__DIR__ . '/scripts/create_expenses.php')) {
                include __DIR__ . '/scripts/create_expenses.php';
                $t = @mysqli_query($con, "SHOW TABLES LIKE 'expenses'");
                if ($t && mysqli_num_rows($t) > 0) $expenses_table = 'expenses';
            }

            if ($expenses_table === null) {
                echo '<div class="alert alert-danger">Expenses table is missing. Please run <code>scripts/create_expenses.php</code> or contact the administrator.</div>';
            } else {
                $table_esc = mysqli_real_escape_string($con, $expenses_table);
                // determine whether table uses `description` or `expense` column
                $col_text = null;
                $c1 = @mysqli_query($con, "SHOW COLUMNS FROM `{$table_esc}` LIKE 'description'");
                if ($c1 && mysqli_num_rows($c1) > 0) {
                    $col_text = 'description';
                } else {
                    $c2 = @mysqli_query($con, "SHOW COLUMNS FROM `{$table_esc}` LIKE 'expense'");
                    if ($c2 && mysqli_num_rows($c2) > 0) {
                        $col_text = 'expense';
                    }
                }
                if ($col_text === null) {
                    echo '<div class="alert alert-danger">Expenses table does not contain a text column (`description` or `expense`). Please check the schema.</div>';
                } else {
                $col_esc = mysqli_real_escape_string($con, $col_text);
                $sql = "INSERT INTO `{$table_esc}` (`{$col_esc}`,`amount`,`date`,`status`) VALUES(?,?,?,?)";
                $stmt = @mysqli_prepare($con, $sql);
                if ($stmt) {
                    $status = 1;
                    mysqli_stmt_bind_param($stmt, 'sdii', $expense, $amount, $date_ts, $status);
                    mysqli_stmt_execute($stmt);
                    if (mysqli_stmt_affected_rows($stmt) > 0) {
                        echo '<div class="alert alert-success">Expense Successfully Added</div>';
                    } else {
                        echo '<div class="alert alert-danger">Failed to add expense</div>';
                    }
                    mysqli_stmt_close($stmt);
                } else {
                    $exp_e = mysqli_real_escape_string($con, $expense);
                    $amt_e = (float)$amount;
                    $dt_e = (int)$date_ts;
                    $q = "INSERT INTO `{$table_esc}` (`{$col_esc}` ,`amount`,`date`,`status`) VALUES('$exp_e','$amt_e','$dt_e','1')";
                    if (mysqli_query($con, $q)) {
                        echo '<div class="alert alert-success">Expense Successfully Added</div>';
                    } else {
                        error_log('DB error (expenses insert fallback): ' . mysqli_error($con));
                        echo '<div class="alert alert-danger">Could not add expense. Try again later.</div>';
                    }
                }
            }
        }
    }

    }

                                                           ?>                        
     <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">
                                <div class="form-group"><label class="control-label">* Expense</label>
<input type="text" name='expense' class="form-control" placeholder="Enter expense" required="required">                                                                          
                                </div>       
             <div class="form-group"><label class="control-label">* Expense date</label>
  <input class="form-control form-control-inline input-medium default-date-picker"  name="date"  size="16" type="text" />
                                                                                                                       
                                </div>                              
               <div class="form-group">
                   <label class="control-label">*Amount (Should be Numeric)</label>
                           <input type="text" name="amount" class="form-control" placeholder="Enter  Amount" required="required">                                                                   
                                </div>
            
                                    <div class="form-group">
                                                                                    <button class="btn btn-primary" type="submit">Add Expense</button>
                                                                                                                     </div>
                                </form>
                            </div>

                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="js/gen_validatorv4.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
<script>
  var frmvalidator  = new Validator("form");
 frmvalidator.EnableOnPageErrorDisplay();
 frmvalidator.EnableMsgsTogether();
              frmvalidator.addValidation("email","email","*Enter a valid  email address");
//             frmvalidator.addValidation("password","minlength=6","*password  should atleast be 6 characters");
 frmvalidator.addValidation("repeat","eqelmnt=password", "*The passwords dont match");
    
</script>
</body>
</html>
