<?php
include 'includes/conn.php';
if(session_status()!==PHP_SESSION_ACTIVE) session_start();
if(!isset($_SESSION['schoolsys'])){
    header('Location:login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add School Event</title>  
     <link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/bootstrap-fullcalendar.css" rel="stylesheet" />
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
<script src="ckeditor/ckeditor.js"></script>
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/prettyphoto/css/prettyPhoto.css" type="text/css" media="screen" title="prettyPhoto main stylesheet" charset="utf-8" />
  <link href="datapicker/datepicker3.css" rel="stylesheet">
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; 
//   echo str_replace('\', ' ',$organisation);
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
            <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                Add Event
                    </header>
                    <div class="panel-body">
                        <?php
                                      if(isset($_POST['description'],$_POST['eventname'],$_POST['term'],$_POST['year'],$_POST['startdate'],$_POST['enddate'])){
                                  include_once __DIR__ . '/includes/db_debug_logger.php';
                                  $eventname = trim($_POST['eventname']);
                               $term = trim($_POST['term']);
                               $year = (int)$_POST['year'];
                               $description = trim($_POST['description']);
                               $startdate_ts = !empty($_POST['startdate']) ? strtotime($_POST['startdate']) : 0;
                               $enddate_ts = !empty($_POST['enddate']) ? strtotime($_POST['enddate']) : 0;
                                $errors = [];
                                if((empty($eventname))||empty($term)||empty($year)||(empty($startdate_ts))||(empty($enddate_ts))){
                                   $errors[]='Fill All Fields To Proceed';
                                }
                                if($startdate_ts > $enddate_ts){
                                    $errors[]='Start Date cannot be later than End Date';
                                }
                                if(!empty($errors)){
                                foreach ($errors as $error) {
                                echo '<div class="alert alert-danger">'.htmlspecialchars($error,ENT_QUOTES).'</div>';
                           }
                                }
                                else{
                                    $stmt = mysqli_prepare($con, "INSERT INTO events(eventname,term,year,startdate,enddate,description,status) VALUES(?,?,?,?,?,?,'1')");
                                    if($stmt){
                                        mysqli_stmt_bind_param($stmt,'ssiiis',$eventname,$term,$year,$startdate_ts,$enddate_ts,$description);
                                        mysqli_stmt_execute($stmt);
                                        if(mysqli_stmt_affected_rows($stmt) > 0){
                                            echo '<div class="alert alert-success"><i class="fa fa-check"></i>Event successfully added</div>';
                                        } else {
                                            log_db_error_global($con, 'events: insert (no rows)');
                                            echo '<div class="alert alert-danger">Failed to add event. The administrator has been notified.</div>';
                                        }
                                        mysqli_stmt_close($stmt);
                                    } else {
                                        $ins = mysqli_query($con,"INSERT INTO events(eventname,term,year,startdate,enddate,description,status) VALUES('".mysqli_real_escape_string($con,$eventname)."','".mysqli_real_escape_string($con,$term)."','".(int)$year."','".(int)$startdate_ts."','".(int)$enddate_ts."','".mysqli_real_escape_string($con,$description)."','1')");
                                        if($ins === false){
                                            log_db_error_global($con, 'events: insert fallback');
                                            echo '<div class="alert alert-danger">Failed to add event. The administrator has been notified.</div>';
                                        } else {
                                            echo '<div class="alert alert-success"><i class="fa fa-check"></i>Event successfully added</div>';
                                        }
                                    }
                                 }
                            }
                              
                           ?>
  <form method="post" class="form" action=''  name="form" enctype="multipart/form-data">
                                <div class="form-group"><label class="control-label">* Event</label>
                                   <input type="text" class="form-control" name='eventname' placeholder="Enter name" required='required'>
                                </div>
      <div class="form-group"><label class="control-label">* Term</label>
                                        <select name="term" class="form-control">
                                            <option value="">select term...</option>
                                        <option value="Term 1">Term 1</option>
                                        <option value="Term 2">Term 2</option>
                                        <option value="Term 3">Term 3</option>
                                                  
                                        </select>
                                                                        </div>
      <div class="form-group"><label class="control-label">* Year</label>
                                        <select name="year" class="form-control">
                                            <option value="">select joining year...</option>
                                        <option value="<?php echo date('Y',$timenow); ?>"><?php echo date('Y',$timenow); ?></option>
                                                            <?php
                                                            $datenow=date('Y',$timenow); 
                                                                 for ($x = 0; $x <= 15; $x++) {
                                                                     $datenow=$datenow-1;
                                                      echo '<option value="'.$datenow.'">'.$datenow.'</option>';
                                                                        }
                                                                                  ?> 
                                        </select>
                                                                        </div>
                            <div class="form-group" id="data_1">
                              <label class="control-label">Start Date</label>
                                      <div class="input-group date">
                                          <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="startdate" required="required" placeholder="Event Start date">
                                                 </div>
                            </div>
       <div class="form-group" id="data_1">
                              <label class="control-label">End Date</label>
                                      <div class="input-group date">
                                          <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="enddate" required="required" placeholder="Event End date">
                                                 </div>
                            </div>
          <div class="form-group">
                                            <label class="control-label">Event Details</label>
                                                     <textarea class="ckeditor" cols="80" id="editor1" name="description" rows="100"></textarea>
                                                                                                                        </div>
      <div class="form-group">                                 
                                    <button class="btn btn-primary" name="submit" type="submit">Add Event</button>                                
                                </div>
                            </form>
                                                 
                            </div>

                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
     </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
   <script src="datapicker/bootstrap-datepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
</body>
</html>
<script>
    $(document).ready(function(){
            $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });
            });
                </script>