<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!canManageBudgets($user_level)) {
  header('Location:login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Budget</title>
  <script src="js/jquery-1.10.2.min.js"></script>
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
            <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                   Add Budget
                    </header>
                    <div class="panel-body">
                       <?php
    if(isset($_POST['budget_name'],$_POST['total_budget'])){
     $budget_name = trim($_POST['budget_name']);
     $amount_raw = trim($_POST['total_budget']);
     $amount = is_numeric(str_replace([',',' '],['',''],$amount_raw)) ? (float)str_replace([',',' '],['',''],$amount_raw) : null;
     // optional fields
     $department = isset($_POST['department']) ? trim($_POST['department']) : '';
     $fiscal_year = isset($_POST['fiscal_year']) ? trim($_POST['fiscal_year']) : '';
     $budget_period = isset($_POST['budget_period']) ? trim($_POST['budget_period']) : '';
      $errors = [];
      if(empty($budget_name) || $amount === null){
        $errors[] = 'Budget name and amount are required';
      }
      if($amount === null){
        $errors[] = 'Amount must be numeric';
      }
      if(!empty($errors)){
        foreach($errors as $error){
          echo '<div class="alert alert-danger">'.htmlspecialchars($error,ENT_QUOTES).'</div>';
        }
      } else {
        // Check budgets table exists and columns
        $check = mysqli_query($con, "SHOW TABLES LIKE 'budgets'");
        if (!$check || mysqli_num_rows($check) === 0) {
          echo '<div class="alert alert-danger">The <code>budgets</code> table was not found. Create it first or run the provided SQL.</div>';
        } else {
          $cols_q = mysqli_query($con, "SHOW COLUMNS FROM budgets");
          $cols = [];
          if ($cols_q) {
            while ($c = mysqli_fetch_assoc($cols_q)) { $cols[] = $c['Field']; }
          }
          if (!in_array('total_budget', $cols)) {
            echo '<div class="alert alert-danger">The <code>budgets</code> table does not contain an <code>total_budget</code> column. Existing columns: ' . htmlspecialchars(implode(', ', $cols)) . '</div>';
          } else {
            try {
              // Insert minimal compatible columns: budget_name, total_budget, allocated_amount, spent_amount, remaining_amount, status, created_by
              $status = 1;
              $allocated = 0.0;
              $spent = 0.0;
              $remaining = (float)$amount;
              $created_by = isset($_SESSION['schoolsys']) ? (int)$_SESSION['schoolsys'] : 0;
              $stmt = mysqli_prepare($con, "INSERT INTO budgets(budget_name,total_budget,allocated_amount,spent_amount,remaining_amount,status,created_by) VALUES(?,?,?,?,?,?,?)");
              if ($stmt) {
                mysqli_stmt_bind_param($stmt,'sdddiii',$budget_name,$amount,$allocated,$spent,$remaining,$status,$created_by);
                mysqli_stmt_execute($stmt);
                if (mysqli_stmt_affected_rows($stmt) > 0) {
                  echo '<div class="alert alert-success">Budget successfully added</div>';
                } else {
                  echo '<div class="alert alert-danger">Failed to add budget</div>';
                }
                mysqli_stmt_close($stmt);
              } else {
                throw new Exception('Prepared statement failed');
              }
            } catch (Exception $ex) {
              error_log('DB error (budgets insert exception): ' . $ex->getMessage());
              echo '<div class="alert alert-danger">Could not add budget due to a database error. Check server logs.</div>';
            }
          }
        }
      }
     }
                       ?>
     <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
                                <div class="form-group"><label class="control-label">* Budget name</label>
<input type="text" name='budget_name' class="form-control" placeholder="Enter budget name" required="required">
                                </div>
                       <div class="form-group">
                     <label class="control-label">*Total Budget (numeric)</label>
                       <input type="text" name="total_budget" class="form-control" placeholder="Enter total budget" required="required">
                      </div>
                                    <div class="form-group">
                                                                                    <button class="btn btn-primary" type="submit">Add Budget</button>
                                                                                                                     </div>
                                </form>
                            </div>

                    </div>
                </section>
            </div>

        </div>

        </section>

    </div>
</section>

<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>
</html>
