<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level)) { header('Location:login.php'); exit; }

$neededTables = ['bank_accounts','bank_transactions'];
foreach ($neededTables as $tbl) {
    $check = mysqli_query($con, "SHOW TABLES LIKE '$tbl'");
    if (!$check || mysqli_num_rows($check) === 0) {
        die("$tbl table not found. Run create_accounting_tables.sql");
    }
}

$selectedAccount = isset($_GET['account_id']) ? (int)$_GET['account_id'] : 0;
$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bank_account_id = (int)($_POST['bank_account_id'] ?? 0);
    $transaction_type = mysqli_real_escape_string($con, $_POST['transaction_type'] ?? 'Deposit');
    $amount = floatval($_POST['amount'] ?? 0);
    $reference_number = mysqli_real_escape_string($con, $_POST['reference_number'] ?? '');
    $description = mysqli_real_escape_string($con, $_POST['description'] ?? '');
    $transaction_date = mysqli_real_escape_string($con, $_POST['transaction_date'] ?? date('Y-m-d'));
    $transaction_time = mysqli_real_escape_string($con, $_POST['transaction_time'] ?? date('H:i:s'));
    $status = isset($_POST['status']) ? (int)$_POST['status'] : 1;

    if ($bank_account_id <= 0) {
      $error = 'Select a bank account.';
    } elseif ($amount <= 0) {
      $error = 'Amount must be greater than zero.';
    } else {
      // Normalize transaction type to match DB enum
      if ($transaction_type === 'Charge') $transaction_type = 'Fee';
      $allowed_types = ['Deposit','Withdrawal','Transfer','Fee','Interest'];
      if (!in_array($transaction_type, $allowed_types)) $transaction_type = 'Deposit';

      // Map status form values (1/0) to enum values used by bank_transactions
      $status_val = (int)$status;
      $status_map = $status_val === 1 ? 'Completed' : 'Pending';

      // Use a transaction to ensure balance consistency
      mysqli_begin_transaction($con);
      try {
        // Lock the bank account row
        $balStmt = mysqli_prepare($con, "SELECT balance FROM bank_accounts WHERE bank_account_id = ? FOR UPDATE");
        if (!$balStmt) throw new Exception('Prepare failed: '.mysqli_error($con));
        mysqli_stmt_bind_param($balStmt, 'i', $bank_account_id);
        mysqli_stmt_execute($balStmt);
        $balRes = mysqli_stmt_get_result($balStmt);
        $balRow = mysqli_fetch_assoc($balRes);
        mysqli_stmt_close($balStmt);

        if (!$balRow) throw new Exception('Bank account not found');

        $current_balance = (float)$balRow['balance'];

        // Calculate new balance depending on transaction type
        $new_balance = $current_balance;
        if ($transaction_type === 'Deposit' || $transaction_type === 'Interest') {
          $new_balance = $current_balance + $amount;
        } else { // Withdrawal, Transfer, Fee reduce balance
          $new_balance = $current_balance - $amount;
        }

        // Insert transaction with balance_after
        $t_type_esc = mysqli_real_escape_string($con, $transaction_type);
        $ref_esc = mysqli_real_escape_string($con, $reference_number);
        $desc_esc = mysqli_real_escape_string($con, $description);
        $date_esc = mysqli_real_escape_string($con, $transaction_date);
        $time_esc = mysqli_real_escape_string($con, $transaction_time);
        $status_esc = mysqli_real_escape_string($con, $status_map);

        $insert_q = "INSERT INTO bank_transactions
          (bank_account_id, transaction_type, amount, reference_number, description, transaction_date, transaction_time, balance_after, status)
          VALUES ($bank_account_id, '$t_type_esc', $amount, '$ref_esc', '$desc_esc', '$date_esc', '$time_esc', $new_balance, '$status_esc')";

        if (!mysqli_query($con, $insert_q)) throw new Exception('Insert failed: '.mysqli_error($con));

        // Update bank account balance
        $upd_q = "UPDATE bank_accounts SET balance = $new_balance WHERE bank_account_id = $bank_account_id";
        if (!mysqli_query($con, $upd_q)) throw new Exception('Balance update failed: '.mysqli_error($con));

        mysqli_commit($con);
        $message = 'Transaction recorded successfully.';
        $selectedAccount = $bank_account_id;
      } catch (Exception $e) {
        mysqli_rollback($con);
        $error = 'Transaction failed: ' . $e->getMessage();
      }
    }
}

$accounts = mysqli_query($con, "SELECT bank_account_id, bank_name, account_number FROM bank_accounts WHERE status=1 ORDER BY bank_name");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Add Bank Transaction</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8 col-lg-offset-2">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-exchange"></i> Add Bank Transaction</h3>
            <a href="bankaccounts.php" class="btn btn-default btn-sm" style="margin-top:10px;">Back</a>
          </header>
          <div class="panel-body">
            <?php if ($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
            <?php if ($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>
            <form class="form-horizontal" method="post">
              <div class="form-group">
                <label class="col-sm-3 control-label">Bank Account</label>
                <div class="col-sm-9">
                  <select name="bank_account_id" class="form-control" required>
                    <option value="">-- Select Account --</option>
                    <?php while ($row = mysqli_fetch_assoc($accounts)) { 
                      $sel = ($selectedAccount === (int)$row['bank_account_id']) ? 'selected' : '';
                      echo "<option value='{$row['bank_account_id']}' $sel>{$row['bank_name']} - {$row['account_number']}</option>";
                    } ?>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Type</label>
                <div class="col-sm-9">
                  <select name="transaction_type" class="form-control">
                    <?php $types = ['Deposit','Withdrawal','Transfer','Charge'];
                      foreach ($types as $t) { echo "<option value='$t'>$t</option>"; } ?>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Amount</label>
                <div class="col-sm-9"><input type="number" step="0.01" name="amount" class="form-control" required></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Reference</label>
                <div class="col-sm-9"><input type="text" name="reference_number" class="form-control"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Date</label>
                <div class="col-sm-9"><input type="date" name="transaction_date" class="form-control" value="<?php echo date('Y-m-d'); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Time</label>
                <div class="col-sm-9"><input type="time" name="transaction_time" class="form-control" value="<?php echo date('H:i'); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Description</label>
                <div class="col-sm-9"><textarea name="description" class="form-control" rows="3"></textarea></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Status</label>
                <div class="col-sm-9">
                  <select name="status" class="form-control">
                    <option value="1">Posted</option>
                    <option value="0">Draft</option>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9">
                  <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
                </div>
              </div>
            </form>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>