<?php
include 'includes/conn.php';
include 'includes/roles.php'; // Include centralized role management
if(session_status()!==PHP_SESSION_ACTIVE) session_start();
if((!isset($_SESSION['secusys']))||(!isset($_SESSION['secusyslevel']) )||($_SESSION['secusyslevel']!=1)){
    header('Location:login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Add Admin</title>

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
            <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                     Add New Admin
                    </header>
                    <div class="panel-body">
                        <?php
                   if(isset($_POST['fullname'],$_POST['username'],$_POST['password'],$_POST['repeat'],$_POST['email'],$_POST['role'])){
                       $fullname = trim($_POST['fullname']);
                       $username = trim($_POST['username']);
                       $password = trim($_POST['password']);
                       $repeat = trim($_POST['repeat']);
                       $email = trim($_POST['email']);
                       $role = (int)($_POST['role']);
                       $errors = [];
                       if((empty($fullname))||(empty($username))||(empty($password))||(empty($repeat))||(empty($email))||(empty($role))){
                           $errors[]='All fields are required';
                       }
                       if(!filter_var($email, FILTER_VALIDATE_EMAIL)){
                           $errors[] = 'Enter a valid Email';
                       }
                       if($repeat !== $password){
                           $errors[]='The Passwords Dont Match';
                       }
                       // check duplicates using prepared statements
                       if(empty($errors)){
                           $stmt = mysqli_prepare($con, "SELECT user_id FROM users WHERE username=? AND status=1 LIMIT 1");
                           if($stmt){
                               mysqli_stmt_bind_param($stmt,'s',$username);
                               mysqli_stmt_execute($stmt);
                               mysqli_stmt_store_result($stmt);
                               if(mysqli_stmt_num_rows($stmt) > 0) $errors[] = 'Username Already Exists';
                               mysqli_stmt_close($stmt);
                           }
                           $stmt2 = mysqli_prepare($con, "SELECT user_id FROM users WHERE email=? AND status=1 LIMIT 1");
                           if($stmt2){
                               mysqli_stmt_bind_param($stmt2,'s',$email);
                               mysqli_stmt_execute($stmt2);
                               mysqli_stmt_store_result($stmt2);
                               if(mysqli_stmt_num_rows($stmt2) > 0) $errors[] = 'Email Already Exists';
                               mysqli_stmt_close($stmt2);
                           }
                       }

                       if(!empty($errors)){
                           foreach ($errors as $error) {
                               echo '<div class="alert alert-danger">'.htmlspecialchars($error,ENT_QUOTES).'</div>';
                           }
                       }  else {
                           $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                           $ins = mysqli_prepare($con, "INSERT INTO users(fullname,username,password,email,ext,level,status) VALUES(?,?,?,?,? ,?,?)");
                           if($ins){
                               $ext = 'no';
                               $status = 1;
                               mysqli_stmt_bind_param($ins,'sssssii',$fullname,$username,$hashed_password,$email,$ext,$role,$status);
                               mysqli_stmt_execute($ins);
                               if(mysqli_stmt_affected_rows($ins) > 0){
                                   echo '<div class="alert alert-success">Admin added successfully</div>';
                               } else {
                                   echo '<div class="alert alert-danger">Failed to add admin</div>';
                               }
                               mysqli_stmt_close($ins);
                           } else {
                               // fallback
                               mysqli_query($con, "INSERT INTO users(fullname,username,password,email,ext,level,status) VALUES('".mysqli_real_escape_string($con,$fullname)."','".mysqli_real_escape_string($con,$username)."','".mysqli_real_escape_string($con,$hashed_password)."','".mysqli_real_escape_string($con,$email)."','no','".(int)$role."','1')");
                               echo '<div class="alert alert-success">Admin added successfully</div>';
                           }
                       }
                   }
                        ?>
                   <div class="form">
                                <form class="form" id="signupForm" method="POST" action="">
                                    <div class="form-group ">
                                        <label for="firstname" class="control-label">FullName</label>
                                                                                <input class=" form-control" id="firstname" name="fullname" type="text" />
                                                                          </div>
                                                                   <div class="form-group ">
                                        <label for="username" class="control-label">Username</label>
                                                <input class="form-control " id="username" name="username" type="text" />
                                                                         </div>                                  
                                     <div class="form-group ">
                                        <label for="username" class="control-label">Select Role</label>
                                                         <select  class="form-control " name="role">
                                                <option value="" selected="">role</option>
                                                <?php echo generateRoleOptions(); ?>
                                            </select>
                                                                         </div>
                                    <div class="form-group ">
                                        <label for="password" class="control-label">Password</label>
                                                                       <input class="form-control " id="password" name="password" type="password" />                                       
                                    </div>
                                    <div class="form-group ">
                                        <label for="confirm_password" class="control-label">Repeat Password</label>
                                                <input class="form-control " id="confirm_password" name="repeat" type="password" />
                                                                         </div>
                                    <div class="form-group ">
                                        <label for="email" class="control-label">Email</label>
                                         <input class="form-control " id="email" name="email" type="email" />
                                                                        </div>
                               
                                    <div class="form-group">
                                  
                                            <button class="btn btn-primary" type="submit">Add</button>
                                                                                                                </div>
                                </form>
                            </div>

                    </div>
                </section>
           
            </div>

        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>

<script type="text/javascript" src="js/jquery.validate.min.js"></script>
<script src="js/validation-init.js"></script>

<!--common scripts for all pages-->
<script src="js/scripts.js"></script>
</body>
</html>
