<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level)) { header('Location:login.php'); exit; }

$neededTables = ['vendors','accounts_payable'];
foreach ($neededTables as $tbl) {
    $check = mysqli_query($con, "SHOW TABLES LIKE '$tbl'");
    if (!$check || mysqli_num_rows($check) === 0) { die("$tbl table not found. Run create_accounting_tables.sql"); }
}

$message = '';
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vendor_id = (int)($_POST['vendor_id'] ?? 0);
    $invoice_number = mysqli_real_escape_string($con, $_POST['invoice_number'] ?? '');
    $invoice_date = mysqli_real_escape_string($con, $_POST['invoice_date'] ?? date('Y-m-d'));
    $due_date = mysqli_real_escape_string($con, $_POST['due_date'] ?? date('Y-m-d'));
    $amount = floatval($_POST['amount'] ?? 0);
    $status = mysqli_real_escape_string($con, $_POST['status'] ?? 'Draft');
    $description = mysqli_real_escape_string($con, $_POST['description'] ?? '');

    if ($vendor_id <= 0) {
        $error = 'Select a vendor.';
    } elseif ($amount <= 0) {
        $error = 'Amount must be greater than zero.';
    } else {
        $insert = mysqli_query($con, "INSERT INTO accounts_payable (vendor_id, invoice_number, invoice_date, due_date, amount, status, description) VALUES ($vendor_id, '$invoice_number', '$invoice_date', '$due_date', $amount, '$status', '$description')");
        if ($insert) {
            $message = 'Invoice recorded successfully.';
        } else {
            $error = 'Insert failed: '.mysqli_error($con);
        }
    }
}

$vendors = mysqli_query($con, "SELECT vendor_id, vendor_name AS name FROM vendors WHERE status=1 ORDER BY vendor_name");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Add Accounts Payable</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8 col-lg-offset-2">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-file-text"></i> Add Accounts Payable</h3>
            <a href="accountspayable.php" class="btn btn-default btn-sm" style="margin-top:10px;">Back</a>
          </header>
          <div class="panel-body">
            <?php if ($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
            <?php if ($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>
            <form class="form-horizontal" method="post">
              <div class="form-group">
                <label class="col-sm-3 control-label">Vendor</label>
                <div class="col-sm-9">
                  <select name="vendor_id" class="form-control" required>
                    <option value="">-- Select Vendor --</option>
                    <?php while ($v = mysqli_fetch_assoc($vendors)) {
                      echo "<option value='{$v['vendor_id']}'>{$v['name']}</option>";
                    } ?>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Invoice #</label>
                <div class="col-sm-9"><input type="text" name="invoice_number" class="form-control" required></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Invoice Date</label>
                <div class="col-sm-9"><input type="date" name="invoice_date" class="form-control" value="<?php echo date('Y-m-d'); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Due Date</label>
                <div class="col-sm-9"><input type="date" name="due_date" class="form-control" value="<?php echo date('Y-m-d'); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Amount</label>
                <div class="col-sm-9"><input type="number" step="0.01" name="amount" class="form-control" required></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Status</label>
                <div class="col-sm-9">
                  <select name="status" class="form-control">
                    <?php foreach (['Draft','Pending','Approved','Paid'] as $s) { echo "<option value='$s'>$s</option>"; } ?>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Description</label>
                <div class="col-sm-9"><textarea name="description" class="form-control" rows="3"></textarea></div>
              </div>
              <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9">
                  <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
                </div>
              </div>
            </form>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>