<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
include 'includes/conn.php';
if ((!isset($_SESSION['schoolsys'])) || ($_SESSION['schoolsyslevel'] != 1)) {
    header('Location:login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="t">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Add School Academic years </title>
    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/ckeditor/ckeditor.js"></script>
    <link rel="stylesheet" href="js/ckeditor/samples/sample.css">
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
    <link href="css/jquery.filer.css" rel="stylesheet">
    <link href="css/chosen/chosen.css" rel="stylesheet">
    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
    <section>
        <?php include 'includes/header.php';
        //   echo str_replace('\', ' ',$organisation);
        ?>

        <section class="wrapper">
            <!-- page start-->

            <div class="row">
                <div class="col-lg-8">
                    <section class="panel">
                        <header class="panel-heading">
                            Add New Academic Year
                        </header>
                        <div class="panel-body">
                            <?php
                            if (isset($_POST['endyear'], $_POST['startyear'])) {
                                $errors = [];
                                // use filter_input to validate integers
                                $start = filter_input(INPUT_POST, 'startyear', FILTER_VALIDATE_INT);
                                $end = filter_input(INPUT_POST, 'endyear', FILTER_VALIDATE_INT);

                                // enforce sensible year range
                                $minYear = 1900;
                                $maxYear = 2099;
                                if ($start === false || $end === false) {
                                    $errors[] = 'All Fields Are Required and must be valid years';
                                } else {
                                    if ($start < $minYear || $start > $maxYear || $end < $minYear || $end > $maxYear) {
                                        $errors[] = 'Year values out of allowed range';
                                    }
                                    if ($start > $end) {
                                        $errors[] = 'Start Year Cannot Be Greater Than End Year';
                                    }
                                }

                                if (empty($errors)) {
                                    // check duplicate using prepared statement
                                    $stmt = mysqli_prepare($con, "SELECT 1 FROM financialyears WHERE start=? AND end=? LIMIT 1");
                                    if ($stmt) {
                                        mysqli_stmt_bind_param($stmt, 'ii', $start, $end);
                                        mysqli_stmt_execute($stmt);
                                        mysqli_stmt_store_result($stmt);
                                        if (mysqli_stmt_num_rows($stmt) > 0) {
                                            $errors[] = 'Academic Year Already Added';
                                        }
                                        mysqli_stmt_close($stmt);
                                    } else {
                                        $errors[] = 'Database error (prepare failed).';
                                    }
                                }

                                if (!empty($errors)) {
                                    foreach ($errors as $error) {
                            ?>
                                        <div class="alert alert-danger"><?php echo htmlspecialchars($error, ENT_QUOTES); ?></div>
                            <?php
                                    }
                                } else {
                                    $fyear = $start . '-' . $end;
                                    $stmt = mysqli_prepare($con, "INSERT INTO financialyears(fyear,start,end,status) VALUES(?,?,?,1)");
                                    if ($stmt) {
                                        mysqli_stmt_bind_param($stmt, 'sii', $fyear, $start, $end);
                                        mysqli_stmt_execute($stmt);
                                        if (mysqli_stmt_affected_rows($stmt) > 0) {
                                            echo '<div class="alert alert-success">New Academic Year successfully Added</div>';
                                        } else {
                                            echo '<div class="alert alert-danger">Failed to add academic year: ' . htmlspecialchars(mysqli_error($con), ENT_QUOTES) . '</div>';
                                        }
                                        mysqli_stmt_close($stmt);
                                    } else {
                                        echo '<div class="alert alert-danger">Database error (prepare failed).</div>';
                                    }
                                }
                            }

                            ?>

                            <form method="post" name='form' class="form-horizontal" action="" enctype="multipart/form-data">
                                <div class="hr-line-dashed"></div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">* Start Year</label>
                                    <div class="col-sm-10">
                                        <?php $curYear = (int)date('Y'); ?>
                                        <input type="number" name="startyear" class="form-control" value="<?php echo $curYear; ?>" min="1900" max="2099" required />
                                        <small class="text-muted">Enter the start year (e.g. 2025). You may enter future years.</small>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">* End Year</label>
                                    <div class="col-sm-10">
                                        <?php $curYear = (int)date('Y'); ?>
                                        <input type="number" name="endyear" class="form-control" value="<?php echo $curYear + 1; ?>" min="1900" max="2099" required />
                                        <small class="text-muted">Enter the end year (e.g. 2026). End year must be greater than or equal to start year.</small>
                                    </div>
                                </div>




                                <div class="hr-line-dashed"></div>


                                <div class="form-group">
                                    <div class="col-sm-4 col-sm-offset-2">

                                        <button class="btn btn-primary" type="submit">Add Year</button>
                                    </div>
                                </div>
                            </form>
                        </div>

                </div>
        </section>

        </div>

        </div>


        </div>
        <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
    </section>

    <script src="js/bootstrap.min.js"></script>
    <script src="js/modernizr.min.js"></script>
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" src="js/gen_validatorv4.js"></script>
    <script src="js/chosen/chosen.jquery.js"></script>
    <script src="js/scripts.js"></script>
    <script src="js/jquery.filer.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#filer_input').filer({
                showThumbs: true,
                addMore: true
            });
        });
        var config = {
            '.chosen-select': {},
            '.chosen-select-deselect': {
                allow_single_deselect: true
            },
            '.chosen-select-no-single': {
                disable_search_threshold: 10
            },
            '.chosen-select-no-results': {
                no_results_text: 'Oops, nothing found!'
            },
            '.chosen-select-width': {
                width: "95%"
            }
        }
        for (var selector in config) {
            $(selector).chosen(config[selector]);
        }
    </script>
</body>

</html>