<?php
include 'includes/conn.php';

if (!isset($_SESSION)) {
        session_start();
}
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Allow Super Admin (1), Principal (2), Finance/Admin (3), Finance Manager (8), HR Admin Director (9), Accountant (10)
if ($user_level === 0 || !in_array($user_level, [1,2,3,8,9,10], true)) {
        header('Location: login.php');
        exit;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Account Types </title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
             <div class="row">
          <div class="col-lg-6">
                      <section class="panel">
                    <header class="panel-heading">
                   Add Account Types
                    </header>
                          <div class="panel-body">
                          <?php
        if (isset($_POST['updatesubmit'])) {
            $classcategory2 = isset($_POST['classtype2']) ? trim($_POST['classtype2']) : '';
            $effortdesc2 = isset($_POST['effortdesc2']) ? trim($_POST['effortdesc2']) : '';
            $std = isset($_POST['std']) ? (int)$_POST['std'] : 0;
            $errors = [];

            if ($classcategory2 === '') {
                $errors[] = 'Enter All Fields To Proceed';
            }

            // check exists
            $exists = false;
            $chk = mysqli_prepare($con, "SELECT id FROM account_types WHERE id = ? LIMIT 1");
            if ($chk) {
                mysqli_stmt_bind_param($chk, 'i', $std);
                mysqli_stmt_execute($chk);
                mysqli_stmt_store_result($chk);
                if (mysqli_stmt_num_rows($chk) > 0) {
                    $exists = true;
                }
                mysqli_stmt_close($chk);
            } else {
                $check2 = mysqli_query($con, "SELECT id FROM account_types WHERE id='" . (int)$std . "'");
                if ($check2 && mysqli_num_rows($check2) > 0) {
                    $exists = true;
                }
            }

            if (!$exists) {
                $errors[] = 'Account Type Does Not Exist';
            }

            if (!empty($errors)) {
                foreach ($errors as $error) {
                    echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                }
            } else {
                $upd = mysqli_prepare($con, "UPDATE account_types SET type_name = ?, description = ? WHERE id = ?");
                if ($upd) {
                    mysqli_stmt_bind_param($upd, 'ssi', $classcategory2, $effortdesc2, $std);
                    mysqli_stmt_execute($upd);
                    mysqli_stmt_close($upd);
                } else {
                    mysqli_query($con, "UPDATE account_types SET type_name='" . mysqli_real_escape_string($con, $classcategory2) . "', description='" . mysqli_real_escape_string($con, $effortdesc2) . "' WHERE id='" . (int)$std . "'");
                }
                echo '<div class="alert alert-success"><i class="fa fa-check"></i>Account Type successfully Updated</div>';
            }
        }
        ?>
                                                   <?php
                                if (isset($_POST['submit'])) {
                                    $effortname = isset($_POST['typename']) ? trim($_POST['typename']) : '';
                                    $effortdesc = isset($_POST['typedesc']) ? trim($_POST['typedesc']) : '';
                                    $errors = [];

                                    if ($effortname === '') {
                                        $errors[] = 'Enter All Fields To Proceed';
                                    }

                                    // uniqueness check
                                    $chk = mysqli_prepare($con, "SELECT id FROM account_types WHERE type_name = ? LIMIT 1");
                                    if ($chk) {
                                        mysqli_stmt_bind_param($chk, 's', $effortname);
                                        mysqli_stmt_execute($chk);
                                        mysqli_stmt_store_result($chk);
                                        if (mysqli_stmt_num_rows($chk) > 0) {
                                            $errors[] = 'Account Type Name Already Exists';
                                        }
                                        mysqli_stmt_close($chk);
                                    } else {
                                        $check2 = mysqli_query($con, "SELECT * FROM account_types WHERE type_name='" . mysqli_real_escape_string($con, $effortname) . "'");
                                        if ($check2 && mysqli_num_rows($check2) > 0) {
                                            $errors[] = 'Account Type Name Already Exists';
                                        }
                                    }

                                    if (!empty($errors)) {
                                        foreach ($errors as $error) {
                                            echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                                        }
                                    } else {
                                        $ins = mysqli_prepare($con, "INSERT INTO account_types(type_name,description,creator,status,created_at) VALUES(?, ?, ?, 1, UNIX_TIMESTAMP())");
                                        if ($ins) {
                                            $creator = isset($_SESSION['schoolsys']) ? $_SESSION['schoolsys'] : '';
                                            mysqli_stmt_bind_param($ins, 'sss', $effortname, $effortdesc, $creator);
                                            mysqli_stmt_execute($ins);
                                            mysqli_stmt_close($ins);
                                        } else {
                                            mysqli_query($con, "INSERT INTO account_types(type_name,description,creator,status,created_at) VALUES('" . mysqli_real_escape_string($con, $effortname) . "','" . mysqli_real_escape_string($con, $effortdesc) . "','" . mysqli_real_escape_string($con, isset($_SESSION['schoolsys']) ? $_SESSION['schoolsys'] : '') . "','1',UNIX_TIMESTAMP())");
                                        }
                                        echo '<div class="alert alert-success"><i class="fa fa-check"></i>Account Type Successfully Added</div>';
                                    }
                                }
	
                           ?>
  <form method="post" class="form" action=''  name="form" enctype="multipart/form-data">
                                <div class="form-group"><label class="control-label">Account Type Name</label>
                               <input type="text" class="form-control" name='typename' placeholder="Enter Account Type Name" required='required'>
                                </div>
                                
                                <div class="form-group"><label class="control-label">Account Type Description</label>
                               <input type="text" class="form-control" name='typedesc' placeholder="Effort description" required='required'>
                                </div>
                               <div class="form-group">
                 <button class="btn btn-primary" name="submit" type="submit">Save</button>
                                                               </div>
                          </form >
                          </div>
                      </section>
                          </div>
                          <div class="col-lg-6">
                      <section class="panel">
                    <header class="panel-heading">
                    Sections
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped">
        <thead>
        <tr>
                   <th>Account type name</th>
                        <th>Account type Description</th>
                                            <th>Action</th>
                  </tr>
        </thead>
        <tbody>
               <?php
                             $getclasses=mysqli_query($con,"SELECT * FROM account_types WHERE status=1 ");
                             if (mysqli_num_rows($getclasses)==0) {
                                 echo '<tr><td colspan="3"><div class="alert alert-danger">No Account Types Found</div></td></tr>';
                             }else{
                            while ($row = mysqli_fetch_array($getclasses)) {
                                    $class_id=$row['id'];
                                    $class=$row['type_name'];  
                                    $desc=$row['description'];                                              
                                                              ?>
                <tr class="gradeA">
               <td><?php echo $class; ?></td>
               <td><?php echo $desc; ?></td>
                               
                                   <td>
                                              <?php
                                                  // Show actions to Super Admin (1), Principal (2), Accounts Management (3), Finance Manager (8), HR Admin Director (9), Accountant (10)
                                                  if (isset($_SESSION['schoolsyslevel']) && in_array((int)$_SESSION['schoolsyslevel'], [1,2,3,8,9,10], true)) {
                                              ?>
                                                    <a data-toggle="modal" href="#modal-form<?php echo $class_id; ?>" class="btn btn-xs btn-success"><i class="fa fa-edit"></i> Edit </a>
                                                        <a href="hideacctypes?id=<?php echo $class_id; ?>" class="btn btn-xs btn-danger" onclick="return confirm_delete<?php echo $class_id;?>()"><i class="fa fa-trash-o"></i> Remove</a>
                                                     <?php } ?>
                                       <!-- <a href="class?id=<?php echo $class_id; ?>" class="btn btn-xs btn-info"><i class="fa fa-group"></i> Students</a>                                     -->
                                   </td>                                     
                                  <script type="text/javascript">
function confirm_delete<?php echo $class_id; ?>() {
  return confirm('You are about To Remove this Account type and the accounts assigned to it .Are you sure you want to proceed?');
}
</script>              
                </tr>
                <div id="modal-form<?php echo $class_id; ?>" class="modal fade" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <h3 class="m-t-none m-b">Edit  <?php echo $class; ?></h3>
                                                    <form role="form" method="POST" action="" enctype="multipart/form-data">
                                                    <input  type="hidden" value="<?php echo $class_id;?>" name="std" >
                                                          <div class="form-group">
                                                                    <label for="username" class="control-label">Account Type Name</label>
                                                                    <input type="text" class="form-control" name='classtype2'
                                                                    value="<?php echo $class; ?>"
                                                                    placeholder="Enter Type Name" required='required'>
                                                          </div>
                                                          
                                                          <div class="form-group">
                                                                    <label for="username" class="control-label">Account Type Description</label>
                                                                    <input type="text" class="form-control" name='effortdesc2'
                                                                    value="<?php echo $desc; ?>"
                                                                    placeholder="" required='required'>
                                                          </div>
                                                          <button class="btn btn-sm btn-primary pull-right m-t-n-xs" type="submit" name="updatesubmit"><strong>Update</strong></button>
                                                    </form>
                                                </div>
                                                
                                        </div>
                                    </div>
                                    </div>
                                </div>
            </div>
            <?php } }?>
        </tbody>
      

                        </table>
                          </div>
                          </section>
                          </div>
      
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
