<?php
include 'includes/conn.php';

if (session_status() !== PHP_SESSION_ACTIVE) session_start();
// Allow Super Admin (1), Principal (2), Accounts Management (3), Finance Manager (8), Accountant (10)
if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], [1,2,3,8,10], true)) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>All Students</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
    <div class="col-lg-12">
      <section class="panel">
        <header class="panel-heading">All Students</header>
        <div class="panel-body">
          <table class="display table table-striped" id="dynamic-table">
            <thead>
              <tr>
                <th>Student No</th>
                <th>Full Names</th>
                <th>Class</th>
                <th>Gender</th>
                <th>Fees Balance</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
<?php
// Prepared fetch of students
$stmt = mysqli_prepare($con, "SELECT student_id,regnumber,fullname,gender,joiningyear,joiningterm,class_id,stream_id FROM students WHERE status=1");
if($stmt){
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
} else {
    $res = mysqli_query($con, "SELECT student_id,regnumber,fullname,gender,joiningyear,joiningterm,class_id,stream_id FROM students WHERE status=1");
}

if(!$res || mysqli_num_rows($res) == 0){
    echo '<tr><td colspan="6"><div class="alert alert-danger">No Students Found</div></td></tr>';
} else {
    while($row = mysqli_fetch_assoc($res)){
        $student_id = isset($row['student_id']) ? (int)$row['student_id'] : 0;
        $regnumber = $row['regnumber'] ?? '';
        $fullname = $row['fullname'] ?? '';
        $gender = $row['gender'] ?? '';
        $joiningyear = isset($row['joiningyear']) ? (int)$row['joiningyear'] : 0;
        $joiningterm = isset($row['joiningterm']) ? (int)$row['joiningterm'] : 0;
        $class_id = isset($row['class_id']) ? (int)$row['class_id'] : 0;
        $stream_id = isset($row['stream_id']) ? (int)$row['stream_id'] : 0;

        // fetch stream
        $stream = '';
        $sstmt = mysqli_prepare($con, "SELECT stream FROM streams WHERE stream_id=?");
        if($sstmt){
            mysqli_stmt_bind_param($sstmt,'i',$stream_id);
            mysqli_stmt_execute($sstmt);
            $sr = mysqli_stmt_get_result($sstmt);
            if($sr) { $r = mysqli_fetch_assoc($sr); $stream = $r['stream'] ?? ''; }
            mysqli_stmt_close($sstmt);
        } else {
            $sr = mysqli_query($con, "SELECT stream FROM streams WHERE stream_id='".(int)$stream_id."'");
            $r = $sr ? mysqli_fetch_assoc($sr) : null; $stream = $r['stream'] ?? '';
        }

        // fetch class
        $class_name = '';
        $cstmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id=?");
        if($cstmt){
            mysqli_stmt_bind_param($cstmt,'i',$class_id);
            mysqli_stmt_execute($cstmt);
            $cr = mysqli_stmt_get_result($cstmt);
            if($cr){ $rc = mysqli_fetch_assoc($cr); $class_name = $rc['class'] ?? ''; }
            mysqli_stmt_close($cstmt);
        } else {
            $cr = mysqli_query($con, "SELECT class FROM classes WHERE class_id='".(int)$class_id."'");
            $rc = $cr ? mysqli_fetch_assoc($cr) : null; $class_name = $rc['class'] ?? '';
        }

        // fees balance calculation
        $balanceStatus = 'NO';
        $ppstmt = mysqli_prepare($con, "SELECT COUNT(DISTINCT term_id) AS paid_terms FROM feespayments WHERE student_id=? AND status=1");
        if($ppstmt){
            mysqli_stmt_bind_param($ppstmt,'i',$student_id);
            mysqli_stmt_execute($ppstmt);
            $pr = mysqli_stmt_get_result($ppstmt);
            $prow = $pr ? mysqli_fetch_assoc($pr) : null;
            $paid_terms = isset($prow['paid_terms']) ? (int)$prow['paid_terms'] : 0;
            mysqli_stmt_close($ppstmt);
        } else {
            $pr = mysqli_query($con, "SELECT COUNT(DISTINCT term_id) AS paid_terms FROM feespayments WHERE student_id='".(int)$student_id."' AND status=1");
            $prow = $pr ? mysqli_fetch_assoc($pr) : null; $paid_terms = isset($prow['paid_terms']) ? (int)$prow['paid_terms'] : 0;
        }

        // get terms to consider
        $terms = [];
        $tstmt = mysqli_prepare($con, "SELECT financialterm_id,year,term FROM financialterms WHERE year>=? AND term>=?");
        if($tstmt){
            mysqli_stmt_bind_param($tstmt,'ii',$joiningyear,$joiningterm);
            mysqli_stmt_execute($tstmt);
            $tr = mysqli_stmt_get_result($tstmt);
            while($tr && $trow = mysqli_fetch_assoc($tr)) $terms[] = $trow;
            mysqli_stmt_close($tstmt);
        } else {
            $tr = mysqli_query($con, "SELECT financialterm_id,year,term FROM financialterms WHERE year>='".(int)$joiningyear."' AND term>='".(int)$joiningterm."'");
            while($tr && $trow = mysqli_fetch_assoc($tr)) $terms[] = $trow;
        }

        if(empty($terms)){
            $balanceStatus = 'Yes';
        } else {
            if($paid_terms < count($terms)){
                $balanceStatus = 'Yes';
            } else {
                $totalpaid = 0;
                $totalexpected = 0;
                foreach($terms as $trow){
                    $financialterm_id = (int)$trow['financialterm_id'];
                    $term_year = $trow['year'];

                    // sum payments for this term
                    $sp = mysqli_prepare($con, "SELECT SUM(amount) as termpayment, class_id FROM feespayments WHERE student_id=? AND status=1 AND term_id=?");
                    if($sp){
                        mysqli_stmt_bind_param($sp,'ii',$student_id,$financialterm_id);
                        mysqli_stmt_execute($sp);
                        $spr = mysqli_stmt_get_result($sp);
                        $sprow = $spr ? mysqli_fetch_assoc($spr) : null;
                        mysqli_stmt_close($sp);
                    } else {
                        $spr = mysqli_query($con, "SELECT SUM(amount) as termpayment, class_id FROM feespayments WHERE student_id='".(int)$student_id."' AND status=1 AND term_id='".(int)$financialterm_id."'");
                        $sprow = $spr ? mysqli_fetch_assoc($spr) : null;
                    }
                    $termpayment = isset($sprow['termpayment']) ? (float)$sprow['termpayment'] : 0;
                    $class_id_for_fee = isset($sprow['class_id']) ? (int)$sprow['class_id'] : $class_id;

                    // fetch expected fee for class/year
                    $fee_amount = 0;
                    $fs = mysqli_prepare($con, "SELECT amount FROM schoolfees WHERE class_id=? AND year=? LIMIT 1");
                    if($fs){
                        mysqli_stmt_bind_param($fs,'ii',$class_id_for_fee,(int)$term_year);
                        mysqli_stmt_execute($fs);
                        $fsr = mysqli_stmt_get_result($fs);
                        $fsrow = $fsr ? mysqli_fetch_assoc($fsr) : null;
                        mysqli_stmt_close($fs);
                    } else {
                        $fsr = mysqli_query($con, "SELECT amount FROM schoolfees WHERE class_id='".(int)$class_id_for_fee."' AND year='".mysqli_real_escape_string($con,$term_year)."' LIMIT 1");
                        $fsrow = $fsr ? mysqli_fetch_assoc($fsr) : null;
                    }
                    $fee_amount = isset($fsrow['amount']) ? (float)$fsrow['amount'] : 0;

                    $totalpaid += $termpayment;
                    $totalexpected += $fee_amount;
                }
                $balance = $totalexpected - $totalpaid;
                $balanceStatus = $balance > 0 ? 'YES' : 'NO';
            }
        }

        echo '<tr class="gradeA">';
        echo '<td>' . htmlspecialchars($regnumber, ENT_QUOTES) . '</td>';
        echo '<td>' . htmlspecialchars($fullname, ENT_QUOTES) . '</td>';
        echo '<td>' . htmlspecialchars(trim($class_name . ' ' . $stream), ENT_QUOTES) . '</td>';
        echo '<td>' . htmlspecialchars($gender, ENT_QUOTES) . '</td>';
        echo '<td>' . htmlspecialchars($balanceStatus, ENT_QUOTES) . '</td>';
        echo '<td><a href="getinvoice?id=' . urlencode($student_id) . '" class="btn btn-info btn-xs"><i class="fa fa-print"></i> Get Invoice</a> ';
        echo '<a href="accountstudent?id=' . urlencode($student_id) . '" class="btn btn-success btn-xs"><i class="fa fa-user"></i> Details</a></td>';
        echo '</tr>';
    }
}

// close any outstanding statements (stmt closed earlier when used)
?>
            </tbody>
          </table>
        </div>
      </section>
    </div>
        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery-nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
