<?php
include 'includes/conn.php';

if (!isset($_SESSION)) {
  session_start();
}
$allowed_levels = array(1, 2, 3, 8, 10);
if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], $allowed_levels)) {
  header('Location: login.php');
  exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  echo '<div class="alert alert-danger">Invalid student id</div>';
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Student Profile</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
         <div class="col-lg-4">
                      <section class="panel">
                  
                          <div class="panel-body">
                                 <?php
                // fetch student via prepared statement
                $student = null;
                $stmt = mysqli_prepare($con, "SELECT * FROM students WHERE status = 1 AND student_id = ? LIMIT 1");
                if ($stmt) {
                    mysqli_stmt_bind_param($stmt, 'i', $id);
                    mysqli_stmt_execute($stmt);
                    $res = mysqli_stmt_get_result($stmt);
                    $student = $res ? mysqli_fetch_array($res) : null;
                    mysqli_stmt_close($stmt);
                } else {
                    $res = mysqli_query($con, "SELECT * FROM students WHERE status=1 AND student_id='" . (int)$id . "'");
                    $student = $res ? mysqli_fetch_array($res) : null;
                }

                if (!$student) {
                    echo '<div class="alert alert-danger">Student not found</div>';
                    exit;
                }

                $regnumber = $student['regnumber'] ?? '';
                $student_id = $student['student_id'] ?? '';
                $fullname = $student['fullname'] ?? '';
                $gender = $student['gender'] ?? '';
                $number = $student['number'] ?? '';
                $class_id = isset($student['class_id']) ? (int)$student['class_id'] : 0;
                $nationality = $student['nationality'] ?? '';
                $birthday = $student['birthday'] ?? '';
                $year = $student['joiningyear'] ?? '';
                $fathername = $student['fathername'] ?? '';
                $fatheroccupation = $student['fatheroccupation'] ?? '';
                $fatheremail = $student['fatheremail'] ?? '';
                $fatherphone = $student['fatherphone'] ?? '';
                $mothername = $student['mothername'] ?? '';
                $motheroccupation = $student['motheroccupation'] ?? '';
                $motheremail = $student['motheremail'] ?? '';
                $motherphone = $student['motherphone'] ?? '';
                $status = isset($student['status']) ? (int)$student['status'] : 0;
                $stream_id = isset($student['stream_id']) ? (int)$student['stream_id'] : 0;
                $ext = $student['ext'] ?? '';

                // get stream name
                $stream = '';
                $sstmt = mysqli_prepare($con, "SELECT stream FROM streams WHERE stream_id = ? LIMIT 1");
                if ($sstmt) {
                    mysqli_stmt_bind_param($sstmt, 'i', $stream_id);
                    mysqli_stmt_execute($sstmt);
                    $rs = mysqli_stmt_get_result($sstmt);
                    $r = $rs ? mysqli_fetch_array($rs) : null;
                    $stream = $r['stream'] ?? '';
                    mysqli_stmt_close($sstmt);
                } else {
                    $getstream = mysqli_query($con, "SELECT * FROM streams WHERE stream_id='" . (int)$stream_id . "'");
                    $roww = $getstream ? mysqli_fetch_array($getstream) : null;
                    $stream = $roww['stream'] ?? '';
                }
                                           ?>
                              <img src="<?php echo htmlspecialchars(BASE_URL, ENT_QUOTES);?>/images/students/<?php echo md5($id).'.'.htmlspecialchars($ext, ENT_QUOTES).'?'.time(); ?>" class="img img-responsive">
                          </div>
                          </section> 
        
                                         <section class="panel">
                    <header class="panel-heading">
                  Student Information
                   
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped">     
        <tbody>
         
                <tr class="gradeA">
                       <th>Full Name</th>
              <td><?php echo $fullname;?></td>
                  </tr>
                      <tr class="gradeA">
                        <th>Class</th>
                        <td>
                             <?php
                                      $getclass=  mysqli_query($con,"SELECT * FROM classes WHERE class_id='$class_id'");
                                            $row2=  mysqli_fetch_array($getclass);                        
                                           $class=$row2['class'];
                                           echo $class.' '.$stream;
                                    ?>
                        </td> 
            </tr>
              <tr class="gradeA">
                        <th>Student Number</th>
            <td><?php echo $regnumber; ?></td> 
            </tr>
              
                       <tr class="gradeA">
                             <th> Gender</th>
            <td><?php echo $gender?></td>
            </tr>
                    
        </tbody>
                        </table>
                                                     
                          </div>
                          </section>
                                     </div>
    <div class="col-lg-7">
        <?php
                      if($_SESSION['schoolsyslevel']==3){
                                            ?>
                    <a href="addfeespayment?id=<?php echo $id; ?>" class="btn btn-info btn-sm" ><i class="fa fa-money"></i> Add Fees Payment</a>
                         <a href="addfeesdiscount?id=<?php echo $id; ?>" class="btn btn-success btn-sm" ><i class="fa fa-arrow-down"></i> Add Fees Discount</a>
                    <a href="addlunchfeespayment?id=<?php echo $id; ?>" class="btn btn-danger btn-sm" ><i class="fa fa-money"></i> Add Lunch Fees Payment</a>               
                                           <?php }?>
                    <a href="feespaymentprint?id=<?php echo $id; ?>" class="btn btn-primary btn-sm" target="_blank"><i class="fa fa-print"></i> Print</a>
                    <section class="panel" style="margin-top:10px">
                    <header class="panel-heading">
                        Fees Payment Details               
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped" id="dynamic-table">     
                                                   <thead>
                                    <tr><th>Term & Year</th><th>Amount Paid</th><th>Discount (%)</th><th>Lunch Fees</th><th>Balance</th></tr>
                                </thead>
                                                  <tbody>
                                               <?php
                                                 $payments_sql = "SELECT term_id, class_id, SUM(amount) as totalamount FROM feespayments WHERE student_id='" . (int)$id . "' AND status=1 GROUP BY term_id, class_id";
                                                 $getpayments=  mysqli_query($con, $payments_sql);
                                                 if (!$getpayments || mysqli_num_rows($getpayments) < 1) {
                                                   echo '<tr><td colspan="5">No payments found for this student.';
                                                   if (isset($_GET['debug']) && $_GET['debug'] == '1') {
                                                     echo '<br/><small>SQL: ' . htmlspecialchars($payments_sql) . '</small>';
                                                     if ($getpayments) {
                                                       echo '<br/><small>Rows: ' . mysqli_num_rows($getpayments) . '</small>';
                                                     } else {
                                                       echo '<br/><small>Error: ' . htmlspecialchars(mysqli_error($con)) . '</small>';
                                                     }
                                                   }
                                                   echo '</td></tr>';
                                                 } else {
                                                 while ($row1 = mysqli_fetch_array($getpayments)) { 
//                                                   $feespayment_id=$row1['feespayment_id'];
                                                   $totalamount=$row1['totalamount'];
                                                   $class_id=$row1['class_id'];
                                                   $term_id=$row1['term_id'];
                                                 $terms=  mysqli_query($con,"SELECT  * FROM financialterms WHERE financialterm_id='$term_id'");
                           $row=  mysqli_fetch_array($terms);
                           $term=$row['term'];
                         $year=$row['year'];
                    $fees=  mysqli_query($con,"SELECT  * FROM schoolfees WHERE class_id='$class_id' ");
                                      $row3=  mysqli_fetch_array($fees);
                                      $feesamount=$row3['amount'];
                        $getdiscounts=  mysqli_query($con,"SELECT * FROM discounts WHERE student_id='$id' AND term_id='$term_id' AND status=1");
                        $row4=  mysqli_fetch_array($getdiscounts);
                        $discount=$row4['discount'];
                                                   ?>
                                 <tr>
                                     
                                     <td><?php echo 'Term '.$term.' '.$year; ?></td>
                                     <td><?php echo number_format($totalamount); ?></td>
                                     <td><?php echo $discount; ?></td>
                                     <td><?php 
                                     $checklunchfees=  mysqli_query($con, "SELECT * FROM lunchfeespayments WHERE status=1 AND student_id='$id' AND term_id='$term_id'") or die(mysqli_error($con));
                                     if(mysqli_num_rows($checklunchfees)>0){
                                         
                                     echo '<span class="text-success">PAID</span>';
                                     }else{
                                         echo '<span class="text-danger">UNPAID</span>';
                                     }
                                     ?></td>
                                     <td><?php 
                                     if(mysqli_num_rows($getdiscounts)>0){
                                         $discountamount=($discount/100)*$feesamount;
                                         $balance=$feesamount-$discountamount-$totalamount;
                                         
                                     }else{
                                         $balance=$feesamount-$totalamount;
                                     }
                                     echo number_format($balance); ?></td>
                                                                   </tr>                  
                                   
                                              <?php     } }
                                               ?>                    
                                                  </tbody>
                                              </table>
                                              </div>
                          </section>
      
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        
    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>
</body>
</html>
