<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

if (!canManageVendors($user_level)) {
    header('Location:login.php');
    exit();
}

$status_filter = $_GET['status'] ?? '';

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Accounts Payable</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-book"></i> Accounts Payable (Vendor Invoices)
                        </h4>
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    ' . htmlspecialchars($_SESSION['message']) . '
                                 </div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }
                        ?>
                        
                        <a href="addaccountspayable.php" class="btn btn-primary btn-sm margin-bottom-10">
                            <i class="fa fa-plus"></i> Record New Vendor Invoice
                        </a>
                        
                        <!-- Status Filter -->
                        <div class="margin-bottom-20">
                            <span class="label label-primary">Filter by Status:</span>
                            <a href="accountspayable.php" class="btn btn-default btn-sm">All</a>
                            <a href="accountspayable.php?status=Draft" class="btn btn-default btn-sm">Draft</a>
                            <a href="accountspayable.php?status=Approved" class="btn btn-default btn-sm">Approved</a>
                            <a href="accountspayable.php?status=Received" class="btn btn-default btn-sm">Received</a>
                            <a href="accountspayable.php?status=Paid" class="btn btn-info btn-sm">Paid</a>
                            <a href="accountspayable.php?status=Overdue" class="btn btn-danger btn-sm">Overdue</a>
                        </div>
                        
                        <table class="display table table-striped" id="dynamic-table">
                            <thead>
                                <tr>
                                    <th>Invoice #</th>
                                    <th>Vendor</th>
                                    <th>Invoice Date</th>
                                    <th>Due Date</th>
                                    <th>Amount</th>
                                    <th>Paid</th>
                                    <th>Outstanding</th>
                                    <th>Status</th>
                                    <th>Days Overdue</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = "SELECT ap.*, v.vendor_name FROM accounts_payable ap 
                                         LEFT JOIN vendors v ON ap.vendor_id = v.vendor_id 
                                         WHERE 1=1";
                                
                                if ($status_filter) {
                                    $status_filter = mysqli_real_escape_string($con, $status_filter);
                                    $query .= " AND ap.status = '$status_filter'";
                                }
                                
                                $query .= " ORDER BY ap.due_date ASC";
                                
                                $result = mysqli_query($con, $query);
                                $total_outstanding = 0;
                                
                                if ($result && mysqli_num_rows($result) > 0) {
                                    while ($row = mysqli_fetch_array($result)) {
                                        $outstanding = $row['amount'] - $row['amount_paid'];
                                        $total_outstanding += $outstanding;
                                        
                                        $days_overdue = 0;
                                        if ($row['status'] != 'Paid' && strtotime($row['due_date']) < time()) {
                                            $days_overdue = floor((time() - strtotime($row['due_date'])) / 86400);
                                        }
                                        
                                        $status_class = 'label-warning';
                                        if ($row['status'] == 'Paid') $status_class = 'label-success';
                                        elseif ($row['status'] == 'Cancelled') $status_class = 'label-danger';
                                        
                                        echo '<tr ' . ($days_overdue > 0 ? 'class="danger"' : '') . '>
                                            <td><strong>' . htmlspecialchars($row['invoice_number']) . '</strong></td>
                                            <td>' . htmlspecialchars($row['vendor_name'] ?? '-') . '</td>
                                            <td>' . date('d/M/Y', strtotime($row['invoice_date'])) . '</td>
                                            <td>' . date('d/M/Y', strtotime($row['due_date'])) . '</td>
                                            <td>' . number_format($row['amount'], 2) . '</td>
                                            <td>' . number_format($row['amount_paid'], 2) . '</td>
                                            <td><strong>' . number_format($outstanding, 2) . '</strong></td>
                                            <td><span class="label ' . $status_class . '">' . htmlspecialchars($row['status']) . '</span></td>
                                            <td>' . ($days_overdue > 0 ? '<span class="label label-danger">' . $days_overdue . ' days</span>' : '-') . '</td>
                                            <td>
                                                <a href="editaccountspayable.php?id=' . $row['payable_id'] . '" class="btn btn-info btn-xs"><i class="fa fa-edit"></i> Edit</a>
                                                <a href="paymentschedule.php?payable_id=' . $row['payable_id'] . '" class="btn btn-success btn-xs"><i class="fa fa-calendar"></i> Payments</a>';
                                        if (canApprovePayments($_SESSION['schoolsyslevel']) && $row['status'] == 'Approved') {
                                            echo '<a href="markpayable-paid.php?id=' . $row['payable_id'] . '" class="btn btn-primary btn-xs"><i class="fa fa-check"></i> Mark Paid</a>';
                                        }
                                        echo '</td>
                                        </tr>';
                                    }
                                } else {
                                    echo '<tr><td colspan="10" class="text-center">No vendor invoices found</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                        
                        <div class="row margin-top-20">
                            <div class="col-md-6">
                                <div class="panel panel-primary">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Total Outstanding Payables</h4>
                                    </div>
                                    <div class="panel-body">
                                        <h2 class="text-danger"><?php echo number_format($total_outstanding, 2); ?></h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
