<?php
include 'includes/conn.php';

// ensure session started and permission check
if (!isset($_SESSION)) {
        session_start();
}
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Allow Super Admin (1), Principal (2), Finance/Admin (3), Finance Manager (8), HR Admin Director (9), Accountant (10)
if ($user_level === 0 || !in_array($user_level, [1,2,3,8,9,10], true)) {
        header('Location: login.php');
        exit;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Accounts </title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
             <div class="row">
          <div class="col-lg-6">
                      <section class="panel">
                    <header class="panel-heading">
                   Add Account
                    </header>
                          <div class="panel-body">
                          <?php
        if (isset($_POST['updatesubmit'])) {
            $classcategory2 = isset($_POST['classcategory2']) ? trim($_POST['classcategory2']) : '';
            $effortrank2 = isset($_POST['effortrank2']) ? trim($_POST['effortrank2']) : '';
            $effortdesc2 = isset($_POST['effortdesc2']) ? (int)$_POST['effortdesc2'] : 0;
            $std = isset($_POST['std']) ? (int)$_POST['std'] : 0;
            $errors = [];

            $acc_lenght = mysqli_query($con, "SELECT length FROM account_length WHERE status=1 LIMIT 1");
            $rowww = $acc_lenght ? mysqli_fetch_array($acc_lenght) : null;
            $length = $rowww['length'] ?? 0;

            if ($classcategory2 === '' || $effortrank2 === '' || $effortdesc2 === 0) {
                $errors[] = 'Enter All Fields To Proceed';
            }

            if ($length > 0 && strlen((string)$effortrank2) != (int)$length) {
                $errors[] = 'Account Number Must Be ' . (int)$length . ' Digits';
            }

            if (!empty($errors)) {
                foreach ($errors as $error) {
                    echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                }
            } else {
                $updStmt = mysqli_prepare($con, "UPDATE accounts SET title = ?, acc_number = ?, type_id = ? WHERE id = ?");
                if ($updStmt) {
                    mysqli_stmt_bind_param($updStmt, 'ssii', $classcategory2, $effortrank2, $effortdesc2, $std);
                    mysqli_stmt_execute($updStmt);
                    mysqli_stmt_close($updStmt);
                } else {
                    mysqli_query($con, "UPDATE accounts SET title='" . mysqli_real_escape_string($con, $classcategory2) . "', acc_number='" . mysqli_real_escape_string($con, $effortrank2) . "', type_id='" . (int)$effortdesc2 . "' WHERE id='" . (int)$std . "'");
                }

                echo '<div class="alert alert-success"><i class="fa fa-check"></i>Account successfully Updated</div>';
            }
        }
        ?>
                                                   <?php
                                if (isset($_POST['submit'])) {
                                    $effortname = isset($_POST['accname']) ? trim($_POST['accname']) : '';
                                    $effortrank = isset($_POST['accnum']) ? trim($_POST['accnum']) : '';
                                    $effortdesc = isset($_POST['accdesc']) ? (int)$_POST['accdesc'] : 0;
                                    $errors = [];

                                    // check uniqueness using prepared statements where possible
                                    $checkName = null;
                                    $checkNum = null;
                                    $checkStmt = mysqli_prepare($con, "SELECT id FROM accounts WHERE title = ? LIMIT 1");
                                    if ($checkStmt) {
                                        mysqli_stmt_bind_param($checkStmt, 's', $effortname);
                                        mysqli_stmt_execute($checkStmt);
                                        mysqli_stmt_store_result($checkStmt);
                                        if (mysqli_stmt_num_rows($checkStmt) > 0) {
                                            $errors[] = 'Account Already Exists';
                                        }
                                        mysqli_stmt_close($checkStmt);
                                    } else {
                                        $check2 = mysqli_query($con, "SELECT * FROM accounts WHERE title='" . mysqli_real_escape_string($con, $effortname) . "'");
                                        if ($check2 && mysqli_num_rows($check2) > 0) {
                                            $errors[] = 'Account Already Exists';
                                        }
                                    }

                                    $checkStmt2 = mysqli_prepare($con, "SELECT id FROM accounts WHERE acc_number = ? LIMIT 1");
                                    if ($checkStmt2) {
                                        mysqli_stmt_bind_param($checkStmt2, 's', $effortrank);
                                        mysqli_stmt_execute($checkStmt2);
                                        mysqli_stmt_store_result($checkStmt2);
                                        if (mysqli_stmt_num_rows($checkStmt2) > 0) {
                                            $errors[] = 'Account Number Already Exists';
                                        }
                                        mysqli_stmt_close($checkStmt2);
                                    } else {
                                        $check3 = mysqli_query($con, "SELECT * FROM accounts WHERE acc_number='" . mysqli_real_escape_string($con, $effortrank) . "'");
                                        if ($check3 && mysqli_num_rows($check3) > 0) {
                                            $errors[] = 'Account Number Already Exists';
                                        }
                                    }

                                    $acc_lenght = mysqli_query($con, "SELECT length FROM account_length WHERE status=1 LIMIT 1");
                                    $rowww = $acc_lenght ? mysqli_fetch_array($acc_lenght) : null;
                                    $length = $rowww['length'] ?? 0;

                                    if ($effortname === '' || $effortrank === '' || $effortdesc === 0) {
                                        $errors[] = 'Enter All Fields To Proceed';
                                    }

                                    if ($length > 0 && strlen((string)$effortrank) != (int)$length) {
                                        $errors[] = 'Account Number Must Be ' . (int)$length . ' Digits';
                                    }

                                    if (!empty($errors)) {
                                        foreach ($errors as $error) {
                                            echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                                        }
                                    } else {
                                        $insStmt = mysqli_prepare($con, "INSERT INTO accounts (title, acc_number, type_id, status, creator, created_at) VALUES (?, ?, ?, 1, ?, UNIX_TIMESTAMP())");
                                        if ($insStmt) {
                                            $creator = isset($_SESSION['schoolsys']) ? $_SESSION['schoolsys'] : '';
                                            mysqli_stmt_bind_param($insStmt, 'ssis', $effortname, $effortrank, $effortdesc, $creator);
                                            mysqli_stmt_execute($insStmt);
                                            mysqli_stmt_close($insStmt);
                                        } else {
                                            mysqli_query($con, "INSERT INTO accounts(title,acc_number,type_id,status,creator,created_at) VALUES('" . mysqli_real_escape_string($con, $effortname) . "','" . mysqli_real_escape_string($con, $effortrank) . "','" . (int)$effortdesc . "','1','" . mysqli_real_escape_string($con, isset($_SESSION['schoolsys']) ? $_SESSION['schoolsys'] : '') . "',UNIX_TIMESTAMP())");
                                        }

                                        echo '<div class="alert alert-success"><i class="fa fa-check"></i> Account Successfully Added</div>';
                                    }
                                }
	
                           ?>
  <form method="post" class="form" action=''  name="form" enctype="multipart/form-data">
                                <div class="form-group"><label class="control-label">Account Title</label>
                               <input type="text" class="form-control" name='accname' placeholder="Enter Account Title" required='required'>
                                </div>
                                <div class="form-group"><label class="control-label">Account Number</label>
                               <input type="number" class="form-control" name='accnum' placeholder="Enter Account Number" required='required'>
                                </div>
                                <div class="form-group"><label class="control-label">Account Type</label>
                                <select class="form-control" name="accdesc" required='required'>
                                <option value="">Select Account Type</option>
                                <?php 
                                    $acctype = mysqli_query($con,"SELECT * FROM account_types WHERE status='1'");
                                    while ($row = mysqli_fetch_array($acctype)) {
                                        echo '<option value="'.$row['id'].'">'.$row['type_name'].'</option>';
                                    }
                                ?>
                                </select>
                                </div>
                               <div class="form-group">
                 <button class="btn btn-primary" name="submit" type="submit">Add</button>
                                                               </div>
                          </form >
                          </div>
                      </section>
                          </div>
                          <div class="col-lg-6">
                      <section class="panel">
                    <header class="panel-heading">
                    Accounts
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped">
        <thead>
        <tr>
                   <th>Account Title</th>
                        <th>Account Number</th>
                                            <th>Action</th>
                  </tr>
        </thead>
        <tbody>
               <?php
                             $getclasses=mysqli_query($con,"SELECT * FROM accounts WHERE status=1 ");
                             if (mysqli_num_rows($getclasses)==0) {
                                 echo '<tr><td colspan="3"><div class="alert alert-danger">No Accounts Found</div></td></tr>';
                             }else{
                            while ($row = mysqli_fetch_array($getclasses)) {
                                    $class_id=$row['id'];
                                    $class=$row['title'];  
                                    $rank=$row['acc_number'];
                                    $desc=$row['type_id'];                                              
                                                              ?>
                <tr class="gradeA">
               <td><?php echo $class; ?></td>
               <td><?php echo $rank; ?></td>
                               
                                   <td>
                                           <?php
                                      if(($_SESSION['schoolsyslevel']==1)){
                                   ?>
                                       <a data-toggle="modal" href="#modal-form<?php echo $class_id; ?>" class="btn btn-xs btn-success"><i class="fa fa-edit"></i> Edit </a>
                                       <!-- <a href="streams?id=<?php echo $class_id; ?>" class="btn btn-xs btn-primary"><i class="fa fa-building-o"></i> Streams</a> -->
                                          <a href="hideacctypes?id=<?php echo $class_id; ?>&&del=acc" class="btn btn-xs btn-danger" onclick="return confirm_delete<?php echo $class_id;?>()"><i class="fa fa-trash-o"></i>Remove</a>
                                        <?php } ?>
                                       <!-- <a href="class?id=<?php echo $class_id; ?>" class="btn btn-xs btn-info"><i class="fa fa-group"></i> Students</a>                                     -->
                                   </td>                                     
                                  <script type="text/javascript">
function confirm_delete<?php echo $class_id; ?>() {
  return confirm('You are about To Remove this Item.Are you sure you want to proceed?');
}
</script>              
                </tr>
                <div id="modal-form<?php echo $class_id; ?>" class="modal fade" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <h3 class="m-t-none m-b">Edit  <?php echo $class; ?></h3>
                                                    <form role="form" method="POST" action="" enctype="multipart/form-data">
                                                    <input  type="hidden" value="<?php echo $class_id;?>" name="std" >
                                                          <div class="form-group">
                                                                    <label for="username" class="control-label">Account Title</label>
                                                                    <input type="text" class="form-control" name='classcategory2'
                                                                    value="<?php echo $class; ?>"
                                                                    placeholder="Enter Effort Name" required='required'>
                                                          </div>
                                                          <div class="form-group">
                                                                    <label for="username" class="control-label">Account Number</label>
                                                                    <input type="text" class="form-control" name='effortrank2'
                                                                    value="<?php echo $rank; ?>"
                                                                    placeholder="Enter Effort Name" required='required'>
                                                          </div>
                                                          <div class="form-group">
                                                                    <label for="username" class="control-label">Effort Description</label>
                                                                    <select class="form-control" name="effortdesc2" required='required'>
                                                                    <option value="">Select Account Type</option>
                                                                    <?php 
                                                                        $acctype = mysqli_query($con,"SELECT * FROM account_types WHERE status='1'");
                                                                        while ($row = mysqli_fetch_array($acctype)) {
                                                                    ?>
                                                                    <option value="<?php echo $row['id']; ?>" <?php if($desc==$row['id']){echo 'selected';} ?>><?php echo $row['type_name']; ?></option>
                                                                    <?php } ?>
                                                                    </select>
                                                          </div>
                                                          <button class="btn btn-sm btn-primary pull-right m-t-n-xs" type="submit" name="updatesubmit"><strong>Update</strong></button>
                                                    </form>
                                                </div>
                                                
                                        </div>
                                    </div>
                                    </div>
                                </div>
            </div>
            <?php } }?>
        </tbody>
      

                        </table>
                          </div>
                          </section>
                          </div>
      
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
