<?php
include 'includes/conn.php';

// ensure session is started and user has required level
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Allow Super Admin (1), Principal (2) and Accounts Management (3)
if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], [1, 2, 3], true)) {
    header('Location: login.php');
    exit;
}

// get account length (prepared)
$accountlength = null;
$stmt = mysqli_prepare($con, "SELECT id, length FROM account_length WHERE status = 1 LIMIT 1");
if ($stmt) {
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $accountlength = $res;
    mysqli_stmt_close($stmt);
} else {
    // fallback to simple query if prepare fails; do not expose DB errors to users
    $accountlength = mysqli_query($con, "SELECT id, length FROM account_length WHERE status=1 LIMIT 1");
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Account Length </title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
             <div class="row">
          <div class="col-lg-6">
                      <section class="panel">
                    <header class="panel-heading">
                    Account Length
                    </header>
                          <div class="panel-body">
                          <?php
        if (isset($_POST['update_lenght'])) {
            $classcategory2 = isset($_POST['accountlengthupdate']) ? trim($_POST['accountlengthupdate']) : '';
            $std = isset($_POST['accountlengthid']) ? (int)$_POST['accountlengthid'] : 0;
            $errors = [];

            if ($classcategory2 === '') {
                $errors[] = 'Enter All Fields To Proceed';
            }

            // check exists using prepared
            $exists = false;
            $chkStmt = mysqli_prepare($con, "SELECT id FROM account_length WHERE id = ? LIMIT 1");
            if ($chkStmt) {
                mysqli_stmt_bind_param($chkStmt, 'i', $std);
                mysqli_stmt_execute($chkStmt);
                mysqli_stmt_store_result($chkStmt);
                if (mysqli_stmt_num_rows($chkStmt) > 0) {
                    $exists = true;
                }
                mysqli_stmt_close($chkStmt);
            } else {
                $check2 = mysqli_query($con, "SELECT id FROM account_length WHERE id='" . (int)$std . "'");
                if ($check2 && mysqli_num_rows($check2) > 0) {
                    $exists = true;
                }
            }

            if (!$exists) {
                $errors[] = 'Account Length Does not Exist';
            }

            if (!empty($errors)) {
                foreach ($errors as $error) {
                    echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                }
            } else {
                $updStmt = mysqli_prepare($con, "UPDATE account_length SET length = ? WHERE id = ?");
                if ($updStmt) {
                    $lenCast = (int)$classcategory2;
                    mysqli_stmt_bind_param($updStmt, 'ii', $lenCast, $std);
                    mysqli_stmt_execute($updStmt);
                    mysqli_stmt_close($updStmt);
                } else {
                    mysqli_query($con, "UPDATE account_length SET length='" . (int)$classcategory2 . "' WHERE id='" . (int)$std . "'");
                }

                echo '<div class="alert alert-success"><i class="fa fa-check"></i>Account Length successfully Updated</div>';
                // refresh page
                echo '<meta http-equiv="refresh" content="1;url=account">';
            }
        }
        ?>
                                                   <?php
                                if (isset($_POST['submit'])) {
                                    $lenght = isset($_POST['accountlength']) ? (int)trim($_POST['accountlength']) : 0;
                                    $errors = [];

                                    // check if account length is not 0
                                    if ($lenght === 0) {
                                        $errors[] = 'Account Length Cannot Be 0';
                                    }

                                    if (!empty($errors)) {
                                        foreach ($errors as $error) {
                                            echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                                        }
                                    } else {
                                        // insert using prepared statement
                                        $insStmt = mysqli_prepare($con, "INSERT INTO account_length (length, creator, status, created_at) VALUES (?, ?, 1, UNIX_TIMESTAMP())");
                                        if ($insStmt) {
                                            $creator = isset($_SESSION['schoolsys']) ? $_SESSION['schoolsys'] : '';
                                            mysqli_stmt_bind_param($insStmt, 'is', $lenght, $creator);
                                            mysqli_stmt_execute($insStmt);
                                            mysqli_stmt_close($insStmt);
                                        } else {
                                            mysqli_query($con, "INSERT INTO account_length(length,creator,status,created_at) VALUES('" . (int)$lenght . "','" . mysqli_real_escape_string($con, isset($_SESSION['schoolsys']) ? $_SESSION['schoolsys'] : '') . "','1', UNIX_TIMESTAMP() )");
                                        }

                                        echo '<div class="alert alert-success"><i class="fa fa-check"></i> Account Length Successfully Added</div>';
                                        // refresh page
                                        echo '<meta http-equiv="refresh" content="1;url=account">';
                                    }
                                }
	
                           ?>
                            <form method="post" class="form" action=''  name="form" enctype="multipart/form-data">
                           <?php 
                                if (mysqli_num_rows($accountlength)==0) {
                                    
                           ?>
 
                                <div class="form-group"><label class="control-label">Account Length</label>
                               <input type="number" class="form-control" name='accountlength'  placeholder="Enter Account Length" required='required'>
                                </div>
                                
                               <div class="form-group">
                 <button class="btn btn-primary" name="submit" type="submit">Add</button>
                                                               </div>
                         
                          <?php
                                }else{
                                    $row = mysqli_fetch_array($accountlength);
                                    $accolength=$row['length'];
                                    $accountlengthid=$row['id'];
                            ?>
                            <input type="hidden" name="accountlengthid" value="<?php echo $accountlengthid; ?>">
                             <div class="form-group"><label class="control-label">Account Length</label>
                               <input type="number" value="<?php echo $accolength; ?>" class="form-control" name='accountlengthupdate' placeholder="Enter Account Length" required='required'>
                                </div>
                                
                               <div class="form-group">
                 <button class="btn btn-primary" name="update_lenght" type="submit">Update</button>
                                                               </div>
                                                               <?php
                                } ?>
                            </form >
                            
                          </div>
                      </section>
                          </div>
                          
      
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
