<?php
include 'includes/conn.php';
// Require admin
if (empty($_SESSION['schoolsys']) || ((int)($_SESSION['schoolsyslevel'] ?? 0) !== 1)) {
    header('Location: login');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ThemeBucket">
    <link rel="shortcut icon" href="#" type="image/png">

    <title>School Academic Years </title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
    <section>
        <?php include 'includes/header.php'; ?>
        <section class="wrapper">
            <div class="row">
                <div class="col-lg-8">
                    <section class="panel">
                        <header class="panel-heading">
                            School Academic Years
                        </header>
                        <div class="panel-body">
                            <?php
                            // Use a prepared statement and order results alphabetically by fyear
                            $terms = [];
                            $stmt = mysqli_prepare($con, "SELECT fyear_id, fyear, `start`, `end`, status FROM financialyears WHERE status = 1 ORDER BY fyear ASC");
                            if ($stmt) {
                                mysqli_stmt_execute($stmt);
                                $res = mysqli_stmt_get_result($stmt);
                                if ($res) {
                                    while ($r = mysqli_fetch_assoc($res)) {
                                        $terms[] = $r;
                                    }
                                }
                                mysqli_stmt_close($stmt);
                            }

                            if (count($terms) > 0) {
                            ?>
                                <table class="display table  table-striped" id="dynamic-table">
                                    <thead>
                                        <tr>
                                            <th>Start Year</th>
                                            <th>End Year</th>
                                            <?php
                                            if ($_SESSION['schoolsyslevel'] == 1) {
                                            ?>
                                                <th>Action</th>
                                            <?php } ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach ($terms as $row) {
                                            $financialterm_id = (int)($row['fyear_id'] ?? 0);
                                            $fyear = $row['fyear'] ?? '';
                                            $term = $row['start'] ?? '';
                                            $year = $row['end'] ?? '';
                                            $status = (int)($row['status'] ?? 0);
                                        ?>

                                            <tr class="gradeA">
                                                <td><?php echo htmlspecialchars((string)$term, ENT_QUOTES); ?></td>
                                                <td><?php echo htmlspecialchars((string)$year, ENT_QUOTES); ?></td>
                                                <?php
                                                if ($_SESSION['schoolsyslevel'] == 1) {
                                                ?>

                                                    <td>
                                                        <a href="editacademic?id=<?php echo $financialterm_id; ?>" class="btn btn-info  btn-xs">Edit <i class="fa fa-edit"></i></a>
                                                        <a href="removeyear?id=<?php echo $financialterm_id; ?>&amp;status=<?php echo $status; ?>" class="btn btn-danger  btn-xs" onclick="return confirm_delete<?php echo $financialterm_id; ?>()">Delete <i class="fa fa-trash-o"></i></a>

                                                        <script type="text/javascript">
                                                            function confirm_delete<?php echo $financialterm_id; ?>() {
                                                                return confirm('You are about To Remove this Year. Are you sure you want to proceed?');
                                                            }
                                                        </script>
                                                    </td>
                                                <?php } ?>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            <?php } ?>
                        </div>
                </div>

            </div>


            </div>
            <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->

        <!--footer section end-->


        </div>
        <!-- main content end-->
    </section>

    <!-- Placed js at the end of the document so the pages load faster -->
    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/modernizr.min.js"></script>
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
    <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
    <script src="js/dynamic_table_init.js"></script>
    <!--common scripts for all pages-->
    <script src="js/scripts.js"></script>

</body>

</html>