<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
  header('Location: login.php');
  exit;
}
$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($id <= 0) {
  header('Location: weeklyplans.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="keywords" content="admin, dashboard, bootstrap, template, flat, modern, theme, responsive, fluid, retina, backend, html5, css, css3">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Subject Weekly Plan</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/prettyphoto/css/prettyPhoto.css" type="text/css" media="screen" title="prettyPhoto main stylesheet" charset="utf-8" />
  <script src='<?php echo BASE_URL; ?>/js/fullcalendar/moment.min.js'></script>

</head>

<body class="sticky-header">

  <section>
    <?php include 'includes/header.php'; ?>


    <!--body wrapper start-->
    <div class="wrapper">
      <div class="row">

        <div class="col-lg-6">
          <?php
          $weeklyplans = mysqli_query($con, "SELECT * FROM weeklyplans WHERE weeklyplan_id={$id} AND status=1");
          if (!$weeklyplans) {
            header('Location: weeklyplans.php');
            exit;
          }
          $row = mysqli_fetch_assoc($weeklyplans);
          if (!$row) {
            header('Location: weeklyplans.php');
            exit;
          }
          $weeklyplan_id = (int) ($row['weeklyplan_id'] ?? 0);
          $startdate = isset($row['startdate']) ? (int) $row['startdate'] : 0;
          $teacher_id = (int) ($row['teacher_id'] ?? 0);
          $enddate = isset($row['enddate']) ? (int) $row['enddate'] : 0;
          $class_sub_id = (int) ($row['class_sub_id'] ?? 0);
          $bookpages = $row['bookpages'] ?? '';
          $periodsperweek = $row['periodsperweek'] ?? '';
          $year = $row['year'] ?? '';
          $term_value = (int) ($row['term'] ?? 0);
          $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects WHERE class_sub_id={$class_sub_id}");
          $row1 = $class_subjects ? mysqli_fetch_assoc($class_subjects) : null;
          $class_id = (int) ($row1['class_id'] ?? 0);
          $subject_id = (int) ($row1['subject_id'] ?? 0);
          $getclasses = mysqli_query($con, "SELECT * FROM classes WHERE class_id={$class_id}");
          $row2 = $getclasses ? mysqli_fetch_assoc($getclasses) : null;
          $class = $row2['class'] ?? '';
          $category_id = $row2['category_id'] ?? 0;
          $getsubjects = mysqli_query($con, "SELECT * FROM subjects WHERE subject_id={$subject_id}");
          $row3 = $getsubjects ? mysqli_fetch_assoc($getsubjects) : null;
          $subject = $row3['subject'] ?? '';
          $terms = mysqli_query($con, "SELECT * FROM financialterms WHERE status=1 AND financialterm_id={$term_value}");
          $row2 = $terms ? mysqli_fetch_assoc($terms) : null;
          $term = $row2['term'] ?? '';
          $year = $row2['year'] ?? '';

          ?>
          <section class="panel">
            <header class="panel-heading">
              <?php echo htmlspecialchars($subject . ':' . $class . ' Week Plan'); ?>
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table">

                <tbody>

                  <tr class="gradeA">
                    <th>Week Start</th>
                    <td><?php echo htmlspecialchars(date('d/M/Y', $startdate)); ?></td>
                  </tr>
                  <tr class="gradeA">
                    <th>Week End</th>
                    <td><?php echo htmlspecialchars(date('d/M/Y', $enddate)); ?></td>
                  </tr>
                  <?php
                  if ($category_id == 3) { ?>
                    <tr class="gradeA">
                      <th>Book Pages</th>
                      <td><?php echo htmlspecialchars($bookpages); ?></td>
                    </tr>
                  <?php } else { ?>
                    <tr class="gradeA">
                      <th>Periods per Week</th>
                      <td><?php echo htmlspecialchars($periodsperweek); ?></td>
                    </tr>
                    <tr class="gradeA">
                      <th>Year</th>
                      <td><?php echo htmlspecialchars($year); ?></td>
                    </tr>
                  <?php } ?>
                  <tr class="gradeA">
                    <th> Term</th>
                    <td><?php echo htmlspecialchars($term); ?></td>
                  </tr>
                </tbody>
              </table>

            </div>
          </section>

        </div>

      </div>
      <div class="row">

        <div class="col-lg-10">
          <h2>Daily Lesson Plans</h2>
          <?php
          $lessonplans = mysqli_query($con, "SELECT * FROM lessonplans WHERE weeklyplan_id={$id} AND status=1 ORDER BY lessonplan_id DESC");
          if ($lessonplans) {
          while ($row = mysqli_fetch_assoc($lessonplans)) {
            $period = $row['period'] ?? '';
            $date = isset($row['date']) ? strtotime($row['date']) : 0;
            $pagenumbers = $row['pagenumbers'] ?? '';
            $objectives = $row['objectives'] ?? '';
            $topictoday = $row['topictoday'] ?? '';
            $previouslesson = $row['previouslesson'] ?? '';
            $lessonintroduction = $row['lessonintroduction'] ?? '';
            $newlesson = $row['newlesson'] ?? '';
            $guidedpractice = $row['guidedpractice'] ?? '';
            $lessonreview = $row['lessonreview'] ?? '';
            $individualpractice = $row['individualpractice'] ?? '';
            $teachingaids = $row['teachingaids'] ?? '';
          ?>
            <section class="panel">
              <header class="panel-heading">
                Six Lesson Plan Steps for <?php echo htmlspecialchars(date('d/M/Y', $date)); ?>
              </header>
              <div class="panel-body">
                <table class="display table  table-striped" id="dynamic-table">

                  <tbody>

                    <tr class="gradeA">
                      <th>Period</th>
                        <td><?php echo htmlspecialchars($period); ?></td>
                    </tr>
                    <tr class="gradeA">
                      <th>Page Numbers</th>
                        <td><?php echo htmlspecialchars($pagenumbers); ?></td>
                    </tr>
                    <tr class="gradeA">
                      <th>Objectives</th>
                        <td><?php echo htmlspecialchars($objectives); ?></td>
                    </tr>
                    <tr class="gradeA">
                      <th> Topic of Today's Lesson</th>
                        <td><?php echo htmlspecialchars($topictoday); ?></td>
                    </tr>
                    <tr class="gradeA">
                      <th> Review of the previous lesson</th>
                        <td><?php echo htmlspecialchars($previouslesson); ?></td>
                    </tr>
                    <tr class="gradeA">
                      <th> Introduction of the new Lesson</th>
                        <td><?php echo htmlspecialchars($lessonintroduction); ?></td>
                    </tr>
                    <tr class="gradeA">
                      <th> New Lesson</th>
                        <td><?php echo htmlspecialchars($newlesson); ?></td>
                    </tr>
                    <tr class="gradeA">
                      <th> Review of the Lesson</th>
                        <td><?php echo htmlspecialchars($lessonreview); ?></td>
                    </tr>
                    <tr class="gradeA">
                      <th>Individual Practice</th>
                        <td><?php echo htmlspecialchars($individualpractice); ?></td>
                    </tr>
                    <?php
                    if ($category_id == 3) { ?>
                      <tr class="gradeA">
                        <th> Guided Practice</th>
                          <td><?php echo htmlspecialchars($guidedpractice); ?></td>
                      </tr>
                      <tr class="gradeA">
                        <th>Teaching Aids used in the lesson</th>
                          <td><?php echo htmlspecialchars($teachingaids); ?></td>
                      </tr>
                    <?php } ?>
                  </tbody>
                </table>
              </div>
            </section>
            <?php } } ?>
        </div>

      </div>

    </div>
    <!-- main content end-->
  </section>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

</body>

</html>