<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
  header('Location: login.php');
  exit;
}

$classRaw = isset($_GET['class']) ? trim($_GET['class']) : '';
if ($classRaw === '') {
  header('Location: classes.php');
  exit;
}
$split = explode('_', $classRaw);
$class_id = isset($split[0]) ? (int) $split[0] : 0;
$stream_id = isset($split[1]) ? (int) $split[1] : 0;

$className = '';
$getclass = mysqli_query($con, "SELECT * FROM classes WHERE class_id={$class_id}");
if ($getclass) {
  $row2 = mysqli_fetch_assoc($getclass);
  $className = $row2['class'] ?? '';
}
$stream = '';
$getstream = mysqli_query($con, "SELECT * FROM streams WHERE stream_id={$stream_id}");
if ($getstream) {
  $row = mysqli_fetch_assoc($getstream);
  $stream = $row['stream'] ?? '';
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title><?php echo htmlspecialchars($className . ' ' . $stream); ?> TimeTable</title>
  <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-12">
          <section class="panel">
            <header class="panel-heading">
              <?php echo $class . ' ' . $stream; ?> TimeTable
              <a href="printtimetable?class=<?php echo $class_id . '_' . $stream_id; ?>" class="btn  btn-info pull-right" target="_blank">Print</a>
            </header>
            <div class="panel-body">
              <?php
              // Get all unique time slots for this class
              $time_slots_query = mysqli_query($con, "SELECT DISTINCT starttime, endtime FROM timetables WHERE class_id={$class_id} AND stream_id={$stream_id} ORDER BY starttime");

              // Get all days
              $days_query = mysqli_query($con, "SELECT * FROM days");
              $days = array();
              if ($days_query) {
                while ($day_row = mysqli_fetch_assoc($days_query)) {
                  $days[] = $day_row['short'] ?? '';
                }
              }
              ?>

              <div class="table-responsive">
                <table class="table table-bordered table-striped">
                  <thead>
                    <tr>
                      <th>Time</th>
                      <?php foreach ($days as $day): ?>
                        <th><?php echo strtoupper($day); ?></th>
                      <?php endforeach; ?>
                    </tr>
                  </thead>
                  <tbody>
                    <?php while ($time_slot = mysqli_fetch_array($time_slots_query)): ?>
                      <tr>
                          <td><?php echo htmlspecialchars(($time_slot['starttime'] ?? '') . ' - ' . ($time_slot['endtime'] ?? '')); ?></td>
                          <?php foreach ($days as $day): ?>
                            <td>
                              <?php
                              $starttime = $time_slot['starttime'] ?? '';
                              $endtime = $time_slot['endtime'] ?? '';
                              $subject_query = mysqli_query($con, "SELECT t.*, cs.class_sub_id, s.subject 
                                                                FROM timetables t 
                                                                LEFT JOIN class_subjects cs ON t.activity = cs.class_sub_id 
                                                                LEFT JOIN subjects s ON cs.subject_id = s.subject_id 
                                                                WHERE t.class_id={$class_id} 
                                                                AND t.stream_id={$stream_id} 
                                                                AND t.day='{$day}' 
                                                                AND t.starttime='{$starttime}' 
                                                                AND t.endtime='{$endtime}'");

                              if ($subject_query && mysqli_num_rows($subject_query) > 0) {
                                $subject_row = mysqli_fetch_assoc($subject_query);
                                if (!empty($subject_row['subject'])) {
                                  echo htmlspecialchars($subject_row['subject']);
                                } else {
                                  echo htmlspecialchars($subject_row['activity'] ?? '-');
                                }
                              } else {
                                echo '-';
                              }
                              ?>
                            </td>
                          <?php endforeach; ?>
                        </tr>
                    <?php endwhile; ?>
                  </tbody>
                </table>
              </div>

              <?php if ($_SESSION['schoolsyslevel'] == 1): ?>
                <div class="text-center" style="margin-top: 20px;">
                  <a href="addtimetable?cl=<?php echo $class_id; ?>&&st=<?php echo $stream_id; ?>" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Add/Edit Timetable
                  </a>
                </div>
              <?php endif; ?>

            </div>
          </section>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>

  <!-- Placed js at the end of the document so the pages load faster -->
  <script src="js/jquery-1.10.2.min.js"></script>
  <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="js/jquery-migrate-1.2.1.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/modernizr.min.js"></script>
  <script src="js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
  <script src="js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="js/scripts.js"></script>

</body>

</html>