<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
  header('Location: login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Teachers</title>
  <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
      <div class="row">
        <div class="col-lg-12">
          <section class="panel">
            <header class="panel-heading">
              Teachers
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table">
                <thead>
                  <tr>
                    <th>Img</th>
                    <th>Full Names</th>
                    <th>Gender</th>
                    <th>Phone</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $teachers = mysqli_query($con, "SELECT * FROM teachers WHERE status=1");
                  if ($teachers) {
                    while ($row = mysqli_fetch_assoc($teachers)) {
                      $teacher_id = (int) ($row['teacher_id'] ?? 0);
                      $fullname = $row['fullname'] ?? '';
                      $gender = $row['gender'] ?? '';
                      $phone = $row['phone'] ?? '';
                      $design = $row['designation'] ?? '';
                      $status = (int) ($row['status'] ?? 0);
                      $ext = $row['ext'] ?? '';
                  ?>
                    <tr class="gradeA">
                      <td>
                        <?php if (!empty($ext)) { ?>
                          <img src="<?php echo htmlspecialchars('images/teachers/thumbs/' . md5($teacher_id) . '.' . $ext); ?>" width="80" alt="<?php echo htmlspecialchars($fullname); ?>">
                        <?php } else { ?>
                          <img src="images/avatar.png" width="80" alt="avatar">
                        <?php } ?>
                      </td>
                      <td><?php echo htmlspecialchars($fullname); ?></td>
                      <td><?php echo htmlspecialchars($gender); ?></td>
                      <td><?php echo htmlspecialchars($phone); ?></td>

                      <td><a href="viewteacher?id=<?php echo $teacher_id; ?>" class="btn btn-success btn-xs"><i class="fa fa-list"></i> Details</a>

                        <?php
                        if ($_SESSION['schoolsyslevel'] == 1) { ?>
                          <a href="edit_teacher?id=<?php echo $teacher_id; ?>" class="btn btn-warning btn-xs"><i class="fa fa-edit"></i>Edit</a>
                          <a href="deactivateteacher?id=<?php echo $teacher_id; ?>&status=<?php echo $status; ?>" class="btn btn-danger btn-xs" onclick="return confirm_delete<?php echo $teacher_id; ?>()"><i class="fa fa-times"></i> Remove</a>
                          <script type="text/javascript">
                            function confirm_delete<?php echo $teacher_id; ?>() {
                              return confirm('You are about To Remove this Teacher. Are you sure you want to proceed?');
                            }
                          </script>
                        <?php  } ?>

                      </td>
                    </tr>
                  <?php }
                  } ?>
                </tbody>
              </table>
            </div>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>

  <!-- Placed js at the end of the document so the pages load faster -->
  <script src="js/jquery-1.10.2.min.js"></script>
  <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="js/jquery-migrate-1.2.1.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/modernizr.min.js"></script>
  <script src="js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
  <script src="js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="js/scripts.js"></script>

</body>

</html>