<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location:login.php');
  exit;
}

// validate and cast inputs
$sub = filter_input(INPUT_GET, 'sub', FILTER_VALIDATE_INT);
$cl = filter_input(INPUT_GET, 'cl', FILTER_VALIDATE_INT);
$sub = $sub ? (int)$sub : 0;
$cl = $cl ? (int)$cl : 0;

// teacher from session
$teacher_session_id = (int)($_SESSION['teachersys'] ?? 0);

// fetch class info
$class = '';
$category_id = 0;
$cls_stmt = mysqli_prepare($con, "SELECT class, category_id FROM classes WHERE class_id = ? LIMIT 1");
if ($cls_stmt) {
    mysqli_stmt_bind_param($cls_stmt, 'i', $cl);
    mysqli_stmt_execute($cls_stmt);
    $cls_res = mysqli_stmt_get_result($cls_stmt);
    if ($cls_res && ($crow = mysqli_fetch_assoc($cls_res))) {
        $class = $crow['class'] ?? '';
        $category_id = $crow['category_id'] ?? 0;
    }
    mysqli_stmt_close($cls_stmt);
}

// fetch subject name
$subject = '';
$subj_stmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
if ($subj_stmt) {
    mysqli_stmt_bind_param($subj_stmt, 'i', $sub);
    mysqli_stmt_execute($subj_stmt);
    $subj_res = mysqli_stmt_get_result($subj_stmt);
    if ($subj_res && ($srow = mysqli_fetch_assoc($subj_res))) {
        $subject = $srow['subject'] ?? '';
    }
    mysqli_stmt_close($subj_stmt);
}


?>
<html>

<head>

  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title><?php echo $subject . ' : ' . $class; ?> | School Manager</title>

  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body>
  <section>
    <?php include 'nav.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-12">
          <?php
          // get class_sub_id
          $class_sub_id = 0;
          $cs_stmt = mysqli_prepare($con, "SELECT class_sub_id FROM class_subjects WHERE class_id = ? AND subject_id = ? LIMIT 1");
          if ($cs_stmt) {
              mysqli_stmt_bind_param($cs_stmt, 'ii', $cl, $sub);
              mysqli_stmt_execute($cs_stmt);
              $cs_res = mysqli_stmt_get_result($cs_stmt);
              if ($cs_res && ($csr = mysqli_fetch_assoc($cs_res))) {
                  $class_sub_id = (int)($csr['class_sub_id'] ?? 0);
              }
              mysqli_stmt_close($cs_stmt);
          }

          if ($category_id == 3) { ?>
            <a href="addmidtermplan?id=<?php echo htmlspecialchars($class_sub_id, ENT_QUOTES); ?>" class="btn btn-info">Add  Plan</a><br /><br />
          <?php } else { ?>
            <a href="addmidtermplan?id=<?php echo htmlspecialchars($class_sub_id, ENT_QUOTES); ?>" class="btn btn-info">Add Plan</a><br /><br />
          <?php } ?>
          <section class="panel">
            <header class="panel-heading">
              <?php echo $subject . ' : ' . $class; ?> Mid Term Plans
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table">
                <thead>
                  <tr>
                    <th>Month</th>
                    <th>Term</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
          <?php
          // fetch midterm plans for this class/subject and teacher
          $mp_stmt = mysqli_prepare($con, "SELECT midterm_plan_id, month, teacher_id, term FROM midterm_plans WHERE class_sub_id = ? AND teacher_id = ? AND status = 1");
          if ($mp_stmt) {
            mysqli_stmt_bind_param($mp_stmt, 'ii', $class_sub_id, $teacher_session_id);
            mysqli_stmt_execute($mp_stmt);
            $mp_res = mysqli_stmt_get_result($mp_stmt);
            while ($row = mysqli_fetch_assoc($mp_res)) {
              $weeklyplan_id = (int)($row['midterm_plan_id'] ?? 0);
              $month = $row['month'] ?? '';
              $teacher_id = (int)($row['teacher_id'] ?? 0);
              $term_value = (int)($row['term'] ?? 0);
              // fetch term name
              $term = '';
              $year = '';
              $term_stmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE status = 1 AND financialterm_id = ? LIMIT 1");
              if ($term_stmt) {
                mysqli_stmt_bind_param($term_stmt, 'i', $term_value);
                mysqli_stmt_execute($term_stmt);
                $tres = mysqli_stmt_get_result($term_stmt);
                if ($tres && ($trow = mysqli_fetch_assoc($tres))) {
                  $term = $trow['term'] ?? '';
                  $year = $trow['year'] ?? '';
                }
                mysqli_stmt_close($term_stmt);
              }
          ?>
                    <tr class="gradeA">
                      <td><?php echo htmlspecialchars(getMonthName($month), ENT_QUOTES); ?></td>
                      <td>Term <?php echo htmlspecialchars($term, ENT_QUOTES); ?></td>
                      <td><a href="midtermplan?id=<?php echo htmlspecialchars($weeklyplan_id, ENT_QUOTES); ?>" class="btn btn-success btn-xs">Details</a>
                        <!--<a href="editweeklyplan?id=<?php echo $weeklyplan_id; ?>" class="btn btn-info btn-xs">Edit</a>-->
                        <a href="removemidtermplan?id=<?php echo htmlspecialchars($weeklyplan_id, ENT_QUOTES); ?>" class="btn btn-danger btn-xs" onclick="return confirm_delete<?php echo $weeklyplan_id; ?>()">Remove</a>
                      </td>
                    </tr>
                    <script type="text/javascript">
                      function confirm_delete<?php echo $weeklyplan_id; ?>() {
                        return confirm('You are about To Remove this Student. Are you sure you want to proceed?');
                      }
                    </script>
                  <?php } mysqli_stmt_close($mp_stmt); } ?>
                </tbody>
              </table>

            </div>
          </section>
        </div>

      </div>

    </section>
    </div>
    <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>

</html>